/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.autoemul;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.autoemul.preferences.AutoEmulPreferencesManager;
import org.tizen.common.autoemul.wizard.AutoEmulGenWizardDialog;
import org.tizen.common.autoemul.wizard.AutoEmulWizard;
import org.tizen.common.util.ViewUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.SmartDevelopmentBridge;

public class AutomationEmulator {
    private Logger logger = LoggerFactory.getLogger(AutomationEmulator.class);
    IProject iproject;

    public AutomationEmulator(IProject iproject) {
        this.iproject = iproject;
    }

    public boolean openAutoEmulWizard() {
        AutoEmulWizard tgWizard = new AutoEmulWizard(ViewUtil.getWorkbenchWindow().getShell(), this.iproject);
        AutoEmulGenWizardDialog ggwDialog = new AutoEmulGenWizardDialog(ViewUtil.getWorkbenchWindow().getShell(), (IWizard)tgWizard);
        ggwDialog.setHelpAvailable(true);
        ggwDialog.create();
        int result = ggwDialog.open();
        if (result == 0 && !AutoEmulPreferencesManager.timeOut) {
            return true;
        }
        if (AutoEmulPreferencesManager.timeOut) {
            this.logger.error("failed to launch application by timeout (50sec)");
        }
        return false;
    }

    public IDevice saveLatestDeviceInfo(IProject project) {
        String selectedDeviceName = AutoEmulGenWizardDialog.getSelectionDeviceName();
        IDevice[] iDeviceArray = SmartDevelopmentBridge.getBridge().getDevices();
        int n = iDeviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDevice iDevice = iDeviceArray[n2];
            if (iDevice.getDeviceName().equals(selectedDeviceName)) {
                try {
                    project.setPersistentProperty(AutoEmulPreferencesManager.LATEST_SPECIFIC_DEVICE_PER_PROJECT_PROJECT, iDevice.getDeviceName());
                }
                catch (CoreException e) {
                    this.logger.warn("fail to save DeviceInfo", (Throwable)e);
                }
                return iDevice;
            }
            ++n2;
        }
        return null;
    }
}

