/*
 * Decompiled with CFR 0.152.
 */
package javaewah32;

import javaewah.IntIterator;
import javaewah32.EWAHIterator32;
import javaewah32.RunningLengthWord32;

final class IntIteratorImpl32
implements IntIterator {
    private final EWAHIterator32 ewahIter;
    private final int[] ewahBuffer;
    private int position;
    private int runningLength;
    private int word;
    private int wordPosition;
    private int wordLength;
    private int literalPosition;

    IntIteratorImpl32(EWAHIterator32 ewahIter) {
        this.ewahIter = ewahIter;
        this.ewahBuffer = ewahIter.buffer();
    }

    public final boolean hasNext() {
        while (!this.runningHasNext() && !this.literalHasNext()) {
            if (!this.ewahIter.hasNext()) {
                return false;
            }
            this.setRunningLengthWord(this.ewahIter.next());
        }
        return true;
    }

    public final int next() {
        if (this.runningHasNext()) {
            return this.position++;
        }
        int bit = Integer.numberOfTrailingZeros(this.word);
        this.word = (int)((long)this.word ^ 1L << bit);
        return this.literalPosition + bit;
    }

    private final void setRunningLengthWord(RunningLengthWord32 rlw) {
        this.runningLength = 32 * rlw.getRunningLength() + this.position;
        if (!rlw.getRunningBit()) {
            this.position = this.runningLength;
        }
        this.wordPosition = this.ewahIter.dirtyWords();
        this.wordLength = this.wordPosition + rlw.getNumberOfLiteralWords();
    }

    private final boolean runningHasNext() {
        return this.position < this.runningLength;
    }

    private final boolean literalHasNext() {
        while (this.word == 0 && this.wordPosition < this.wordLength) {
            this.word = this.ewahBuffer[this.wordPosition++];
            this.literalPosition = this.position;
            this.position += 32;
        }
        return this.word != 0;
    }
}

