/*
 * Web IDE - Command Line Interface
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: 
 * BonYong Lee <bonyong.lee@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */
package org.tizen.cli.exec;

import static org.tizen.common.core.command.Policy.EXIST_OUT_FILE;
import static org.tizen.common.core.command.Policy.NONEXIST_IN_FILE;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.Factory;
import org.tizen.common.core.command.Policy;
import org.tizen.common.core.command.policy.AbstractPolicy;
import org.tizen.common.core.command.policy.FilePolicy;
import org.tizen.common.core.command.policy.MessagePolicy;
import org.tizen.common.core.command.policy.OptionPolicy;
import org.tizen.common.core.command.policy.PolicyRegistry;
import org.tizen.common.core.command.prompter.FileHandlingOption;

/**
 * <p>
 * PolicyRegistryFactory.
 * 
 * {@link Factory} to provide {@link PolicyRegistry}
 * 
 * </p>
 * 
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 */
public class
PolicyRegistryFactory
implements Factory<PolicyRegistry>
{
	/**
	 * Logger for this instance
	 */
	protected final Logger logger =
		LoggerFactory.getLogger( PolicyRegistryFactory.class );
	
	/**
	 * <p>
	 * CLIPolicy.
	 * 
	 * {@link Policy} when command line interface
	 * </p>
	 * 
	 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
	 * 
	 * @see PolicyRegistry, {@link Policy}
	 */
	class CLIPolicy 
	extends AbstractPolicy
	{
		/**
		 * <p>
		 * Constructor with <code>name</code>
		 * </p>
		 * 
		 * @param name policy name
		 */
		public CLIPolicy( final String name )
		{
			super( name );
		}

		/* (non-Javadoc)
		 * @see org.tizen.common.Adaptable#adapt(java.lang.Class)
		 */
		@Override
		@SuppressWarnings("unchecked")
		public <T>
		T
		adapt(
			final Class<T> clazz
		)
		{
			if ( clazz.isAssignableFrom( FilePolicy.class ) )
			{
				return (T) FilePolicy.STOP_PROCESS;
			}
			else if ( clazz.isAssignableFrom( MessagePolicy.class) )
			{
				return (T) MessagePolicy.PROMPTER;
			}
			return null;
		}

	}
	/* (non-Javadoc)
	 * @see org.tizen.common.Factory#create()
	 */
	@Override
	public
	PolicyRegistry
	create()
	{
		final PolicyRegistry registry = new PolicyRegistry();
		
		registry.register( new CLIPolicy( EXIST_OUT_FILE ) );
		registry.register( new CLIPolicy( NONEXIST_IN_FILE ) );
		
		CLIPolicy existFileWhenCopy = new CLIPolicy(Policy.EXIST_FILE_WHEN_COPY) {
			
			@SuppressWarnings("unchecked")
			@Override
			public <T> T adapt(Class<T> clazz) {
				return (T)(new OptionPolicy(FileHandlingOption.OVERWRITE, FileHandlingOption.IGNORE, FileHandlingOption.OVERWRITE_ALL, FileHandlingOption.IGNORE_ALL, FileHandlingOption.CANCEL));
			}
		};
		
		registry.register(existFileWhenCopy);
		return registry;
	}

}
