/*
 * Command line interface
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: 
 * BonYong Lee <bonyong.lee@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */
package org.tizen.cli.command;

import java.io.IOException;
import java.util.HashMap;

import org.tizen.cli.util.TemplateModelProvider;
import org.tizen.common.core.command.ExecutionContext;
import org.tizen.common.verrari.Realm;
import org.tizen.common.verrari.Storage;
import org.tizen.common.verrari.Template;
import org.tizen.common.verrari.TemplateContext;
import org.tizen.common.verrari.TemplateException;
import org.tizen.common.verrari.realm.CommonRealm;
import org.tizen.common.verrari.storage.FileStorage;
import org.tizen.common.verrari.template.TemplateConstants;

public class CreateTemplate
extends AbstractCommand
implements CommandWithParameter
{
    
    @Override
    public void process(
        final ExecutionContext context,
        final String[] args
    ) throws IOException, TemplateException
    {
        if ( null == args || 0 == args.length )
        {
            context.getPrompter().error( "One more template id required." );
            return ;
        }
        final Realm realm = (Realm) context.getValue( PluginConstants.REALM );
        
        final FileStorage storage = new FileStorage( context.getFileHandler() );
        
        final TemplateModelProvider models = new TemplateModelProvider( context );
        
        TemplateContext.getInstance().setModelProvider( models );
        
        try
        {
            template( realm, args, models, storage );
        }
        finally
        {
            TemplateContext.clear();
        }
        
    }

    protected void
    template(
        final Realm realm,
        final String[] names,
        final TemplateModelProvider models,
        final Storage storage
    ) throws IOException, TemplateException
    {
        final HashMap<String, Template> ret = new HashMap<String, Template>();
        
        template( realm, names, models, storage, ret );
    }

    protected
    void
    template(
        final Realm realm,
        final String[] names,
        final TemplateModelProvider models,
        final Storage storage,
        final HashMap<String, Template> cache
    )
    throws IOException, TemplateException
    {
        for ( final String name : names )
        {
            logger.trace( "Template name :{}", name );
            
            ExecutionContext.getCurrentContext().setValue( "id", name );
            
            Template template = cache.get( name );
            if ( null == template )
            {
                logger.debug( "{} not cached", name );
                template = realm.getTemplate( name );
            }
            cache.put( name, template );
            template.template( models, storage );
            final String[] dependencies = CommonRealm.separate( template.getAttribute( TemplateConstants.ATTR_DEPENDENCY ) );
            if ( null == dependencies )
            {
                continue;
            }
            
            template( realm, dependencies, models, storage, cache );
        }
        
    }

}
