/*
 * Web IDE - Command Line Interface
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: 
 * BonYong Lee <bonyong.lee@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */
package org.tizen.cli.exec;

import java.text.MessageFormat;

import org.tizen.common.Factory;
import org.tizen.common.core.command.ExecutionContext;
import org.tizen.common.core.command.Executor;
import org.tizen.common.core.command.Prompter;
import org.tizen.common.core.command.policy.PolicyRegistry;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.StandardFileHandler;

/**
 * <p>
 * CommandLineExecutor.
 * 
 * {@link Executor} for commaand line interface
 * </p>
 * 
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 */
public class
CommandLineExecutor
extends Executor
{

	/**
	 * Contructor with prompter
	 * 
	 * @param prompter {@link Prompter}
	 */
	public
	CommandLineExecutor(
		final Prompter prompter
	)
	{
		super(
			new Factory<ExecutionContext>() {
				
				/**
				 * {@link FileHandler} for Command Line Interface
				 */
				protected FileHandler fileHandler = new StandardFileHandler();
				
				
				/**
				 * <p>
				 * {@link PolicyRegistry} for Command Line Interface
				 * </p>
				 */
				protected Factory<PolicyRegistry> factory = new PolicyRegistryFactory();
				
				/**
				 * Create and return {@link PolicyRegistry}
				 * 
				 * @return {@link PolicyRegistry} to be created
				 */
				protected
				PolicyRegistry
				getRegistry()
				{
					return factory.create();
				}
				
				/**
				 * {@link ExecutionContext} for Command Line Interface
				 */
				protected
				final
				ExecutionContext context = new ExecutionContext(
					getRegistry(),
					prompter,
					fileHandler
				);
				
				/* (non-Javadoc)
				 * @see org.tizen.common.core.command.ExecutionContextFactory#create()
				 */
				@Override
				public
				ExecutionContext
				create()
				{
					return context;
				}
				
				/* (non-Javadoc)
				 * @see java.lang.Object#toString()
				 */
				@Override
				public
				String
				toString()
				{
					return MessageFormat.format(
						"Policy :{0}, Prompter :{1}, File Handler :{2}",
						context.getPolicyRegistry(),
						context.getPrompter(),
						context.getFileHandler()
					);
				};
			}
		);
	}

}
