/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalysis.ide.eplugin.popup.actions;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.tizen.dynamicanalysis.ide.eplugin.DALog;

public class InteractiveUtil {
    private static final int NOT_EXIST = -1;

    public static IEditorInput getEditorInput(IResource resource) {
        if (resource instanceof IFile) {
            return new FileEditorInput((IFile)resource);
        }
        return null;
    }

    public static boolean isValidVariable(IASTName name) {
        IBinding b;
        return name != null && (b = name.resolveBinding()) != null && b instanceof IVariable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidLine(ITranslationUnit tu, int line, int offset, IDocument doc) {
        try {
            ICElement[] celements;
            ICElement[] iCElementArray = celements = tu.getChildren();
            int n = celements.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                ICElement celement = iCElementArray[n2];
                ISourceRange range = ((ISourceReference)celement).getSourceRange();
                int startLine = range.getStartLine();
                int endLine = range.getEndLine();
                if (line >= startLine && line <= endLine) {
                    if (celement.getElementType() != 74) return false;
                    int functionBodyStartOffset = InteractiveUtil.findFunctionBodyStartOffset(range.getStartPos(), doc);
                    if (functionBodyStartOffset == -1) return false;
                    if (offset > functionBodyStartOffset) return true;
                    return false;
                }
                ++n2;
            }
        }
        catch (CModelException e) {
            DALog.printLog((Exception)((Object)e));
        }
        return false;
    }

    public static String makeFullVariableName(IASTName target) {
        String fullName = target.toString();
        if (target.getCompletionContext() == null || !(target.getCompletionContext() instanceof IASTExpression)) {
            return fullName;
        }
        IASTExpression cursor = (IASTExpression)target.getCompletionContext();
        if (cursor != null && cursor instanceof IASTFieldReference) {
            cursor = ((IASTFieldReference)cursor).getFieldOwner();
            while (cursor != null) {
                if (cursor instanceof IASTFieldReference) {
                    fullName = cursor.getExpressionType() instanceof IPointerType ? String.valueOf(((IASTFieldReference)cursor).getFieldName().toString()) + "->" + fullName : String.valueOf(((IASTFieldReference)cursor).getFieldName().toString()) + "." + fullName;
                    cursor = ((IASTFieldReference)cursor).getFieldOwner();
                    continue;
                }
                if (!(cursor instanceof IASTIdExpression)) break;
                if (cursor.getExpressionType() instanceof IPointerType) {
                    fullName = String.valueOf(((IASTIdExpression)cursor).getName().toString()) + "->" + fullName;
                    break;
                }
                fullName = String.valueOf(((IASTIdExpression)cursor).getName().toString()) + "." + fullName;
                break;
            }
        }
        return fullName;
    }

    private static int findFunctionBodyStartOffset(int functionStartOffset, IDocument doc) {
        int cursorOffset = functionStartOffset;
        while (cursorOffset < doc.getLength()) {
            try {
                if (doc.getChar(cursorOffset) == '{') {
                    return cursorOffset;
                }
                ++cursorOffset;
            }
            catch (BadLocationException e) {
                DALog.printLog((Exception)((Object)e));
            }
        }
        return -1;
    }
}

