/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.launch.ui.shortcut;

import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.gom.launch.GomDebugAttachLaunchData;
import org.tizen.common.gom.launch.GomLaunchData;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.launch.LaunchUtils;
import org.tizen.nativecommon.launch.TizenLaunchMessages;
import org.tizen.nativecommon.launch.ui.shortcut.TizenLaunchShortcut;

public class TizenApplicationAttachLaunchShortcut
extends TizenLaunchShortcut {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    @Override
    protected void setStopAtMain(ILaunchConfigurationWorkingCopy configuration, IProject proj) {
        configuration.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", false);
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_AUTO_SOLIB, true);
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_VERBOSE_MODE, true);
    }

    @Override
    protected ILaunchConfiguration findLaunchConfiguration(IBinary bin, String mode) {
        ILaunchConfiguration configuration = super.findLaunchConfiguration(bin, mode);
        if (configuration == null) {
            return null;
        }
        try {
            ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
            wc.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
            IProject project = ProjectUtil.getProject(wc.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", ""));
            if (project == null) {
                LaunchUtils.newCoreException(TizenLaunchMessages.PROJECT_NOT_FOUND, null);
            }
            String appId = ProjectUtil.getAppId(project);
            wc.setAttribute("org.tizen.nativecommon.launch.app.id", appId);
            wc.doSave();
        }
        catch (CoreException e) {
            CDebugUIPlugin.log((Throwable)e);
            this.logger.error("Failed to set an attribute in configuration");
        }
        return configuration;
    }

    @Override
    public ILaunchConfigurationType getCLaunchConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType("org.tizen.nativecommon.launch.TizenAttachConfigurationType");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ILaunchConfiguration createConfiguration(GomLaunchData data) {
        ILaunchConfiguration configuration = null;
        String appId = null;
        try {
            ILaunchConfigurationWorkingCopy wc;
            if (data instanceof GomDebugAttachLaunchData) {
                configuration = this.findConfiguration(data);
                if (configuration == null && (configuration = super.createConfiguration(data)) == null) {
                    return null;
                }
                wc = configuration.getWorkingCopy();
                GomDebugAttachLaunchData attachData = (GomDebugAttachLaunchData)data;
                appId = attachData.getAppId();
                wc.setAttribute("org.tizen.nativecommon.launch.AUTO_DEBUG_ATTACH_ATTR", true);
            } else {
                configuration = super.createConfiguration(data);
                if (configuration == null) {
                    return null;
                }
                wc = configuration.getWorkingCopy();
                appId = ProjectUtil.getAppId(data.getProject());
            }
            wc.setAttribute("org.tizen.nativecommon.launch.app.id", appId);
            return wc.doSave();
        }
        catch (CoreException e) {
            CDebugUIPlugin.log((Throwable)e);
            this.logger.error("Failed to set an attribute in configuration");
        }
        return configuration;
    }

    private ILaunchConfiguration findConfiguration(GomLaunchData data) {
        ILaunchConfiguration configuration = null;
        ILaunchConfigurationType configType = this.getCLaunchConfigType();
        try {
            ILaunchConfiguration[] configs;
            ILaunchConfiguration[] iLaunchConfigurationArray = configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (data.getLaunchConfigurationName().equals(config.getName())) {
                    configuration = config;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            CDebugUIPlugin.log((Throwable)e);
            this.logger.error("Failed to get configuration list");
        }
        return configuration;
    }
}

