/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.ui.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.command.factories.CommandFactoryDescriptor;
import org.eclipse.cdt.debug.mi.internal.ui.MIUIMessages;
import org.eclipse.cdt.dsf.debug.internal.ui.preferences.StringWithBooleanFieldEditor;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.LaunchUIMessages;
import org.eclipse.cdt.dsf.mi.service.command.AbstractCLIProcess;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.tizen.nativecommon.Activator;
import org.tizen.nativecommon.launch.TizenLaunchConfigurationConstants;
import org.tizen.nativecommon.launch.TizenLaunchMessages;

public class TizenNativeDebugPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    protected Combo fCommandFactoryCombo;
    protected Combo fProtocolCombo;
    public static String KEY_STOP_AT_MAIN = "stopmain";
    public static boolean VALUE_STOP_AT_MAIN_DEFAULT = TizenLaunchConfigurationConstants.DEBUGGER_STOP_AT_MAIN_DEFAULT;
    public static String KEY_STOP_AT_MAIN_SYMBOL = "stopmainsymbol";
    public static String VALUE_STOP_AT_MAIN_SYMBOL_DEFAULT = TizenLaunchConfigurationConstants.DEBUGGER_CPP_MAIN_ENTRY_NAME;
    public static String KEY_COMMAND_SET = "commandset";
    public static String VALUE_COMMAND_SET_DEFAULT = "org.tizen.nativecommon.launch.TizenCommandFactory";
    public static String KEY_PROTOCOL = "protocol";
    public static String VALUE_PROTOCOL_DEFAULT = "mi";
    public static String KEY_VERBOSE_MODE = "verbosemode";
    public static boolean VALUE_VERBOSE_MODE_DEFAULT = false;
    public static String KEY_FULLPATH_BREAKPOINTS = "fullpathbreakpoint";
    public static boolean VALUE_FULLPATH_BREAKPOINTS_DEFAULT = false;
    public static String KEY_SHOW_WARNING = "gdbwarning";
    public static boolean VALUE_SHOW_WARNING_DEFAULT = TizenLaunchConfigurationConstants.DEBUGGER_SHOW_WARNING_DEFAULT;
    private IPreferenceStore store = Activator.getDefault().getPreferenceStore();
    private CommandFactoryDescriptor[] fCommandFactoryDescriptors;
    private Composite indentHelper;
    private ListenableBooleanFieldEditor enablePrettyPrintingField;
    private IntegerFieldEditor childCountLimitField;
    BooleanFieldEditor gdbWarningOption;

    public TizenNativeDebugPreferencePage() {
        this.setPreferenceStore(this.store);
        this.setDescription(TizenLaunchMessages.DEBUG_PREFERENCEPAGE_DESCRIPTION);
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        return super.createContents(parent);
    }

    protected void initialize() {
        super.initialize();
        IPreferenceStore gdbStore = GdbUIPlugin.getDefault().getPreferenceStore();
        this.enablePrettyPrintingField.setPreferenceStore(gdbStore);
        this.enablePrettyPrintingField.load();
        this.childCountLimitField.setPreferenceStore(gdbStore);
        this.childCountLimitField.load();
        boolean prettyPrintingEnabled = gdbStore.getBoolean("enablePrettyPrinting");
        this.childCountLimitField.setEnabled(prettyPrintingEnabled, this.indentHelper);
    }

    protected BooleanFieldEditor createWarningMessageOption(Group group1) {
        BooleanFieldEditor option = new BooleanFieldEditor(KEY_SHOW_WARNING, TizenLaunchMessages.DEBUG_PREFERENCEPAGE_WARNING_OPTION, (Composite)group1);
        option.fillIntoGrid((Composite)group1, 1);
        this.addField((FieldEditor)option);
        return option;
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Group group1 = new Group(parent, 0);
        group1.setText(TizenLaunchMessages.DEBUG_PREFERENCEPAGE_GROUP1);
        GridLayout groupLayout = new GridLayout(2, false);
        group1.setLayout((Layout)groupLayout);
        group1.setLayoutData((Object)new GridData(768));
        StringWithBooleanFieldEditor enableStopAtMain = new StringWithBooleanFieldEditor(KEY_STOP_AT_MAIN, KEY_STOP_AT_MAIN_SYMBOL, LaunchUIMessages.getString((String)"CDebuggerTab.Stop_at_main_on_startup"), (Composite)group1);
        enableStopAtMain.fillIntoGrid((Composite)group1, 2);
        this.addField((FieldEditor)enableStopAtMain);
        this.gdbWarningOption = this.createWarningMessageOption(group1);
        Composite options = ControlFactory.createCompositeEx((Composite)group1, (int)2, (int)768);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        options.setLayoutData((Object)gd);
        group1.setLayout((Layout)groupLayout);
        Group group2 = new Group(parent, 0);
        group2.setText(TizenLaunchMessages.DEBUG_PREFERENCEPAGE_GROUP2);
        GridLayout groupLayout2 = new GridLayout(3, false);
        group2.setLayout((Layout)groupLayout2);
        group2.setLayoutData((Object)new GridData(768));
        this.enablePrettyPrintingField = new ListenableBooleanFieldEditor("enablePrettyPrinting", TizenLaunchMessages.DEBUG_PREFERENCEPAGE_PRETTY_PRINTING, 0, (Composite)group2);
        this.enablePrettyPrintingField.fillIntoGrid((Composite)group2, 3);
        this.addField((FieldEditor)this.enablePrettyPrintingField);
        this.indentHelper = new Composite((Composite)group2, 0);
        GridLayout helperLayout = new GridLayout(3, false);
        this.indentHelper.setLayout((Layout)helperLayout);
        GridData helperData = new GridData(4, 4, true, false, 3, 1);
        helperData.horizontalIndent = 20;
        this.indentHelper.setLayoutData((Object)helperData);
        this.childCountLimitField = new IntegerFieldEditor("initialChildCountLimitForCollections", TizenLaunchMessages.DEBUG_PREFERENCEPAGE_COUNT_LIMIT, this.indentHelper);
        this.childCountLimitField.setValidRange(1, 10000);
        this.childCountLimitField.fillIntoGrid(this.indentHelper, 3);
        this.addField((FieldEditor)this.childCountLimitField);
        this.enablePrettyPrintingField.getChangeControl((Composite)group2).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = TizenNativeDebugPreferencePage.this.enablePrettyPrintingField.getBooleanValue();
                TizenNativeDebugPreferencePage.this.childCountLimitField.setEnabled(enabled, TizenNativeDebugPreferencePage.this.indentHelper);
            }
        });
        this.indentHelper.setLayout((Layout)helperLayout);
        group2.setLayout((Layout)groupLayout2);
    }

    private void handleBrowseButtonSelected(String dialogTitle, StringFieldEditor stringFieldEditor) {
        String res;
        FileDialog dialog = new FileDialog(this.getShell(), 0);
        dialog.setText(dialogTitle);
        String gdbCommand = stringFieldEditor.getStringValue().trim();
        int lastSeparatorIndex = gdbCommand.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(gdbCommand.substring(0, lastSeparatorIndex));
        }
        if ((res = dialog.open()) == null) {
            return;
        }
        stringFieldEditor.setStringValue(res);
    }

    protected void createCommandFactoryCombo(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(MIUIMessages.getString((String)"StandardGDBDebuggerPage.12"));
        this.fCommandFactoryCombo = new Combo(parent, 12);
    }

    protected void createProtocolCombo(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(MIUIMessages.getString((String)"StandardGDBDebuggerPage.11"));
        this.fProtocolCombo = new Combo(parent, 12);
    }

    protected void createVerboseModeButton(Composite parent) {
        BooleanFieldEditor enableVerboseMode = new BooleanFieldEditor(KEY_VERBOSE_MODE, MIUIMessages.getString((String)"StandardGDBDebuggerPage.13"), 0, parent);
        enableVerboseMode.fillIntoGrid(parent, 2);
        this.addField((FieldEditor)enableVerboseMode);
    }

    protected void createBreakpointFullPathName(Composite parent) {
        BooleanFieldEditor enableBreakFullPath = new BooleanFieldEditor(KEY_FULLPATH_BREAKPOINTS, MIUIMessages.getString((String)"StandardGDBDebuggerPage.14"), 0, parent);
        enableBreakFullPath.fillIntoGrid(parent, 2);
        this.addField((FieldEditor)enableBreakFullPath);
    }

    private void initializeData() {
        ICDebugConfiguration[] debugConfigs = CDebugCorePlugin.getDefault().getDebugConfigurations();
        String debuggerID = null;
        ArrayList<ICDebugConfiguration> list = new ArrayList<ICDebugConfiguration>();
        int i = 0;
        while (i < debugConfigs.length) {
            ICDebugConfiguration configuration = debugConfigs[i];
            if (configuration.getID().equals("gdbserver")) {
                list.add(configuration);
                debuggerID = configuration.getID();
            }
            ++i;
        }
        this.fCommandFactoryDescriptors = MIPlugin.getDefault().getCommandFactoryManager().getDescriptors(debuggerID);
        Arrays.sort(this.fCommandFactoryDescriptors, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return ((CommandFactoryDescriptor)arg0).getName().compareTo(((CommandFactoryDescriptor)arg1).getName());
            }
        });
        String[] descLabels = new String[this.fCommandFactoryDescriptors.length];
        String commandFactoryId = "org.tizen.nativecommon.launch.TizenCommandFactory";
        int index = -1;
        int i2 = 0;
        while (i2 < this.fCommandFactoryDescriptors.length) {
            descLabels[i2] = this.fCommandFactoryDescriptors[i2].getName();
            if (this.fCommandFactoryDescriptors[i2].getIdentifier().equals(commandFactoryId)) {
                index = i2;
            }
            ++i2;
        }
        this.fCommandFactoryCombo.setItems(descLabels);
        if (index < 0) {
            index = 0;
        }
        String[] miVersions = new String[]{};
        if (index < this.fCommandFactoryDescriptors.length) {
            this.fCommandFactoryCombo.select(index);
            miVersions = this.fCommandFactoryDescriptors[index].getMIVersions();
        }
        this.fProtocolCombo.setItems(miVersions);
        if (miVersions.length == 0) {
            miVersions = new String[]{"mi"};
        }
        String mi = "mi";
        int miIndex = 0;
        int i3 = 0;
        while (i3 < miVersions.length) {
            if (miVersions[i3].equals(mi)) {
                miIndex = i3;
                break;
            }
            ++i3;
        }
        this.fProtocolCombo.select(miIndex);
    }

    public boolean performOk() {
        super.performOk();
        AbstractCLIProcess.setShowWarningMsg((boolean)this.gdbWarningOption.getBooleanValue());
        if (this.fCommandFactoryCombo != null) {
            String str = this.fCommandFactoryCombo.getText();
            int index = this.fCommandFactoryCombo.indexOf(str);
            str = index < 0 ? "" : this.fCommandFactoryDescriptors[index].getIdentifier();
            this.store.setValue(KEY_COMMAND_SET, str);
            str = this.fProtocolCombo.getText();
            this.store.setValue(KEY_PROTOCOL, str);
        }
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        boolean enabled = this.enablePrettyPrintingField.getBooleanValue();
        this.childCountLimitField.setEnabled(enabled, this.indentHelper);
    }

    private class ListenableBooleanFieldEditor
    extends BooleanFieldEditor {
        public ListenableBooleanFieldEditor(String name, String labelText, int style, Composite parent) {
            super(name, labelText, style, parent);
        }

        public Button getChangeControl(Composite parent) {
            return super.getChangeControl(parent);
        }
    }
}

