/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.cli;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.tizen.common.util.OSChecker;

public class SetterUtil {
    private static final String EMPTY_STRING = "";
    private static final String WHITESPACE = " ";
    private static final String DEF_WORKSPACE = "$(workspace_loc)";

    public static String convertWorkspacePathToMacro(String path) {
        String workspacePath;
        if (OSChecker.isWindows()) {
            path = path.replace("/", "\\");
        }
        if ((workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString()).length() < path.length()) {
            if (path.startsWith(String.valueOf(workspacePath) + "/") || path.startsWith(String.valueOf(workspacePath) + "\\")) {
                path = path.replace(workspacePath, DEF_WORKSPACE);
            }
        } else if (workspacePath.length() == path.length() && path.equals(workspacePath)) {
            path = path.replace(workspacePath, DEF_WORKSPACE);
        }
        return path.isEmpty() ? EMPTY_STRING : path;
    }

    public static boolean isUnderProjectPath(IProject project, String path) {
        IPath projectPath = project.getLocation();
        Path targetPath = new Path(path);
        int i = 0;
        while (i < projectPath.segmentCount()) {
            String targetSeg;
            String projectSeg = projectPath.segment(i);
            if (!projectSeg.equals(targetSeg = targetPath.segment(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String convertRelativePath(IProject project, String path) {
        String projectPath = project.getLocation().toOSString();
        if (path.startsWith(projectPath)) {
            if ((path = path.replace(projectPath, EMPTY_STRING)).isEmpty()) {
                return ".";
            }
            if (path.charAt(0) == '/' || path.charAt(0) == '\\') {
                path = path.substring(1);
            }
        }
        return path.isEmpty() ? EMPTY_STRING : path;
    }

    public static String encloseDoubleQuotes(String path) {
        if (!path.isEmpty() && path.contains(WHITESPACE)) {
            path = String.format("\"%s\"", path);
        }
        return path;
    }

    public static String removeQuotes(String path) {
        return path.replace("\"", EMPTY_STRING).replace("'", EMPTY_STRING);
    }
}

