/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.build;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedOptionValueHandler;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.util.StringUtil;
import org.tizen.nativeappcommon.build.DevPackageManager;
import org.tizen.nativecommon.build.CommonConfigurationManager;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativecommon.build.exception.SBIException;
import org.tizen.nativecore.build.NativeCoreConfigurationManager;
import org.tizen.sbilib.ide.PluginManager;
import org.tizen.sbilib.ide.Toolchain;

public class NativeCoreFrameworkManagedOptionValueHandler
implements IManagedOptionValueHandler {
    private final String LIB_PREFIX = "lib";
    private final String LIBSO_EXT = ".so";
    private final String LIBA_EXT = ".a";

    public boolean handleValue(IBuildObject configuration, IHoldsOptions holder, IOption option, String extraArgument, int event) {
        IConfiguration config = null;
        IProject project = null;
        if (event != 1 && event != 4 && event != 3) {
            return false;
        }
        if (!(configuration instanceof IConfiguration)) {
            return false;
        }
        config = (IConfiguration)configuration;
        project = config.getOwner().getProject();
        if (event == 3) {
            try {
                NativeCoreConfigurationManager.restoreDefaults(config, (Tool)holder);
                return true;
            }
            catch (SBIException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (event == 1) {
            CommonConfigurationManager.setToolCommand((IConfiguration)config);
        }
        SmartBuildInterface sbi = SmartBuildInterface.getInstance((IProject)project);
        String targetID = NativeCoreConfigurationManager.getBuildTargetName((IConfiguration)config);
        if (targetID == null) {
            return false;
        }
        ArrayList<String> includePaths = new ArrayList<String>();
        ArrayList<String> cflags = new ArrayList<String>();
        ArrayList<String> lflags = new ArrayList<String>();
        String rootstrapPath = "${SBI_SYSROOT}";
        includePaths.add("\"" + rootstrapPath + "/usr/include/libxml2\"");
        try {
            PluginManager pm;
            Toolchain tc;
            boolean isLibraryArtifact;
            cflags.add("${TC_COMPILER_MISC}");
            lflags.add("${TC_LINKER_MISC}");
            cflags.add("${RS_COMPILER_MISC}");
            lflags.add("${RS_LINKER_MISC}");
            IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
            String buildArtifactType = null;
            buildArtifactType = info.getDefaultConfiguration() != null ? info.getDefaultConfiguration().getManagedProject().getProjectType().getBuildArtefactType().getId() : "org.tizen.nativecore.buildArtefactType.app";
            if ("org.tizen.nativecore.buildArtefactType.app".equals(buildArtifactType)) {
                lflags.add("-pie -lpthread ");
                lflags.addAll(this.getRpathOption(project, config));
            } else if ("org.tizen.nativecore.buildArtefactType.sharedLib".equals(buildArtifactType)) {
                lflags.add("-lpthread ");
            }
            boolean bl = isLibraryArtifact = "org.tizen.nativecore.buildArtefactType.staticLib".equals(buildArtifactType) || "org.tizen.nativecore.buildArtefactType.sharedLib".equals(buildArtifactType);
            if (!isLibraryArtifact) {
                cflags.add(" -fPIE");
            }
            if (!sbi.canProvideVirtualEnvironment(targetID)) {
                lflags.add("--sysroot=\"" + rootstrapPath + "\"");
                cflags.add("--sysroot=\"" + rootstrapPath + "\"");
            }
            if ((tc = (pm = PluginManager.getInstance()).getToolchainByTargetId(targetID)) != null && CommonConfigurationManager.isArmArch((String)tc.getArchitecture())) {
                cflags.add("-mthumb");
            }
            if ("org.tizen.nativecore.buildArtefactType.sharedLib".equals(buildArtifactType)) {
                cflags.add("-fvisibility=hidden");
            } else if ("org.tizen.nativecore.buildArtefactType.app".equals(buildArtifactType)) {
                String exportFileName = NativeCoreConfigurationManager.getExportMapFileName();
                String path = new Path("${PROJ_PATH}").append(exportFileName).toString();
                lflags.add(String.format("-Xlinker --version-script=\"%s\"", path));
            }
            String[] stringArray = option.getUserObjects();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String devPackage = stringArray[n2];
                for (String includePath : DevPackageManager.getIncludePathList((String)targetID, (String)devPackage)) {
                    if (includePath.equals("//usr/include") || includePaths.contains("\"" + rootstrapPath + includePath + "\"")) continue;
                    includePaths.add("\"" + rootstrapPath + includePath + "\"");
                }
                List otherCFlags = DevPackageManager.getOtherCFlagList((String)targetID, (String)devPackage);
                for (String otherCFlag : otherCFlags) {
                    if (cflags.contains(otherCFlag)) continue;
                    cflags.add(otherCFlag);
                }
                List libraryPaths = DevPackageManager.getLibraryPathList((String)targetID, (String)devPackage);
                for (String libraryPath : libraryPaths) {
                    if (lflags.contains(String.format("-L\"%s%s\"", rootstrapPath, libraryPath))) continue;
                    lflags.add(String.format("-L\"%s%s\"", rootstrapPath, libraryPath));
                }
                List otherLFlags = DevPackageManager.getOtherLFlagList((String)targetID, (String)devPackage);
                if (NativeCoreConfigurationManager.isLLVMToolchain(config, (ITool)((Tool)holder)) && otherLFlags.contains("--export-dynamic")) {
                    otherLFlags.remove("--export-dynamic");
                }
                for (String otherLFlag : otherLFlags) {
                    if (lflags.contains(otherLFlag)) continue;
                    lflags.add(otherLFlag);
                }
                ++n2;
            }
            lflags.add("$(RS_LIBRARIES)");
        }
        catch (BuildException e) {
            e.printStackTrace();
            return false;
        }
        NativeCoreConfigurationManager.setFrameworkIncludePaths(config, (Tool)holder, includePaths);
        NativeCoreConfigurationManager.setFrameworkCflags(config, (Tool)holder, cflags);
        NativeCoreConfigurationManager.setFrameworkLflags(config, (Tool)holder, lflags);
        return true;
    }

    private List<String> getRpathOption(IProject project, IConfiguration config) {
        ArrayList<String> rpaths = new ArrayList<String>();
        String projectLibRpath = null;
        if (this.canGetManifestInfo(project)) {
            projectLibRpath = NativeCoreConfigurationManager.getProjectLibRpathOption(project, config);
        }
        if (!StringUtil.isEmpty(projectLibRpath)) {
            rpaths.add(projectLibRpath);
        }
        return rpaths;
    }

    private boolean canGetManifestInfo(IProject project) {
        String projectPath = project.getLocation().toFile().getAbsolutePath();
        File manifestPath = new File(projectPath, TizenPlatformConstants.MANIFEST_XML_FILE_NAME);
        return manifestPath.exists();
    }

    public boolean isDefaultValue(IBuildObject arg0, IHoldsOptions arg1, IOption arg2, String arg3) {
        return false;
    }

    public boolean isEnumValueAppropriate(IBuildObject arg0, IHoldsOptions arg1, IOption arg2, String arg3, String arg4) {
        return false;
    }

    private String makeLflag(String library) {
        String lFlag = "";
        if (library.startsWith("lib")) {
            if (library.endsWith(".a") || library.endsWith(".so")) {
                int lastIdx = library.lastIndexOf(".");
                String libName = library.substring(3, lastIdx);
                lFlag = String.format("-l%s", libName);
            } else {
                lFlag = String.format("-l:%s", library);
            }
        } else {
            lFlag = String.format("-l:%s", library);
        }
        return lFlag;
    }
}

