/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.ui.wizards;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tizen.common.project.model.SourceProject;
import org.tizen.common.ui.wizards.imports.AbstractDoAfterImport;
import org.tizen.nativecore.build.NativeCoreConfigurationManager;
import org.tizen.nativecore.wizards.NewCoreProjectChecker;

public class ImportWizardDoAfterImport
extends AbstractDoAfterImport {
    private static final String TPROJECT_FILE_NAME = ".tproject";

    public boolean isSupportedDirectory(String path) {
        if (path == null || path.isEmpty()) {
            return false;
        }
        File tProjectFile = new File(path, TPROJECT_FILE_NAME);
        File cprojectFile = new File(path, ".cproject");
        return tProjectFile.exists() && cprojectFile.exists();
    }

    public boolean isSupportedPackage(String path) {
        return false;
    }

    public String validateProjectName(String projectName) {
        String errMsg = NewCoreProjectChecker.validateProjName(projectName);
        if (errMsg == null || errMsg.isEmpty()) {
            return null;
        }
        return errMsg;
    }

    public boolean performImport(SourceProject srcProj, IProject project, IProgressMonitor monitor) throws CoreException, IOException {
        String platformName = srcProj.getPlatformToCreate();
        String profile = srcProj.getProfileFrom(platformName);
        String version = srcProj.getVersionFrom(platformName);
        NativeCoreConfigurationManager.changePlatform(project, profile, version);
        return true;
    }

    public boolean performAfterImport(String selectedProfile, String selectedVersion, IProject project, IProgressMonitor monitor) {
        NativeCoreConfigurationManager.changePlatform(project, selectedProfile, selectedVersion);
        return true;
    }
}

