/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.csviewer.control;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.nativecore.csviewer.model.CSVO;
import org.tizen.nativecore.csviewer.model.CallStackVO;
import org.tizen.nativecore.csviewer.model.DebugMessageVO;
import org.tizen.nativecore.csviewer.model.HeaderVO;
import org.tizen.nativecore.csviewer.model.MemoryMapVO;
import org.tizen.nativecore.csviewer.model.RegisterVO;

public class CSFileReader {
    private File csFile;
    private static final int MODE_DEFAULT = 0;
    private static final int MODE_HEADER = 1;
    private static final int MODE_HEADER_CRASH = 2;
    private static final int MODE_HEADER_SIGNAL = 3;
    private static final int MODE_HEADER_REGISTER_INFO = 4;
    private static final int MODE_HEADER_MEMORY = 5;
    private static final int MODE_HEADER_PACKAGE = 6;
    private static final int MODE_CALL_STACK_INFO = 12;
    private static final int MODE_MEMORY_MAP = 13;
    private static final int MODE_DEBUG_MESSAGE = 14;
    private String strSignalNumber = null;
    private int mode = 0;
    public String PROPERTY_OS_NAME = System.getProperty("os.name") != null ? System.getProperty("os.name").toLowerCase() : "";

    public CSFileReader(String csFilePath) {
        this.csFile = new File(csFilePath);
    }

    public void demanglingFile() {
        try {
            String sdkRoot = InstallPathConfig.getSDKPath();
            File csParentFile = this.csFile.getParentFile();
            if (sdkRoot != null && !sdkRoot.isEmpty() && csParentFile != null) {
                StringBuffer sb = new StringBuffer();
                StringBuffer sbFile = new StringBuffer();
                if (this.isWindows()) {
                    sb.append("tools");
                    sb.append(File.separator);
                    sb.append("mingw");
                    sb.append(File.separator);
                    sb.append("msys");
                    sb.append(File.separator);
                    sb.append("1.0");
                    sb.append(File.separator);
                    sb.append("bin");
                    sb.append(File.separator);
                    sb.append("cat.exe");
                    sb.append(" ");
                } else if (this.isLinux() || this.isMacOS()) {
                    sb.append("cat ");
                } else {
                    return;
                }
                sbFile.append("\"");
                sbFile.append(this.csFile.getCanonicalFile().getCanonicalPath());
                sbFile.append("\"");
                String strInputFile = sbFile.toString();
                sb.append(strInputFile);
                String strCommandCat = sb.toString();
                sb.delete(0, sb.length());
                sb.append("tools");
                sb.append(File.separator);
                sb.append("i386-linux-gnueabi-gcc-4.");
                File dir = new File(String.valueOf(sdkRoot) + "/" + sb.toString() + "6");
                if (dir.isDirectory()) {
                    sb.append("6");
                } else {
                    dir = new File(String.valueOf(sdkRoot) + "/" + sb.toString() + "5");
                    if (dir.isDirectory()) {
                        sb.append("5");
                    } else {
                        return;
                    }
                }
                sb.append(File.separator);
                sb.append("bin");
                sb.append(File.separator);
                if (this.isWindows()) {
                    sb.append("i386-linux-gnueabi-c++filt.exe");
                } else if (this.isLinux() || this.isMacOS()) {
                    sb.append("i386-linux-gnueabi-c++filt");
                } else {
                    return;
                }
                File f = new File(String.valueOf(sdkRoot) + "/" + sb.toString());
                if (!f.exists()) {
                    return;
                }
                sb.append(" > ");
                sbFile.delete(0, sbFile.length());
                sbFile.append("\"");
                sbFile.append(csParentFile.getCanonicalPath());
                sbFile.append(File.separator);
                sbFile.append("copy_");
                sbFile.append(this.csFile.getName());
                sbFile.append("\"");
                String strOutputFile = sbFile.toString();
                sb.append(strOutputFile);
                String strCommandFilt = sb.toString();
                sb.delete(0, sb.length());
                sb.append(strCommandCat);
                sb.append(" | ");
                sb.append(strCommandFilt);
                ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                processBuilder.command(this.getCommand(sb.toString()));
                processBuilder.directory(new File(sdkRoot));
                Process process = processBuilder.start();
                if (process.waitFor() == 0) {
                    process.destroy();
                }
                strInputFile = strInputFile.substring(1, strInputFile.length() - 1);
                File fileInput = new File(strInputFile);
                fileInput.setWritable(true);
                fileInput.delete();
                strOutputFile = strOutputFile.substring(1, strOutputFile.length() - 1);
                File fileOutput = new File(strOutputFile);
                fileOutput.setWritable(true);
                fileOutput.renameTo(new File(strInputFile));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private String[] getCommand(String strCmd) {
        if (this.isWindows()) {
            return new String[]{"cmd", "/c", strCmd};
        }
        if (this.isLinux() || this.isMacOS()) {
            return new String[]{"/bin/sh", "-c", strCmd};
        }
        return null;
    }

    /*
     * Loose catch block
     */
    public CSVO parse() {
        CSVO result = null;
        if (this.csFile != null) {
            String strLine = null;
            FileReader fr = null;
            BufferedReader br = null;
            this.mode = 0;
            result = new CSVO();
            try {
                try {
                    fr = new FileReader(this.csFile);
                    br = new BufferedReader(fr);
                    while ((strLine = br.readLine()) != null) {
                        strLine = strLine.trim();
                        switch (this.mode) {
                            case 0: {
                                if (strLine.equals("S/W Version Information")) {
                                    this.mode = 1;
                                } else if (strLine.equals("Crash Information")) {
                                    this.mode = 2;
                                } else if (strLine.equals("Package Information")) {
                                    this.mode = 6;
                                } else if (strLine.startsWith("Register Information")) {
                                    this.mode = 4;
                                } else if (strLine.startsWith("Memory Information")) {
                                    this.mode = 5;
                                } else if (strLine.startsWith("Callstack Information")) {
                                    this.mode = 12;
                                } else if (strLine.startsWith("Maps Information")) {
                                    this.mode = 13;
                                } else if (strLine.startsWith("Latest Debug Message Information")) {
                                    this.mode = 14;
                                }
                                if (strLine.startsWith("Executable File Path")) {
                                    if (this.parseHeaderCrash(result, strLine)) {
                                        this.mode = 0;
                                    }
                                    this.parse30HeaderCrash(result, this.csFile);
                                    break;
                                }
                                if (!strLine.startsWith("Memory information")) break;
                                this.mode = 5;
                                break;
                            }
                            case 1: {
                                if (!this.parseHeader(result, strLine)) break;
                                this.mode = 0;
                                break;
                            }
                            case 2: {
                                if (!this.parseHeaderCrash(result, strLine)) break;
                                this.mode = 0;
                                break;
                            }
                            case 3: {
                                if (!this.parseHeaderSignal(result, strLine)) break;
                                this.mode = 0;
                                break;
                            }
                            case 4: {
                                if (!this.parseHeaderRegisterInfo(result, strLine)) break;
                                this.mode = 0;
                                break;
                            }
                            case 6: {
                                if (!this.parseHeaderPackage(result, strLine)) break;
                                this.mode = 0;
                                break;
                            }
                            case 5: {
                                if (!this.parseHeaderMemory(result, strLine)) break;
                                this.mode = 0;
                                break;
                            }
                            case 12: {
                                if (!this.parseCallStackInfo(result, strLine)) break;
                                this.mode = 0;
                                break;
                            }
                            case 13: {
                                if (!this.parseMemoryMap(result, strLine)) break;
                                this.mode = 0;
                                break;
                            }
                            case 14: {
                                if (!this.parseDebugMessage(result, strLine)) break;
                                this.mode = 0;
                            }
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    try {
                        if (fr != null) {
                            fr.close();
                        }
                        if (br != null) {
                            br.close();
                        }
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        if (fr != null) {
                            fr.close();
                        }
                        if (br != null) {
                            br.close();
                        }
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    try {
                        if (fr != null) {
                            fr.close();
                        }
                        if (br != null) {
                            br.close();
                        }
                    }
                    catch (IOException e4) {
                        e4.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (fr != null) {
                        fr.close();
                    }
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    private boolean parseHeader(CSVO result, String strLine) throws Exception {
        boolean isEnd = false;
        int idxSub = -1;
        String strSub = null;
        if (strLine.isEmpty()) {
            isEnd = true;
        } else {
            HeaderVO header = result.getHeader();
            if (strLine.startsWith("Build-Number:")) {
                idxSub = strLine.indexOf(58);
                if (idxSub > -1) {
                    strSub = strLine.substring(idxSub + 1, strLine.length());
                    header.setBuildNumber(strSub);
                }
            } else if (strLine.startsWith("Build-Date:")) {
                idxSub = strLine.indexOf(58);
                if (idxSub > -1) {
                    strSub = strLine.substring(idxSub + 1, strLine.length());
                    header.setBuildDate(strSub);
                }
            } else if (strLine.startsWith("Model:")) {
                idxSub = strLine.indexOf(58);
                if (idxSub > -1) {
                    strSub = strLine.substring(idxSub + 1, strLine.length());
                    header.setModel(strSub);
                }
            } else if (strLine.startsWith("Tizen-Version:") && (idxSub = strLine.indexOf(58)) > -1) {
                strSub = strLine.substring(idxSub + 1, strLine.length());
                header.setVersion(strSub);
            }
            result.setHeader(header);
        }
        return isEnd;
    }

    private boolean parseHeaderCrash(CSVO result, String strLine) throws Exception {
        boolean isEnd = false;
        int idxSub = -1;
        String strSub = null;
        if (strLine.isEmpty()) {
            isEnd = true;
        } else {
            HeaderVO header = result.getHeader();
            if (strLine.startsWith("Date:")) {
                idxSub = strLine.indexOf(58);
                if (idxSub > -1) {
                    strSub = strLine.substring(idxSub + 1, strLine.length()).trim();
                    header.setCrashDate(strSub);
                }
            } else if (strLine.startsWith("Executable File Path:")) {
                idxSub = strLine.indexOf(58);
                if (idxSub > -1) {
                    strSub = strLine.substring(idxSub + 1, strLine.length()).trim();
                    header.setCrashExePath(strSub);
                }
            } else if (strLine.startsWith("Process Name:")) {
                idxSub = strLine.indexOf(58);
                if (idxSub > -1) {
                    strSub = strLine.substring(idxSub + 1, strLine.length()).trim();
                    header.setProcessName(strSub);
                }
            } else if (strLine.startsWith("PID:")) {
                idxSub = strLine.indexOf(58);
                if (idxSub > -1) {
                    strSub = strLine.substring(idxSub + 1, strLine.length()).trim();
                    header.setPID(strSub);
                }
            } else if (strLine.startsWith("Signal:") && (idxSub = strLine.indexOf(58)) > -1) {
                strSub = strLine.substring(idxSub + 1, strLine.length()).trim();
                header.appendSignalLine(strSub);
                this.mode = 3;
            }
            result.setHeader(header);
        }
        return isEnd;
    }

    private boolean parse30HeaderCrash(CSVO result, File csFile) {
        boolean isEnd = false;
        int idxStart = 0;
        int idxEnd = -1;
        String strSub = null;
        String strLine = csFile.toString();
        if (strLine.isEmpty()) {
            isEnd = true;
        } else {
            HeaderVO header = result.getHeader();
            idxEnd = strLine.lastIndexOf(47);
            if ((strLine = strLine.substring(idxEnd + 1, strLine.length()).trim()) != null && !"".equals(strLine)) {
                idxEnd = strLine.indexOf(95);
                if (idxEnd > -1) {
                    strSub = strLine.substring(idxStart, idxEnd).trim();
                    header.setProcessName(strSub);
                }
                if ((idxEnd = strLine.indexOf(95, idxStart = idxEnd + 1)) > -1) {
                    strSub = strLine.substring(idxStart, idxEnd).trim();
                    header.setPID(strSub);
                }
            }
        }
        return isEnd;
    }

    private boolean parseHeaderSignal(CSVO result, String strLine) throws Exception {
        boolean isEnd = false;
        if (strLine.isEmpty()) {
            isEnd = true;
        } else {
            HeaderVO header = result.getHeader();
            if (this.strSignalNumber != null && !this.strSignalNumber.isEmpty()) {
                header.appendSignalLine(this.strSignalNumber);
                this.strSignalNumber = null;
            }
            header.appendSignalLine(strLine);
            result.setHeader(header);
        }
        return isEnd;
    }

    private boolean parseHeaderPackage(CSVO result, String strLine) throws Exception {
        boolean isEnd = false;
        int idxSub = -1;
        String strSub = null;
        if (strLine.isEmpty()) {
            isEnd = true;
        } else {
            HeaderVO header = result.getHeader();
            if (strLine.startsWith("Package Name:")) {
                idxSub = strLine.indexOf(58);
                if (idxSub > -1) {
                    strSub = strLine.substring(idxSub + 1, strLine.length()).trim();
                    header.setPackageName(strSub);
                }
            } else if (strLine.startsWith("Package Type:")) {
                idxSub = strLine.indexOf(58);
                if (idxSub > -1) {
                    strSub = strLine.substring(idxSub + 1, strLine.length()).trim();
                    header.setPackageType(strSub);
                }
            } else if (strLine.startsWith("Version:")) {
                idxSub = strLine.indexOf(58);
                if (idxSub > -1) {
                    strSub = strLine.substring(idxSub + 1, strLine.length()).trim();
                    header.setPackageVersion(strSub);
                }
            } else if (strLine.startsWith("App Name:")) {
                idxSub = strLine.indexOf(58);
                if (idxSub > -1) {
                    strSub = strLine.substring(idxSub + 1, strLine.length()).trim();
                    header.setAppName(strSub);
                }
            } else if (strLine.startsWith("App ID")) {
                idxSub = strLine.indexOf(58);
                if (idxSub > -1) {
                    strSub = strLine.substring(idxSub + 1, strLine.length()).trim();
                    header.setAppID(strSub);
                }
            } else if (strLine.startsWith("Type:")) {
                idxSub = strLine.indexOf(58);
                if (idxSub > -1) {
                    strSub = strLine.substring(idxSub + 1, strLine.length()).trim();
                    header.setAppType(strSub);
                }
            } else if (strLine.startsWith("Categories:") && (idxSub = strLine.indexOf(58)) > -1) {
                strSub = strLine.substring(idxSub + 1, strLine.length()).trim();
                header.setCategories(strSub);
            }
        }
        return isEnd;
    }

    private boolean parseHeaderRegisterInfo(CSVO result, String strLine) throws Exception {
        boolean isEnd = false;
        if (strLine.isEmpty()) {
            isEnd = true;
        } else {
            String[] strsLine;
            HeaderVO header = result.getHeader();
            ArrayList<RegisterVO> registerList = header.getRegisterList();
            String[] stringArray = strsLine = strLine.split(",");
            int n = strsLine.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                int idxSub = str.indexOf(61);
                if (idxSub > -1) {
                    RegisterVO registerVO = new RegisterVO(str.substring(0, idxSub).trim(), str.substring(idxSub + 1, str.length()).trim());
                    registerList.add(registerVO);
                }
                ++n2;
            }
            header.setRegisters(registerList);
            result.setHeader(header);
        }
        return isEnd;
    }

    private boolean parseHeaderMemory(CSVO result, String strLine) throws Exception {
        boolean isEnd = false;
        if (strLine.isEmpty()) {
            isEnd = true;
        } else {
            HeaderVO header = result.getHeader();
            int idxSub = -1;
            String strSub = null;
            idxSub = strLine.indexOf(":");
            if (idxSub > -1) {
                strSub = strLine.substring(0, idxSub).trim();
                if (strSub.equals("MemTotal")) {
                    header.setMemTotal(Integer.parseInt(strLine.substring(idxSub + 1, strLine.length()).replace(" KB", "").trim()));
                } else if (strSub.equals("MemFree")) {
                    header.setMemFree(Integer.parseInt(strLine.substring(idxSub + 1, strLine.length()).replace(" KB", "").trim()));
                } else if (strSub.equals("Buffers")) {
                    header.setBuffers(Integer.parseInt(strLine.substring(idxSub + 1, strLine.length()).replace(" KB", "").trim()));
                } else if (strSub.equals("Cached")) {
                    header.setCached(Integer.parseInt(strLine.substring(idxSub + 1, strLine.length()).replace(" KB", "").trim()));
                } else if (strSub.equals("VmPeak")) {
                    header.setVmPeak(Integer.parseInt(strLine.substring(idxSub + 1, strLine.length()).replace(" KB", "").trim()));
                } else if (strSub.equals("VmSize")) {
                    header.setVmSize(Integer.parseInt(strLine.substring(idxSub + 1, strLine.length()).replace(" KB", "").trim()));
                } else if (strSub.equals("VmLck")) {
                    header.setVmLck(Integer.parseInt(strLine.substring(idxSub + 1, strLine.length()).replace(" KB", "").trim()));
                } else if (strSub.equals("VmPin")) {
                    header.setVmPin(Integer.parseInt(strLine.substring(idxSub + 1, strLine.length()).replace(" KB", "").trim()));
                } else if (strSub.equals("VmHWM")) {
                    header.setVmHWM(Integer.parseInt(strLine.substring(idxSub + 1, strLine.length()).replace(" KB", "").trim()));
                } else if (strSub.equals("VmRSS")) {
                    header.setVmRSS(Integer.parseInt(strLine.substring(idxSub + 1, strLine.length()).replace(" KB", "").trim()));
                } else if (strSub.equals("VmData")) {
                    header.setVmData(Integer.parseInt(strLine.substring(idxSub + 1, strLine.length()).replace(" KB", "").trim()));
                } else if (strSub.equals("VmStk")) {
                    header.setVmStk(Integer.parseInt(strLine.substring(idxSub + 1, strLine.length()).replace(" KB", "").trim()));
                } else if (strSub.equals("VmExe")) {
                    header.setVmExe(Integer.parseInt(strLine.substring(idxSub + 1, strLine.length()).replace(" KB", "").trim()));
                } else if (strSub.equals("VmLib")) {
                    header.setVmLib(Integer.parseInt(strLine.substring(idxSub + 1, strLine.length()).replace(" KB", "").trim()));
                } else if (strSub.equals("VmPTE")) {
                    header.setVmPTE(Integer.parseInt(strLine.substring(idxSub + 1, strLine.length()).replace(" KB", "").trim()));
                } else if (strSub.equals("VmSwap")) {
                    header.setVmSwap(Integer.parseInt(strLine.substring(idxSub + 1, strLine.length()).replace(" KB", "").trim()));
                }
            }
            result.setHeader(header);
        }
        return isEnd;
    }

    private boolean parseCallStackInfo(CSVO result, String strLine) throws Exception {
        boolean isEnd = false;
        if (strLine.equals("End of Call Stack")) {
            isEnd = true;
        } else if (!strLine.startsWith("Call Stack Count:")) {
            ArrayList<CallStackVO> csList = result.getCallStackList();
            int idxSub = -1;
            int idxL = -1;
            int idxR = -1;
            int countP = 0;
            CallStackVO csVO = new CallStackVO();
            idxSub = strLine.indexOf(":");
            if (idxSub > -1) {
                csVO.setSerialNumber(Integer.parseInt(strLine.substring(0, idxSub).trim()));
            }
            boolean isAbnormalAddressFormat = false;
            String strAddressTemp = null;
            long addressTemp = 0L;
            idxL = strLine.indexOf(91);
            idxR = strLine.indexOf(93);
            if (idxL > -1 && idxR > -1 && (strAddressTemp = strLine.substring(idxL + 1, idxR).trim()) != null) {
                try {
                    if (strAddressTemp.startsWith("0x")) {
                        strAddressTemp = strAddressTemp.substring(2, strAddressTemp.length());
                    }
                    addressTemp = Long.parseLong(strAddressTemp, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    isAbnormalAddressFormat = true;
                }
            }
            if (isAbnormalAddressFormat) {
                idxL = 0;
                idxR = 0;
                countP = this.countParentheses(strLine);
                if (countP > 0) {
                    int i = 0;
                    while (i < countP) {
                        if ((idxL = strLine.indexOf("(", idxL)) > -1 && (idxR = strLine.indexOf(")", idxL)) > -1) {
                            if (idxL + 3 < idxR) {
                                long longTemp = this.getAddress(strLine.substring(idxL + 1, idxR).trim());
                                if (longTemp != 0L) {
                                    csVO.setAddressS(strLine.substring(idxL + 1, idxR).trim());
                                    csVO.setAddressL(longTemp);
                                    csVO.setPayload(strLine);
                                    csList.add(csVO);
                                    result.setCallStackList(csList);
                                    break;
                                }
                                idxL = idxR;
                            } else {
                                idxL = idxR;
                            }
                        }
                        ++i;
                    }
                }
            } else {
                csVO.setAddressS(strAddressTemp);
                csVO.setAddressL(addressTemp);
                if (idxSub > 0 && idxL > 0) {
                    csVO.setPayload(strLine.substring(idxSub, idxL).trim());
                }
                csList.add(csVO);
                result.setCallStackList(csList);
            }
        }
        return isEnd;
    }

    private boolean parseMemoryMap(CSVO result, String strLineOriginal) throws Exception {
        boolean isEnd = false;
        String strLine = strLineOriginal;
        if (strLine.equals("End of Maps Information")) {
            isEnd = true;
        } else if (!strLine.isEmpty()) {
            ArrayList<MemoryMapVO> memoryMapList = result.getMemoryMapList();
            int idxStart = 0;
            int idxEnd = -1;
            String strSub = null;
            MemoryMapVO memoryMapVO = new MemoryMapVO();
            idxEnd = strLine.indexOf(" ");
            if (idxEnd > -1) {
                strSub = strLine.substring(idxStart, idxEnd).trim();
                memoryMapVO.setStartAddressS(strSub);
                memoryMapVO.setStartAddressL(Long.parseLong(strSub, 16));
            }
            if ((idxEnd = (strLine = strLine.substring(idxEnd, strLine.length()).trim()).indexOf(" ")) > -1) {
                strSub = strLine.substring(idxStart, idxEnd).trim();
                memoryMapVO.setEndAddressS(strSub);
                memoryMapVO.setEndAddressL(Long.parseLong(strSub, 16));
            }
            if ((idxEnd = strLine.indexOf(" ", idxStart = idxEnd + 1)) > -1) {
                strSub = strLine.substring(idxStart, idxEnd).trim();
                memoryMapVO.setMod(strSub);
            }
            idxStart = idxEnd + 1;
            idxEnd = strLine.length();
            if (idxEnd > -1) {
                strSub = strLine.substring(idxStart, idxEnd).trim();
                memoryMapVO.setSoInfo(strSub);
            }
            memoryMapList.add(memoryMapVO);
            result.setMemoryMapList(memoryMapList);
        }
        return isEnd;
    }

    private boolean parseDebugMessage(CSVO result, String strLine) throws Exception {
        boolean isEnd = false;
        if (strLine.startsWith("end of latest dmf")) {
            isEnd = true;
        } else {
            boolean isAbnormalLine = false;
            ArrayList<DebugMessageVO> debugMessageList = result.getDebugMessageList();
            int idxStart = -1;
            int idxEnd = -1;
            String strSub = null;
            DebugMessageVO debugMessageVO = new DebugMessageVO();
            idxEnd = strLine.indexOf(" ");
            if (idxEnd > -1) {
                strSub = strLine.substring(0, idxEnd);
                idxStart = idxEnd + 1;
                if ((idxEnd = strLine.indexOf(" ", idxStart)) > -1) {
                    strSub = strLine.substring(0, idxEnd).trim();
                    debugMessageVO.setDate(strSub);
                } else {
                    isAbnormalLine = true;
                }
            }
            if ((idxEnd = strLine.indexOf("(", idxStart = idxEnd + 1)) > -1) {
                strSub = strLine.substring(idxStart, idxEnd).trim();
                debugMessageVO.setTag(strSub);
            } else {
                isAbnormalLine = true;
            }
            idxStart = idxEnd + 1;
            idxEnd = strLine.indexOf(")", idxStart);
            if (idxEnd > -1) {
                strSub = strLine.substring(idxStart, idxEnd).trim();
                debugMessageVO.setPID(strSub);
            } else {
                isAbnormalLine = true;
            }
            idxStart = strLine.indexOf(":", idxEnd);
            if (idxStart > -1) {
                strSub = strLine.substring(idxStart + 1, strLine.length()).trim();
                debugMessageVO.setMessage(strSub);
            } else {
                isAbnormalLine = true;
            }
            if (!isAbnormalLine) {
                debugMessageList.add(debugMessageVO);
            }
            result.setDebugMessageList(debugMessageList);
        }
        return isEnd;
    }

    private int countParentheses(String strLine) {
        int result = 0;
        int len = 0;
        boolean isLeft = false;
        if (strLine != null) {
            len = strLine.length();
        }
        int i = 0;
        while (i < len) {
            if (strLine.charAt(i) == '(') {
                isLeft = true;
            }
            if (isLeft && strLine.charAt(i) == ')') {
                ++result;
                isLeft = false;
            }
            ++i;
        }
        return result;
    }

    private long getAddress(String strLine) {
        long result = 0L;
        if (strLine != null && strLine.startsWith("0x")) {
            strLine = strLine.substring(3, strLine.length()).trim();
            result = Long.parseLong(strLine, 16);
        }
        return result;
    }

    public boolean isWindows() {
        return this.PROPERTY_OS_NAME.contains("windows");
    }

    public boolean isLinux() {
        return this.PROPERTY_OS_NAME.contains("linux");
    }

    public boolean isMacOS() {
        return this.PROPERTY_OS_NAME.contains("mac");
    }
}

