/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.tizen.nativecore.ext.manifest.IApplication;
import org.tizen.nativecore.ext.manifest.SupportSize;
import org.tizen.nativecore.ext.manifest.WidgetApplication;
import org.tizen.nativecore.misc.editor.ManifestEditor;
import org.tizen.nativecore.misc.editor.TizenFormPage;
import org.tizen.nativecore.misc.editor.UiAttrIcon;

public class UiAttrIconWithCheck
extends UiAttrIcon {
    private Button fCheck;
    private SupportSize fRefSize;
    private ManifestEditor fEditor;
    private String labelText;
    private boolean updateUIFlag;

    public UiAttrIconWithCheck(TizenFormPage page) {
        super(page);
        this.fEditor = page.getEditor();
    }

    @Override
    public void createUi(Composite parent, FormToolkit toolkit, final String labelText, boolean preview) {
        this.labelText = labelText;
        this.fCheck = toolkit.createButton(parent, labelText, 32);
        this.fCheck.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                if (UiAttrIconWithCheck.this.fCheck.getSelection()) {
                    IApplication app;
                    UiAttrIconWithCheck.this.setEnableIconUi(true);
                    if (UiAttrIconWithCheck.this.fRefSize == null) {
                        UiAttrIconWithCheck.this.fRefSize = new SupportSize();
                        UiAttrIconWithCheck.this.fRefSize.setValue(labelText);
                        UiAttrIconWithCheck.this.setInput(UiAttrIconWithCheck.this.fRefSize.getPreview());
                    }
                    if ((app = UiAttrIconWithCheck.this.fEditor.getCoreManifest().getDefaultApp()) instanceof WidgetApplication) {
                        WidgetApplication widgetApp = (WidgetApplication)app;
                        widgetApp.getSupportSizesMap().put(labelText, UiAttrIconWithCheck.this.fRefSize);
                    }
                    UiAttrIconWithCheck.this.getPage().setDirty(true);
                } else {
                    IApplication app;
                    UiAttrIconWithCheck.this.setEnableIconUi(false);
                    if (UiAttrIconWithCheck.this.fRefSize != null && (app = UiAttrIconWithCheck.this.fEditor.getCoreManifest().getDefaultApp()) instanceof WidgetApplication) {
                        WidgetApplication widgetApp = (WidgetApplication)app;
                        widgetApp.getSupportSizesMap().remove(labelText);
                        UiAttrIconWithCheck.this.fRefSize = null;
                    }
                    UiAttrIconWithCheck.this.getPage().setDirty(true);
                }
            }
        });
        this.createIconUi(parent, toolkit);
        this.updateUIFlag = true;
        this.setEnableIconUi(false);
    }

    private void setEnableIconUi(boolean enable) {
        if (!enable) {
            this.getTextWidget().setText("");
        }
        this.getTextWidget().setEnabled(enable);
        this.getButtonWidget().setEnabled(enable);
    }

    @Override
    protected void onTextModified() {
        WidgetApplication widgetApp;
        SupportSize size;
        if (this.updateUIFlag) {
            this.updateUIFlag = false;
            return;
        }
        IApplication app = this.fEditor.getCoreManifest().getDefaultApp();
        if (app instanceof WidgetApplication && (size = (widgetApp = (WidgetApplication)app).getSupportSizesMap().get(this.labelText)) != null) {
            size.setPreview(this.getTextWidget().getText());
            this.validate();
        }
    }

    public void updateUI(SupportSize supportSize) {
        if (supportSize != null) {
            this.fCheck.setSelection(true);
            this.fRefSize = supportSize;
            this.setInput(this.fRefSize.getPreview());
            this.setEnableIconUi(true);
        } else {
            this.fCheck.setSelection(false);
            this.setEnableIconUi(false);
        }
    }
}

