/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.apichecker;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativecommon.build.CommonConfigurationManager;
import org.tizen.nativecore.apichecker.ReporterThread;
import org.tizen.nativecore.apichecker.ui.APCPropertyPage;
import org.tizen.nativecore.apichecker.utility.CommonUtility;
import org.tizen.nativecore.apichecker.utility.Messages;

public class APICheckerJob
extends Job {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ISelection selection;

    public APICheckerJob(String name, ISelection selection) {
        super(name);
        this.selection = selection;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IProject project = null;
        try {
            if (this.selection instanceof IStructuredSelection && ((IStructuredSelection)this.selection).size() > 0) {
                for (Object element : ((IStructuredSelection)this.selection).toList()) {
                    if (!(element instanceof IProject)) continue;
                    project = (IProject)element;
                    CommonUtility.ParseManifestFile(project);
                    String APIVersion = CommonUtility.getAPIVersion();
                    String Profile = CommonUtility.getProfileName();
                    String PrivilegeList = CommonUtility.getPrivilegeList();
                    if (APIVersion == null || Profile == null) {
                        return Status.CANCEL_STATUS;
                    }
                    IProject[] projects = project.getReferencedProjects();
                    int i = 0;
                    while (i < projects.length) {
                        String Privileges;
                        if (CommonUtility.ParseManifestFile(projects[i]) && Profile.equals(CommonUtility.getProfileName()) && (Privileges = CommonUtility.getPrivilegeList()) != null && !Privileges.isEmpty()) {
                            PrivilegeList = PrivilegeList.isEmpty() ? Privileges : String.valueOf(PrivilegeList) + "," + Privileges;
                        }
                        ++i;
                    }
                    String apiCheckerOptions = CommonUtility.getAPICheckerOptions(APIVersion, Profile, PrivilegeList);
                    int i2 = 0;
                    while (i2 < projects.length) {
                        this.buildProjectWithApiChecker(projects[i2], monitor, apiCheckerOptions);
                        ++i2;
                    }
                    this.buildProjectWithApiChecker(project, monitor, apiCheckerOptions);
                    CommonUtility.resetAPICheckerOptions();
                }
            }
        }
        catch (CoreException e) {
            this.logger.error(String.format(Messages.APICheckerJob_failedToBuildProject, project), (Throwable)e);
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private void buildProjectWithApiChecker(IProject project, IProgressMonitor monitor, String apiCheckerOptions) throws CoreException {
        CommonConfigurationManager.setAPICheckerOptions((String)apiCheckerOptions);
        boolean checkUnusedPrivilege = APCPropertyPage.getWithUnusedPrivilegeOption(project);
        if (checkUnusedPrivilege) {
            CommonConfigurationManager.setAPICheckerMiscOptions((String)"-check-unused=true");
        }
        CommonUtility.setOptionSetByPlugin(apiCheckerOptions);
        project.build(15, monitor);
        project.build(6, monitor);
        ReporterThread reporter = new ReporterThread(project, CommonConfigurationManager.getOutputStream());
        reporter.start();
        CommonConfigurationManager.setAPICheckerOptions((String)"");
        if (checkUnusedPrivilege) {
            CommonConfigurationManager.setAPICheckerMiscOptions((String)"");
        }
    }
}

