/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.apichecker.inplacechecker;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.concurrent.Semaphore;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariableManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativecommon.launch.TizenLaunchConsole;
import org.tizen.nativecore.apichecker.utility.CommonUtility;
import org.tizen.nativecore.misc.utils.OSChecker;

public class APICheckerThread
extends Thread {
    private IFile currentFile;
    private IDocument document;
    private String expFlags = null;
    private IConfiguration config = null;
    protected TizenLaunchConsole launchConsole = null;
    private static Semaphore mutex = new Semaphore(1);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public APICheckerThread(IFile file, IDocument CurrentDoc) {
        this.currentFile = file;
        this.document = CurrentDoc;
    }

    @Override
    public void run() {
        this.runApiCheckerTool();
    }

    private String expandEnvVariables(String inStr) {
        if (this.config == null) {
            return inStr;
        }
        if ((inStr = inStr.replaceAll("\\{", "\\(").replaceAll("\\}", "\\)")).indexOf("$(") >= 0) {
            IEnvironmentVariable[] vars;
            ICConfigurationDescription cfgDes = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)this.config);
            IEnvironmentVariableManager mngr = CCorePlugin.getDefault().getBuildEnvironmentManager();
            IEnvironmentVariable[] iEnvironmentVariableArray = vars = mngr.getVariables(cfgDes, true);
            int n = vars.length;
            int n2 = 0;
            while (n2 < n) {
                IEnvironmentVariable var = iEnvironmentVariableArray[n2];
                inStr = inStr.replace(String.format("$(%s)", var.getName()), var.getValue());
                ++n2;
            }
        }
        return OSChecker.isWindows() ? inStr.replace("\\", "/") : inStr;
    }

    private String joinArrayString(String arrayStr, String delim) {
        return arrayStr.replaceAll("[\\[\\]]", "").replaceAll(", ", delim);
    }

    private String getExpandedBuildFlags(String flags) {
        if (this.expFlags == null) {
            this.expFlags = this.expandEnvVariables(this.joinArrayString(flags, " "));
        }
        return this.expFlags;
    }

    private String getToolFlags(ITool tool, String[] flags) {
        IManagedCommandLineInfo cmdLInfo;
        String toolFlags = "";
        IManagedCommandLineGenerator gen = tool.getCommandLineGenerator();
        if (gen != null && (cmdLInfo = gen.generateCommandLineInfo(tool, "", flags, "", "", "", EMPTY_STRING_ARRAY, tool.getCommandLinePattern())) != null) {
            toolFlags = cmdLInfo.getCommandLine();
        }
        return toolFlags;
    }

    private void runApiCheckerTool() {
        IConfiguration conf;
        try {
            mutex.acquire();
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage());
            return;
        }
        IProject project = this.currentFile.getProject();
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        if (buildInfo == null) {
            this.logger.error("get BuildInfo failed.." + project.getName());
            return;
        }
        IConfiguration[] configurations = buildInfo.getManagedProject().getConfigurations();
        this.config = conf = configurations[0];
        IFileInfo fileInfo = conf.createFileInfo(this.currentFile.getFullPath());
        ITool[] tools = fileInfo.getTools();
        ITool tool = tools[0];
        String flags = "";
        try {
            String[] cmdFlags = tool.getToolCommandFlags(null, null);
            flags = this.getToolFlags(tool, cmdFlags);
        }
        catch (BuildException e) {
            this.logger.error(e.getMessage());
        }
        String FilePath = this.currentFile.getRawLocation().toOSString();
        String Content = this.document.get();
        File temp = null;
        try {
            temp = File.createTempFile("temp-file-name", ".cpp");
            PrintWriter out = new PrintWriter(temp.getAbsolutePath());
            out.print(Content);
            out.close();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
        }
        String apiCheckerOptions = CommonUtility.getAPICheckerOptions(project);
        if (temp == null || apiCheckerOptions.isEmpty()) {
            mutex.release();
            return;
        }
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        String ToolName = OSChecker.isWindows() ? "APIChecker.exe " : "APIChecker ";
        String command = String.valueOf(sbi.getAPICheckerPath()) + File.separatorChar + ToolName + apiCheckerOptions + " -file-path=" + temp.getAbsolutePath() + " " + FilePath + " -- " + this.getExpandedBuildFlags(flags.replace("\"", "")) + " -w -fretain-comments-from-system-headers ";
        if (this.launchConsole == null) {
            this.launchConsole = TizenLaunchConsole.getTizenConsole();
        }
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(command);
            BufferedReader buffer = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            String line = null;
            this.launchConsole.clear();
            IMarker[] problems = this.currentFile.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            int i = 0;
            while (i < problems.length) {
                problems[i].delete();
                ++i;
            }
            this.currentFile.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            while ((line = buffer.readLine()) != null) {
                String[] result;
                int index;
                if (!line.contains("warning:") || !line.contains("warning:") || (index = (result = line.split("warning:"))[0].lastIndexOf(":")) == -1) continue;
                result[0] = result[0].substring(0, index);
                index = result[0].lastIndexOf(":");
                if (index == -1) continue;
                result[0] = result[0].substring(0, index);
                int lineNumIndx = result[0].lastIndexOf(":");
                if (lineNumIndx == -1) continue;
                String lineNumber = result[0].substring(lineNumIndx + 1);
                String fileName = result[0].substring(0, lineNumIndx);
                Path path = new Path(fileName);
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
                if (file == null) continue;
                IMarker marker = this.currentFile.createMarker("org.tizen.nativecore.apichecker.apicheckerproblems");
                String message = line.substring(line.indexOf("warning:") + 8);
                marker.setAttribute("message", (Object)message);
                marker.setAttribute("severity", 0);
                marker.setAttribute("lineNumber", Integer.parseInt(lineNumber));
            }
            int exitVal = process.waitFor();
            System.out.println("Exited with error code" + exitVal);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
        mutex.release();
    }
}

