/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.linux.rootstrap;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativeplatform.PlatformConfigurationManager;
import org.tizen.nativeplatform.filefilter.RpmFileFilter;
import org.tizen.nativeplatform.filefilter.XmlFileFilter;
import org.tizen.nativeplatform.linux.rootstrap.core.RootstrapGenerator;
import org.tizen.nativeplatform.linux.rootstrap.core.RootstrapRemover;
import org.tizen.nativeplatform.linux.rootstrap.core.RootstrapXMLGenerator;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.repo.model.Repository;
import org.tizen.nativeplatform.rootstrap.IRootstrapManager;
import org.tizen.nativeplatform.rootstrap.PlatformRootstrapStore;
import org.tizen.nativeplatform.rootstrap.RootstrapInitializer;
import org.tizen.nativeplatform.rootstrap.RootstrapListenerManager;
import org.tizen.sbilib.ide.PluginManager;
import org.tizen.sbilib.ide.Rootstrap;

public class RootstrapManager
implements IRootstrapManager {
    protected static final Logger logger = LoggerFactory.getLogger(RootstrapManager.class);

    public void addRootstrap(PlatformRootstrap rootstrap) {
        PlatformRootstrapStore.addRootstrap((PlatformRootstrap)rootstrap);
        PluginManager pm = PluginManager.getInstance();
        pm.addRootstrap((Rootstrap)rootstrap);
        RootstrapListenerManager.notifyChangedRootstrap();
    }

    private PlatformRootstrap getRootstrap(String id) {
        for (PlatformRootstrap r : this.getRootstraps()) {
            if (!r.getId().equals(id)) continue;
            return r;
        }
        return null;
    }

    public boolean removeRootstrap(String id) {
        PlatformRootstrap rootstrap = this.getRootstrap(id);
        if (rootstrap != null) {
            try {
                RootstrapRemover.remove(rootstrap.getId(), rootstrap.getArchitecture());
            }
            catch (InterruptedException e) {
                logger.error(String.format("Failed to rootstrap: [%s]", id), (Throwable)e);
                e.printStackTrace();
                return false;
            }
            PlatformRootstrapStore.removeRootstrap((PlatformRootstrap)rootstrap);
            RootstrapXMLGenerator.removeXML(rootstrap.getId());
            PluginManager pm = PluginManager.getInstance();
            pm.removeRootstrap((Rootstrap)rootstrap);
            RootstrapListenerManager.notifyChangedRootstrap();
            return true;
        }
        return false;
    }

    public List<PlatformRootstrap> getRootstraps() {
        RootstrapInitializer.checkInitialized();
        return PlatformRootstrapStore.getRootstraps();
    }

    protected List<PlatformRootstrap> getX86Rootstrap() {
        RootstrapInitializer.checkInitialized();
        ArrayList<PlatformRootstrap> list = new ArrayList<PlatformRootstrap>();
        for (PlatformRootstrap r : PlatformRootstrapStore.getRootstraps()) {
            String arch = r.getArchitecture();
            if (!PlatformConfigurationManager.containValue((String[])PlatformConfigurationManager.ARCHGROUP_X86, (String)arch)) continue;
            list.add(r);
        }
        return list;
    }

    protected List<PlatformRootstrap> getArmRootstrap() {
        RootstrapInitializer.checkInitialized();
        ArrayList<PlatformRootstrap> list = new ArrayList<PlatformRootstrap>();
        for (PlatformRootstrap r : PlatformRootstrapStore.getRootstraps()) {
            String arch = r.getArchitecture();
            if (!PlatformConfigurationManager.containValue((String[])PlatformConfigurationManager.ARCHGROUP_ARM, (String)arch)) continue;
            list.add(r);
        }
        return list;
    }

    protected List<PlatformRootstrap> getInitializedRootstrap() {
        RootstrapInitializer.checkInitialized();
        ArrayList<PlatformRootstrap> list = new ArrayList<PlatformRootstrap>();
        for (PlatformRootstrap r : PlatformRootstrapStore.getRootstraps()) {
            if (!r.isInitialized()) continue;
            list.add(r);
        }
        return list;
    }

    protected List<PlatformRootstrap> getNonInitializedRootstrap() {
        RootstrapInitializer.checkInitialized();
        ArrayList<PlatformRootstrap> list = new ArrayList<PlatformRootstrap>();
        for (PlatformRootstrap r : PlatformRootstrapStore.getRootstraps()) {
            if (r.isInitialized()) continue;
            list.add(r);
        }
        return list;
    }

    public void removeLatestTempDirForRootstrap() {
        RootstrapRemover.removeLatestTempDirForRootstrap();
    }

    public PlatformRootstrap generateRootstrap(String name, String arch, String version, List<Repository> reposURLs, boolean immediateGen, IPath confFile, IProgressMonitor monitor) throws InterruptedException {
        return RootstrapGenerator.generate(name, arch, version, reposURLs, confFile, immediateGen, monitor);
    }

    public boolean checkInitialized(PlatformRootstrap rootstrap) {
        return new File(rootstrap.getPath()).exists();
    }

    public boolean generateRootstrap(PlatformRootstrap rootstrap, IProgressMonitor monitor) throws InterruptedException {
        return RootstrapGenerator.generate(rootstrap, monitor);
    }

    public void afterGenRootstrap(PlatformRootstrap rootstrap, boolean immediateGen, IProgressMonitor monitor) {
    }

    public void winCacheModificationTime(PlatformRootstrap rootstrap) {
    }

    public void winSyncronizeIfChanges(PlatformRootstrap rootstrap, IProgressMonitor monitor) {
        monitor.worked(1);
    }

    public void winSyncronize(PlatformRootstrap rootstrap, IProgressMonitor monitor) {
        monitor.worked(1);
    }

    public String getRootstrapLocalPath(PlatformRootstrap rootstrap) {
        String basePath = rootstrap.getPath().toString();
        return SmartBuildInterface.getInstance().getPlatformRootstrapPath(basePath);
    }

    public List<String> getRpmFiles(PlatformRootstrap rootstrap) {
        ArrayList<String> rpms = new ArrayList<String>();
        String rootstrapPath = SmartBuildInterface.getInstance().getPlatformRootstrapPath(rootstrap.getPath());
        String arch = rootstrap.getArchitecture();
        IPath rpmPath = new Path(rootstrapPath).append("home").append("abuild").append("rpmbuild").append("RPMS");
        File rpmDir = rpmPath.append(arch).toFile();
        if (arch.equals("i586") && !rpmDir.exists()) {
            rpmDir = rpmPath.append("i686").toFile();
        }
        if (rpmDir.exists()) {
            String[] files;
            String[] stringArray = files = rpmDir.list((FilenameFilter)new RpmFileFilter());
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                IPath pkgPath = new Path(rpmDir.getPath()).append(file);
                rpms.add(pkgPath.toOSString());
                ++n2;
            }
        }
        return rpms;
    }

    public List<String> getXmlFiles(PlatformRootstrap rootstrap) {
        File[] paths;
        ArrayList<String> xmls = new ArrayList<String>();
        String rootstrapPath = SmartBuildInterface.getInstance().getPlatformRootstrapPath(rootstrap.getPath());
        IPath rpmPath = new Path(rootstrapPath).append("home").append("abuild").append("rpmbuild").append("BUILD");
        File[] fileArray = paths = rpmPath.toFile().listFiles();
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            File path = fileArray[n2];
            if (path.exists() && path.isDirectory()) {
                String[] files;
                String[] stringArray = files = path.list((FilenameFilter)new XmlFileFilter());
                int n3 = files.length;
                int n4 = 0;
                while (n4 < n3) {
                    String file = stringArray[n4];
                    IPath xmlPath = new Path(path.getPath()).append(file);
                    xmls.add(xmlPath.toOSString());
                    ++n4;
                }
            }
            ++n2;
        }
        return xmls;
    }

    public void updateRootstrap(PlatformRootstrap rootstrap) {
        if (rootstrap != null) {
            RootstrapXMLGenerator xmlGenerator = new RootstrapXMLGenerator(rootstrap.getId(), rootstrap.getName(), rootstrap.getArchitecture(), rootstrap.getVersion(), rootstrap.getPath().toString(), rootstrap.getJustRepoURLs(), rootstrap.getConfFile(), rootstrap.isDefault());
            xmlGenerator.generate();
            PluginManager pm = PluginManager.getInstance();
            pm.reInit();
            RootstrapListenerManager.notifyChangedRootstrap();
        }
    }
}

