/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.linux.build.vbs;

import java.util.ArrayList;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativeplatform.PlatformConfigurationManager;
import org.tizen.nativeplatform.RootstrapProxy;
import org.tizen.nativeplatform.linux.build.gbs.GBSBuildCommandProvider;
import org.tizen.nativeplatform.model.PlatformRootstrap;

public class VBSBuildCommandProvider
extends GBSBuildCommandProvider {
    public VBSBuildCommandProvider() {
    }

    public VBSBuildCommandProvider(IConfiguration config) {
        super(config);
    }

    @Override
    public void setConfiguration(IConfiguration config) {
        this.config = config;
    }

    @Override
    public String getCommandName() {
        return "vbs";
    }

    @Override
    public String getBuildCommand() {
        return "/usr/bin/vbs";
    }

    @Override
    public String[] getBuildArguments() {
        String targetId = PlatformConfigurationManager.getBuildTargetName((IConfiguration)this.config);
        String rootId = SmartBuildInterface.getInstance().getRootstrapIDFromTargetID(targetId);
        PlatformRootstrap rt = RootstrapProxy.getProxy().getRootstrap(rootId);
        ArrayList<String> args = new ArrayList<String>();
        if (rt == null) {
            return args.toArray(new String[0]);
        }
        args.add("build");
        args.add("--skip-p4check");
        args.add("--arch");
        args.add(rt.getArchitecture());
        for (String snapshot : rt.getJustRepoURLs()) {
            args.add("--repository");
            args.add(snapshot);
        }
        args.add(String.format("%s=%s", "--buildroot", rt.getPath().toString()));
        for (String op : PlatformConfigurationManager.getGBSOptions((IConfiguration)this.config)) {
            args.add(op);
        }
        if (rt.getConfFile() != null && !rt.getConfFile().toString().isEmpty()) {
            args.add(String.format("%s=%s", "--dist", rt.getConfFile().toString()));
        }
        return args.toArray(new String[0]);
    }

    @Override
    public String getCleanCommand() {
        return "/bin/rm";
    }

    @Override
    public String[] getCleanArguments() {
        IProject project = (IProject)this.config.getOwner();
        IPath configPath = project.getLocation().append(this.config.getName());
        ArrayList<String> args = new ArrayList<String>();
        args.add("-rf");
        args.add(configPath.toOSString());
        return args.toArray(new String[0]);
    }
}

