/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.project.wizard.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.templateengine.TemplateDescriptor;
import org.eclipse.cdt.ui.wizards.EntryDescriptor;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.IWizard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.ui.wizards.PlatformTemplateLoader;
import org.tizen.nativeappcommon.templateengine.TizenTemplateProcessParser;
import org.tizen.nativeappcommon.wizards.EntryDescriptorPlatformMap;
import org.tizen.nativeappcommon.wizards.TemplateTizenNewWizard;
import org.tizen.nativeplatform.preferences.PreferencesManager;
import org.tizen.nativeplatform.project.wizard.git.GitDescManager;
import org.tizen.nativeplatform.project.wizard.git.model.GitDescription;
import org.tizen.nativeplatform.project.wizard.git.parser.GitIndexParserFactory;
import org.tizen.nativeplatform.project.wizard.git.parser.IGitIndexParser;
import org.w3c.dom.Element;

public class TemplateTizenPlatformNewWizard
extends TemplateTizenNewWizard {
    public static final String DIR_PLATFORM = "platform";
    public static final String DIR_RPM = "rpm";
    public static final String DIR_GIT = "Git";
    public static final String DIR_DELIMITER = "/";
    public static final String[] ID_TEMPLATE = new String[]{"PlatformProject"};
    public static final String[] ID_PROJTYPE = new String[]{"org.tizen.nativeide.buildArtefactType.platform"};
    public static final Logger logger = LoggerFactory.getLogger(TemplateTizenPlatformNewWizard.class);

    public EntryDescriptor[] createItems(boolean supportedOnly, IWizard wizard) {
        ArrayList<EntryDescriptor> items = new ArrayList<EntryDescriptor>();
        PlatformTemplateLoader templateLoader = new PlatformTemplateLoader(DIR_PLATFORM + File.separator + DIR_RPM, "sample.xml");
        Map platformTemplateMap = templateLoader.loadPlatformSamples();
        for (ProfileInfo profileInfo : platformTemplateMap.keySet()) {
            IPath rootPath = new Path(InstallPathConfig.getSamplesPath((ProfileInfo)profileInfo, (String)profileInfo.getLatestPlatformVersion())).append(DIR_PLATFORM).append(DIR_RPM);
            for (File sampleFile : (List)platformTemplateMap.get(profileInfo)) {
                Path templatePath = new Path(sampleFile.getPath());
                EntryDescriptor entryDes = this.getEntryDesc(TizenTemplateProcessParser.createTemplateDesc((File)sampleFile), templatePath.removeLastSegments(1).lastSegment());
                IPath sourcePath = templatePath.removeLastSegments(1);
                if (sourcePath.segmentCount() != rootPath.segmentCount()) {
                    entryDes.setPath(templatePath.removeLastSegments(2).makeRelativeTo(rootPath).toString());
                } else {
                    entryDes.setPath(null);
                }
                EntryDescriptorPlatformMap.getInstance().put(entryDes, profileInfo);
                items.add(entryDes);
            }
        }
        String projTypeName = "org.tizen.nativeide.buildArtefactType.platform";
        PreferencesManager.SiteConfiguration config = PreferencesManager.loadActiveSiteConfiguration();
        if (config != null) {
            String profileName = config.getName();
            ProfileInfo gitProfileInfo = new ProfileInfo(profileName, "1", "");
            EntryDescriptor gitEntryDes = null;
            List<GitDescription> gitDescs = null;
            gitDescs = GitDescManager.getDescs(profileName);
            if (gitDescs == null || gitDescs.isEmpty()) {
                IGitIndexParser parser = GitIndexParserFactory.getIndexParser(config);
                if (parser == null) {
                    return items.toArray(new EntryDescriptor[items.size()]);
                }
                try {
                    gitDescs = parser.parse(config);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (gitDescs != null) {
                    GitDescManager.setDescs(profileName, gitDescs);
                }
            }
            if (gitDescs != null) {
                for (GitDescription n : gitDescs) {
                    Path gitPath = new Path(n.getProject());
                    String name = gitPath.lastSegment();
                    String dir = gitPath.removeLastSegments(1).toString();
                    dir = "Git/PROFILE_NAME/" + dir;
                    gitEntryDes = new EntryDescriptor(this.getTemplateID(projTypeName), projTypeName, name, false, null, null);
                    gitEntryDes.setPath(dir);
                    EntryDescriptorPlatformMap.getInstance().put(gitEntryDes, gitProfileInfo);
                    items.add(gitEntryDes);
                }
            }
        }
        return items.toArray(new EntryDescriptor[items.size()]);
    }

    public EntryDescriptor getEntryDesc(TemplateDescriptor descriptor, String label) {
        Element root = descriptor.getRootElement();
        Element slpPropertyElement = TizenTemplateProcessParser.getElementFromTag((Element)root, (String)"slp-property");
        slpPropertyElement = TizenTemplateProcessParser.getElementFromTag((Element)slpPropertyElement, (String)"property-group");
        String projTypeName = TizenTemplateProcessParser.getTextContextFromElement((Element)slpPropertyElement, (String)"project-type");
        return new EntryDescriptor(this.getTemplateID(projTypeName), projTypeName, label, false, null, null);
    }

    public String getTemplateID(String projTypeName) {
        int i = 0;
        while (i < ID_PROJTYPE.length) {
            if (ID_PROJTYPE[i].equals(projTypeName)) {
                return ID_TEMPLATE[i];
            }
            ++i;
        }
        return ID_TEMPLATE[0];
    }

    public IPath getTemplatePath() {
        return null;
    }
}

