/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.manifest;

import java.util.ArrayList;
import java.util.List;
import org.tizen.nativeplatform.manifest.ApplicationData;

public class PlatformManifestModel {
    private String appId;
    private String label;
    private List<ApplicationData> appDatas = new ArrayList<ApplicationData>();

    public void setAppId(String id) {
        this.appId = id;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void addAppData(ApplicationData data) {
        this.appDatas.add(data);
    }

    public String getAppId() {
        if (this.appDatas.size() <= 0) {
            return null;
        }
        String id = "";
        for (ApplicationData data : this.appDatas) {
            id = data.getId();
            if (id == null || id.isEmpty()) continue;
            return id;
        }
        return null;
    }

    public String getLabel() {
        return this.label;
    }

    public List<ApplicationData> getAppDatas() {
        return this.appDatas;
    }

    public List<String> getExecutableFiles() {
        ArrayList<String> files = new ArrayList<String>();
        if (this.appDatas.size() <= 0) {
            return files;
        }
        for (ApplicationData data : this.appDatas) {
            String exec = data.getExec();
            if (exec == null || exec.isEmpty()) continue;
            files.add(exec);
        }
        return files;
    }

    public void clear() {
        this.appDatas.clear();
    }
}

