/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.pkgmgr.ui;

import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.tizen.nativeplatform.pkg.model.PkgInfo;
import org.tizen.nativeplatform.pkgmgr.ui.PkgPropertiesDialog;
import org.tizen.nativeplatform.repo.model.Repository;
import org.tizen.nativeplatform.repo.model.RepositoryProvider;

public class PropertiesCommonTab {
    private TabFolder folder = null;
    private PkgInfo pkgInfo = null;
    private final String BUNDLE_NAME = String.valueOf(PkgPropertiesDialog.class.getPackage().getName()) + ".PkgMgrUIMessages";
    private ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);

    public PropertiesCommonTab(Shell shell, TabFolder folder, PkgInfo pkgInfo) {
        this.folder = folder;
        this.pkgInfo = pkgInfo;
    }

    protected CopyOnWriteArrayList<Repository> getRepositoryList() {
        return RepositoryProvider.INSTANCE.getBuildsystemRepos();
    }

    public void createTab() {
        this.createCommonTab(this.resources.getString("PropDlg.Tab.Common"));
    }

    protected void createCommonTab(String title) {
        TabItem tab = new TabItem(this.folder, 0);
        tab.setText(title);
        Composite composite = new Composite((Composite)this.folder, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createInfoComposite(composite);
        tab.setControl((Control)composite);
    }

    private void createInfoComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(1808));
        Label lName = new Label(composite, 0);
        lName.setText(this.resources.getString("PropDlg.Label.Package"));
        Label lNameValue = new Label(composite, 0);
        lNameValue.setText(": " + this.pkgInfo.getName());
        Label lVer = new Label(composite, 0);
        lVer.setText(this.resources.getString("PropDlg.Label.Version"));
        Label lVerValue = new Label(composite, 0);
        lVerValue.setText(": " + this.pkgInfo.getVersion());
        Label lArch = new Label(composite, 0);
        lArch.setText(this.resources.getString("PropDlg.Label.Arch"));
        Label lArchValue = new Label(composite, 0);
        lArchValue.setText(": " + this.pkgInfo.getArch());
        Label lStatus = new Label(composite, 0);
        lStatus.setText(this.resources.getString("PropDlg.Label.Status"));
        Label lStatusValue = new Label(composite, 0);
        if (this.pkgInfo.isInstalled()) {
            lStatusValue.setText(": Installed");
        } else {
            lStatusValue.setText(": Not Installed");
        }
        Label lSize = new Label(composite, 0);
        lSize.setText(this.resources.getString("PropDlg.Label.Size"));
        Label lSizeValue = new Label(composite, 0);
        lSizeValue.setText(": " + this.pkgInfo.getSize());
        Label lVendor = new Label(composite, 0);
        lVendor.setText(this.resources.getString("PropDlg.Label.Vendor"));
        Label lVendorValue = new Label(composite, 0);
        lVendorValue.setText(": " + this.pkgInfo.getVendor());
        Label lSummary = new Label(composite, 0);
        lSummary.setText(this.resources.getString("PropDlg.Label.Summary"));
        GridData gd = new GridData(2);
        lSummary.setLayoutData((Object)gd);
        Label lDelimiter = new Label(composite, 0);
        lDelimiter.setText(":");
        Text tSummaryValue = new Text(composite, 2114);
        tSummaryValue.setText(this.pkgInfo.getSummary());
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        tSummaryValue.setLayoutData((Object)gd);
    }
}

