/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.pkg.tools;

public class PkgcmdTool {
    public static final String NAME = "pkgcmd";
    public static final String PATH = "/usr/bin/pkgcmd";
    private static final String WS = " ";
    private static final String TOOL = "/usr/bin/pkgcmd";
    private static final String INSTALL_OP = "--install";
    private static final String PKGTYPE_OP = "--package-type";
    private static final String PKGPATH_OP = "--package-path";
    private static final String PKGNAME_OP = "--package-name";
    private static final String CHECK_OP = "--check";
    private static final String KILL_OP = "--kill";
    private static final String QUIET_OP = "--quiet";

    public static String installCommand(String[] list) {
        return PkgcmdTool.installCommand(list[0]);
    }

    public static String getInstallCommandFormat() {
        StringBuffer command = new StringBuffer();
        command.append(INSTALL_OP).append(WS);
        command.append(QUIET_OP).append(WS);
        command.append(PKGTYPE_OP).append(WS);
        command.append("rpm").append(WS);
        command.append(PKGPATH_OP).append(WS);
        command.append("%s");
        return command.toString();
    }

    public static String installCommand(String commandFormat, String file) {
        String command = "/usr/bin/pkgcmd " + String.format(commandFormat, file);
        return command;
    }

    public static String installCommand(String file) {
        return PkgcmdTool.makeCommand(INSTALL_OP, QUIET_OP, PKGTYPE_OP, "rpm", PKGPATH_OP, file);
    }

    public static String isRunningAppCommand(String pkgName) {
        return PkgcmdTool.makeCommand(CHECK_OP, PKGTYPE_OP, "rpm", PKGNAME_OP, pkgName);
    }

    public static String killApp(String pkgName) {
        return PkgcmdTool.makeCommand(KILL_OP, PKGTYPE_OP, "rpm", PKGNAME_OP, pkgName);
    }

    private static String makeCommand(String ... options) {
        StringBuffer sbCommand = new StringBuffer("/usr/bin/pkgcmd ");
        String[] stringArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            String op = stringArray[n2];
            if (!(op = op.trim()).isEmpty()) {
                sbCommand.append(String.valueOf(op) + WS);
            }
            ++n2;
        }
        return sbCommand.toString().trim();
    }
}

