/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.pkgmgr.ui;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.common.util.DialogUtil;
import org.tizen.nativeplatform.pkgmgr.ui.RepoCommonDialog;
import org.tizen.nativeplatform.repo.commander.RepoManager;

public class ModifyRepoDialog
extends RepoCommonDialog {
    private String name = "";
    private String prevUrl = "";
    private boolean isDirty = false;
    private String newUrl = null;

    protected ModifyRepoDialog(Shell parentShell) {
        super(parentShell);
    }

    public ModifyRepoDialog(Shell parentShell, String tab, String name, String url, boolean supportLocalRepo) {
        super(parentShell);
        this.prevUrl = url;
        this.name = name;
        this.type = RepoManager.getURLType(url);
        this.supportLocalRepo = supportLocalRepo;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell, this.resources.getString("ModifyRepo.Title"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(770));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createNameComposite(composite);
        this.createRepoComposite(composite);
        return composite;
    }

    private void createNameComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(770));
        composite.setLayout((Layout)new GridLayout(2, false));
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(this.resources.getString("ModifyRepo.Label.Name"));
        Label nameValue = new Label(composite, 0);
        nameValue.setText(this.name);
    }

    @Override
    protected void initControls() {
        if (this.supportLocalRepo) {
            if (RepoManager.isLocalType(this.type)) {
                this.localCheckBt.setSelection(true);
                this.localText.setText(this.prevUrl);
                this.browseBt.setEnabled(true);
                this.remoteText.setEnabled(false);
            } else {
                this.remoteCheckBt.setSelection(true);
                this.remoteText.setText(this.prevUrl);
                this.localText.setEnabled(false);
                this.browseBt.setEnabled(false);
            }
        } else {
            this.remoteCheckBt.setSelection(true);
            this.remoteText.setText(this.prevUrl);
        }
    }

    protected void okPressed() {
        if (this.remoteCheckBt.getSelection()) {
            this.newUrl = this.remoteText.getText();
            if (this.newUrl == null || this.newUrl.isEmpty()) {
                DialogUtil.openErrorDialog((String)this.resources.getString("AddRepo.Msg.Error.URLEmpty"));
                return;
            }
            this.type = RepoManager.REMOTE_REPO_TYPE;
        } else if (this.localCheckBt.getSelection()) {
            this.newUrl = this.localText.getText();
            if (this.newUrl == null || this.newUrl.isEmpty()) {
                DialogUtil.openErrorDialog((String)this.resources.getString("AddRepo.Msg.Error.URLEmpty"));
                return;
            }
            this.type = RepoManager.LOCAL_REPO_TYPE;
        }
        if (!this.validateRootstrapUrl()) {
            return;
        }
        this.newUrl = this.newUrl.trim();
        this.isDirty = !this.newUrl.equals(this.prevUrl);
        super.okPressed();
    }

    public String getRepositoryName() {
        return this.name;
    }

    public String getRepositoryURL() {
        return this.newUrl;
    }

    public boolean isDirty() {
        return this.isDirty;
    }
}

