/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.preferences;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;
import org.tizen.nativeplatform.Activator;

public class PreferencesManager {
    public static final String PASSWORD_KEY = "sudo.password";
    public static final String HOST_IP = "host.ip";
    private static final String GIT_ACTIVE_CONFIG = "git.active.config";
    private static final String GIT_CONFIG_NAME = "site.config.name";
    private static final String GIT_BASE_URI = "git.base.uri";
    private static final String GIT_LIST_TYPE = "git.list.type";
    private static final String GIT_LIST_LOCATION = "git.list.location";
    private static final String GIT_CONFIG_DELIMITER = "|";
    public static final String GIT_LIST_WEB = "GITWEB";
    public static final String GIT_LIST_LOCAL = "LOCAL";
    private static final String DEFAULT_GIT_CONFIG_NAME = "Tizen-Public";
    private static final String DEFAULT_GIT_BASE_URI = "review.tizen.org";
    private static final String DEFAULT_GIT_LIST_TYPE = "GITWEB";
    private static final String DEFAULT_GIT_LIST_LOCATION = "https://review.tizen.org/git/";
    private static final String GIT_LIST_CACHE_FILE_FORMAT = ".%s.index.html";
    private static final String SNAPSHOT_HISTORY = "snapshot.history";
    private static final String SNAPSHOT_LATEST = "snapshot.latest";
    protected static IPreferenceStore prefStore = Activator.getDefault().getPreferenceStore();
    protected static ServiceTracker<IProxyService, IProxyService> proxyTracker = null;

    public static void setDefaultValues() {
        if (!prefStore.contains(GIT_CONFIG_NAME)) {
            PreferencesManager.addSiteConfiguration(DEFAULT_GIT_CONFIG_NAME, DEFAULT_GIT_BASE_URI, "GITWEB", DEFAULT_GIT_LIST_LOCATION);
        }
    }

    public static IPreferenceStore getPreferenceStore() {
        return prefStore;
    }

    public static void setSnapshotHistory(String value) {
        prefStore.setValue(SNAPSHOT_HISTORY, value);
    }

    public static String getSnapshotHistory() {
        return prefStore.getString(SNAPSHOT_HISTORY);
    }

    public static void setSnapshotLatest(String value) {
        prefStore.setValue(SNAPSHOT_LATEST, value);
    }

    public static String getSnapshotLatest() {
        return prefStore.getString(SNAPSHOT_LATEST);
    }

    public static void setPassword(String p) {
        prefStore.setValue(PASSWORD_KEY, p);
    }

    public static void setHostIp(String value) {
        prefStore.setValue(HOST_IP, value);
    }

    public static String getHostIp() {
        return prefStore.getString(HOST_IP);
    }

    public static boolean isProxyUsed() {
        return PreferencesManager.isSystemProxyUsed();
    }

    public static Proxy getProxy() {
        if (PreferencesManager.isProxyUsed()) {
            String host = PreferencesManager.getProxyHost();
            if (host == null) {
                return null;
            }
            int port = PreferencesManager.getProxyPort();
            String protocol = PreferencesManager.getProxyProtocol();
            if (protocol == null) {
                return null;
            }
            Proxy.Type proxyType = protocol.equals("socks") ? Proxy.Type.SOCKS : Proxy.Type.HTTP;
            return new Proxy(proxyType, new InetSocketAddress(host, port));
        }
        return null;
    }

    public static String getProxyURL() {
        return PreferencesManager.getSystemProxyURL();
    }

    public static String[] getProxyParsedURL() {
        String[] proxyURL = PreferencesManager.getSystemProxyParsedURL();
        return proxyURL;
    }

    public static String getProxyProtocol() {
        String[] proxyURL = PreferencesManager.getProxyParsedURL();
        if (proxyURL == null) {
            return null;
        }
        return proxyURL[0];
    }

    public static String getProxyHost() {
        String[] proxyURL = PreferencesManager.getProxyParsedURL();
        if (proxyURL == null) {
            return null;
        }
        return proxyURL[1];
    }

    public static int getProxyPort() {
        String[] proxyURL = PreferencesManager.getProxyParsedURL();
        if (proxyURL == null) {
            return -1;
        }
        return Integer.parseInt(proxyURL[2]);
    }

    private static boolean isSystemProxyUsed() {
        return PreferencesManager.getSystemProxyURL() != null;
    }

    private static String getSystemProxyURL() {
        IProxyData data = PreferencesManager.getProxyData("HTTP");
        if (data != null) {
            return String.format("http://%s:%d", data.getHost(), data.getPort());
        }
        data = PreferencesManager.getProxyData("HTTPS");
        if (data != null) {
            return String.format("https://%s:%d", data.getHost(), data.getPort());
        }
        data = PreferencesManager.getProxyData("SOCKS");
        if (data != null) {
            return String.format("socks://%s:%d", data.getHost(), data.getPort());
        }
        return null;
    }

    private static String[] getSystemProxyParsedURL() {
        String[] parsedUrl = new String[]{"", "", ""};
        IProxyData data = PreferencesManager.getProxyData("HTTP");
        if (data != null) {
            parsedUrl[0] = "HTTP".toLowerCase();
            parsedUrl[1] = data.getHost();
            parsedUrl[2] = Integer.toString(data.getPort());
            return parsedUrl;
        }
        data = PreferencesManager.getProxyData("HTTPS");
        if (data != null) {
            parsedUrl[0] = "HTTPS".toLowerCase();
            parsedUrl[1] = data.getHost();
            parsedUrl[2] = Integer.toString(data.getPort());
            return parsedUrl;
        }
        data = PreferencesManager.getProxyData("SOCKS");
        if (data != null) {
            parsedUrl[0] = "SOCKS".toLowerCase();
            parsedUrl[1] = data.getHost();
            parsedUrl[2] = Integer.toString(data.getPort());
            return parsedUrl;
        }
        return null;
    }

    public static String getHttpProxyURL() {
        IProxyData data = PreferencesManager.getProxyData("HTTP");
        if (data != null) {
            return String.format("http://%s:%d", data.getHost(), data.getPort());
        }
        data = PreferencesManager.getProxyData("HTTPS");
        if (data != null) {
            return String.format("https://%s:%d", data.getHost(), data.getPort());
        }
        return "";
    }

    private static synchronized IProxyData getProxyData(String proxyType) {
        IProxyData data;
        IProxyService service;
        if (proxyTracker == null) {
            Bundle bundle = FrameworkUtil.getBundle(PreferencesManager.class);
            if (bundle != null) {
                proxyTracker = new ServiceTracker(bundle.getBundleContext(), IProxyService.class.getName(), null);
            }
            if (proxyTracker == null) {
                return null;
            }
            proxyTracker.open();
        }
        if ((service = (IProxyService)proxyTracker.getService()).isProxiesEnabled() && (data = service.getProxyData(proxyType)) != null && data.getHost() != null && !data.getHost().isEmpty()) {
            return data;
        }
        return null;
    }

    public static String getPassword() {
        return prefStore.getString(PASSWORD_KEY);
    }

    public static String getActiveGitBaseURI() {
        List<String> baseURIs = PreferencesManager.loadGitBaseURI();
        int activeId = prefStore.getInt(GIT_ACTIVE_CONFIG);
        if (baseURIs.size() > 0 && activeId >= 0) {
            return baseURIs.get(activeId);
        }
        return "";
    }

    public static String getActiveGitListType() {
        List<String> listTypes = PreferencesManager.loadGitListType();
        int activeId = prefStore.getInt(GIT_ACTIVE_CONFIG);
        if (listTypes.size() > 0 && activeId >= 0) {
            return listTypes.get(activeId);
        }
        return "";
    }

    public static String getActiveGitListLocation() {
        List<String> listLocations = PreferencesManager.loadGitListLocation();
        int activeId = prefStore.getInt(GIT_ACTIVE_CONFIG);
        if (listLocations.size() > 0 && activeId >= 0) {
            return listLocations.get(activeId);
        }
        return "";
    }

    public static synchronized SiteConfiguration loadActiveSiteConfiguration() {
        List<String> names = PreferencesManager.loadSiteConfigName();
        List<String> baseURIs = PreferencesManager.loadGitBaseURI();
        List<String> listTypes = PreferencesManager.loadGitListType();
        List<String> listLocations = PreferencesManager.loadGitListLocation();
        int activeId = prefStore.getInt(GIT_ACTIVE_CONFIG);
        if (activeId == -1) {
            return null;
        }
        SiteConfiguration newConfig = new SiteConfiguration(names.get(activeId), baseURIs.get(activeId), listTypes.get(activeId), listLocations.get(activeId));
        newConfig.setActive(true);
        return newConfig;
    }

    public static synchronized SiteConfiguration loadSiteConfiguration(int idx) {
        String name = PreferencesManager.loadSiteConfigName(idx);
        String baseURI = PreferencesManager.loadGitBaseURI(idx);
        String listType = PreferencesManager.loadGitListType(idx);
        String listLocation = PreferencesManager.loadGitListLocation(idx);
        SiteConfiguration newConfig = new SiteConfiguration(name, baseURI, listType, listLocation);
        return newConfig;
    }

    public static synchronized ArrayList<SiteConfiguration> loadSiteConfigurations() {
        List<String> names = PreferencesManager.loadSiteConfigName();
        List<String> baseURIs = PreferencesManager.loadGitBaseURI();
        List<String> listTypes = PreferencesManager.loadGitListType();
        List<String> listLocations = PreferencesManager.loadGitListLocation();
        int activeId = prefStore.getInt(GIT_ACTIVE_CONFIG);
        ArrayList<SiteConfiguration> list = new ArrayList<SiteConfiguration>();
        int idx = 0;
        while (idx < names.size()) {
            SiteConfiguration newConfig = new SiteConfiguration(names.get(idx), baseURIs.get(idx), listTypes.get(idx), listLocations.get(idx));
            if (activeId == idx) {
                newConfig.setActive(true);
            }
            list.add(newConfig);
            ++idx;
        }
        return list;
    }

    public static synchronized void addSiteConfiguration(String name, String baseURI, String listType, String location) {
        List<String> newList = PreferencesManager.loadSiteConfigName();
        newList.add(name);
        PreferencesManager.saveGitConfigName(newList);
        newList = PreferencesManager.loadGitBaseURI();
        newList.add(baseURI);
        PreferencesManager.saveGitBaseURI(newList);
        newList = PreferencesManager.loadGitListType();
        newList.add(listType);
        PreferencesManager.saveGitListType(newList);
        newList = PreferencesManager.loadGitListLocation();
        newList.add(location);
        PreferencesManager.saveGitListLocation(newList);
        if (newList.size() == 1) {
            PreferencesManager.setActiveSiteConfiguration(0);
        }
    }

    public static synchronized void updateSiteConfiguration(int id, String name, String baseURI, String listType, String location) {
        List<String> newList = PreferencesManager.loadSiteConfigName();
        newList.set(id, name);
        PreferencesManager.saveGitConfigName(newList);
        newList = PreferencesManager.loadGitBaseURI();
        newList.set(id, baseURI);
        PreferencesManager.saveGitBaseURI(newList);
        newList = PreferencesManager.loadGitListType();
        newList.set(id, listType);
        PreferencesManager.saveGitListType(newList);
        newList = PreferencesManager.loadGitListLocation();
        newList.set(id, location);
        PreferencesManager.saveGitListLocation(newList);
    }

    public static synchronized void setActiveSiteConfiguration(int id) {
        prefStore.setValue(GIT_ACTIVE_CONFIG, id);
    }

    public static synchronized void removeSiteConfiguration(int id) {
        List<String> newList = PreferencesManager.loadSiteConfigName();
        newList.remove(id);
        PreferencesManager.saveGitConfigName(newList);
        newList = PreferencesManager.loadGitBaseURI();
        newList.remove(id);
        PreferencesManager.saveGitBaseURI(newList);
        newList = PreferencesManager.loadGitListType();
        newList.remove(id);
        PreferencesManager.saveGitListType(newList);
        newList = PreferencesManager.loadGitListLocation();
        newList.remove(id);
        PreferencesManager.saveGitListLocation(newList);
        int prevActiveId = prefStore.getInt(GIT_ACTIVE_CONFIG);
        if (prevActiveId == id) {
            if (newList.size() == 0) {
                PreferencesManager.setActiveSiteConfiguration(-1);
            } else {
                PreferencesManager.setActiveSiteConfiguration(0);
            }
        } else if (prevActiveId > id) {
            PreferencesManager.setActiveSiteConfiguration(id - 1);
        }
    }

    private static List<String> loadSiteConfigName() {
        String values = prefStore.getString(GIT_CONFIG_NAME);
        if (!values.isEmpty()) {
            return new ArrayList<String>(Arrays.asList(values.split("[|]")));
        }
        return new ArrayList<String>();
    }

    private static String loadSiteConfigName(int idx) {
        List<String> values = PreferencesManager.loadSiteConfigName();
        if (!values.isEmpty()) {
            return values.get(idx);
        }
        return "";
    }

    private static void saveGitConfigName(List<String> list) {
        prefStore.setValue(GIT_CONFIG_NAME, PreferencesManager.generateListString(list));
    }

    private static List<String> loadGitBaseURI() {
        String values = prefStore.getString(GIT_BASE_URI);
        if (!values.isEmpty()) {
            return new ArrayList<String>(Arrays.asList(values.split("[|]")));
        }
        return new ArrayList<String>();
    }

    private static String loadGitBaseURI(int idx) {
        List<String> values = PreferencesManager.loadGitBaseURI();
        if (!values.isEmpty()) {
            return values.get(idx);
        }
        return "";
    }

    private static void saveGitBaseURI(List<String> list) {
        prefStore.setValue(GIT_BASE_URI, PreferencesManager.generateListString(list));
    }

    private static List<String> loadGitListType() {
        String values = prefStore.getString(GIT_LIST_TYPE);
        if (!values.isEmpty()) {
            return new ArrayList<String>(Arrays.asList(values.split("[|]")));
        }
        return new ArrayList<String>();
    }

    private static String loadGitListType(int idx) {
        List<String> values = PreferencesManager.loadGitListType();
        if (!values.isEmpty()) {
            return values.get(idx);
        }
        return "";
    }

    private static void saveGitListType(List<String> list) {
        prefStore.setValue(GIT_LIST_TYPE, PreferencesManager.generateListString(list));
    }

    private static List<String> loadGitListLocation() {
        String values = prefStore.getString(GIT_LIST_LOCATION);
        if (!values.isEmpty()) {
            return new ArrayList<String>(Arrays.asList(values.split("[|]")));
        }
        return new ArrayList<String>();
    }

    private static String loadGitListLocation(int idx) {
        List<String> values = PreferencesManager.loadGitListLocation();
        if (!values.isEmpty()) {
            return values.get(idx);
        }
        return "";
    }

    private static void saveGitListLocation(List<String> list) {
        prefStore.setValue(GIT_LIST_LOCATION, PreferencesManager.generateListString(list));
    }

    private static String generateListString(List<String> list) {
        StringBuffer sbNewList = new StringBuffer();
        for (String item : list) {
            if (sbNewList.length() != 0) {
                sbNewList.append(GIT_CONFIG_DELIMITER);
            }
            sbNewList.append(item);
        }
        return sbNewList.toString();
    }

    public static class SiteConfiguration {
        private String name;
        private String baseURI;
        private String listType;
        private String listLocation;
        private boolean isActive;

        public SiteConfiguration(String name1, String baseURI1, String listType1, String listLocation1) {
            this.name = name1;
            this.baseURI = baseURI1;
            this.listType = listType1;
            this.listLocation = listLocation1;
            this.isActive = false;
        }

        public void setActive(boolean value) {
            this.isActive = value;
        }

        public String getListCacheFile() {
            return ResourcesPlugin.getWorkspace().getRoot().getLocation().append(String.format(PreferencesManager.GIT_LIST_CACHE_FILE_FORMAT, this.name)).toOSString();
        }

        public String getName() {
            return this.name;
        }

        public String getListType() {
            return this.listType;
        }

        public String getListLocation() {
            return this.listLocation;
        }

        public String getBaseURI() {
            return this.baseURI;
        }

        public boolean isSetActive() {
            return this.isActive;
        }
    }
}

