/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.builder.build.gbs;

import org.eclipse.core.resources.IProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.FileUtil;
import org.tizen.nativeplatform.command.launcher.HostCommandLauncher;

public class GBSUtil {
    private static String GBS_VERSION = "";
    protected static final Logger logger = LoggerFactory.getLogger(GBSUtil.class);

    public static boolean checkTool() {
        int dot_firstIdx;
        String _version;
        String command;
        block8: {
            String[] results;
            block7: {
                block6: {
                    try {
                        if (GBSUtil.existGitCommand()) break block6;
                        return false;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                String cmd = String.format("%s --version", "gbs");
                String result = HostCommandLauncher.executeOutput((String)cmd, null, (boolean)true, null);
                results = result.trim().split(" ");
                if (results.length == 2) break block7;
                return false;
            }
            command = results[0];
            _version = results[1];
            GBS_VERSION = " (Version: " + _version + ")";
            dot_firstIdx = _version.indexOf(46);
            if (dot_firstIdx >= 0) break block8;
            return false;
        }
        int dot_secondIdx = _version.indexOf(46, dot_firstIdx + 1);
        String version = _version;
        if (dot_secondIdx > -1) {
            version = _version.substring(0, dot_secondIdx);
        }
        double ver = Double.parseDouble(version);
        return command.equals("gbs") && !(ver < 0.16);
    }

    public static String getGBSVersion() {
        return GBS_VERSION;
    }

    public static void gbsBuildInit(IProject project) {
        String prjPath = project.getLocation().toString();
        String gitPath = FileUtil.appendPath((String)prjPath, (String)".git");
        try {
            if (!FileUtil.isExist((String)gitPath)) {
                HostCommandLauncher.execute((String)"git init", (String)prjPath, null, null);
                HostCommandLauncher.execute((String)"git add *", (String)prjPath, null, null);
                HostCommandLauncher.execute((String)"git commit -m \"Initialization Repository\"", (String)prjPath, null, null);
            } else if (GBSUtil.needGitInitCommit(prjPath)) {
                HostCommandLauncher.execute((String)"git add *", (String)prjPath, null, null);
                HostCommandLauncher.execute((String)"git commit -m \"Initialization Repository\"", (String)prjPath, null, null);
            }
        }
        catch (InterruptedException e) {
            logger.error("Fail to execute cmd:" + e);
        }
    }

    public static boolean existGitCommand() {
        String cmd = String.format("which %s", "gbs");
        try {
            return HostCommandLauncher.execute((String)cmd);
        }
        catch (InterruptedException e) {
            logger.error("Fail to execute cmd:" + e);
            return false;
        }
    }

    public static boolean needGitInitCommit(String workingDir) {
        String cmd = String.format("git log -n 1", new Object[0]);
        try {
            return !HostCommandLauncher.execute((String)cmd, (String)workingDir, null, null);
        }
        catch (InterruptedException e) {
            logger.error("Fail to execute cmd:" + e);
            return false;
        }
    }
}

