/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.rootstrap;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.OSChecker;
import org.tizen.nativeplatform.rootstrap.IRootstrapManager;
import org.tizen.nativeplatform.rootstrap.view.ui.IRootstrapViewProvider;
import org.tizen.nativeplatform.rootstrap.view.ui.RootstrapView;

public class RootstrapManagerFactory {
    private static final String EXTENSION_ID = "org.tizen.nativeplatform.rootstrapmanager";
    private static final String TAG_PROVIDER = "viewProvider";
    private static final String TAG_MANAGER = "manager";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_OS = "os";
    private static final String ATTR_CLASS = "class";
    private RootstrapView view;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public RootstrapManagerFactory(RootstrapView view) {
        this.view = view;
    }

    public RootstrapManagerFactory() {
    }

    public RootstrapView getRootstrapView() {
        return this.view;
    }

    public IRootstrapViewProvider getProviders() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(EXTENSION_ID);
        IExtension[] exts = ep.getExtensions();
        ArrayList<Proxy> found = new ArrayList<Proxy>();
        int i = 0;
        while (i < exts.length) {
            IConfigurationElement[] configElems = exts[i].getConfigurationElements();
            int j = 0;
            while (j < configElems.length) {
                Proxy proxy = this.parseType(configElems[j], TAG_PROVIDER);
                if (proxy != null) {
                    found.add(proxy);
                }
                ++j;
            }
            ++i;
        }
        Proxy[] proxy = found.toArray(new Proxy[found.size()]);
        int i2 = 0;
        while (i2 < proxy.length) {
            if (OSChecker.isLinux() || OSChecker.isUnix() ? proxy[i2].getOs().equals("linux") || proxy[i2].getOs().equals("unix") : OSChecker.isWindows() && (proxy[i2].getOs().equals("windows") || proxy[i2].getOs().equals("win"))) {
                return (IRootstrapViewProvider)proxy[i2].getProvider();
            }
            ++i2;
        }
        return null;
    }

    public IRootstrapManager getManager() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(EXTENSION_ID);
        IExtension[] exts = ep.getExtensions();
        ArrayList<Proxy> found = new ArrayList<Proxy>();
        int i = 0;
        while (i < exts.length) {
            IConfigurationElement[] configElems = exts[i].getConfigurationElements();
            int j = 0;
            while (j < configElems.length) {
                Proxy proxy = this.parseType(configElems[j], TAG_MANAGER);
                if (proxy != null) {
                    found.add(proxy);
                }
                ++j;
            }
            ++i;
        }
        Proxy[] proxy = found.toArray(new Proxy[found.size()]);
        int i2 = 0;
        while (i2 < proxy.length) {
            if (OSChecker.isLinux() || OSChecker.isUnix() ? proxy[i2].getOs().equals("linux") || proxy[i2].getOs().equals("unix") : OSChecker.isWindows() && (proxy[i2].getOs().equals("windows") || proxy[i2].getOs().equals("win"))) {
                return (IRootstrapManager)proxy[i2].getProvider();
            }
            ++i2;
        }
        return null;
    }

    private Proxy parseType(IConfigurationElement configElem, String tag) {
        if (!configElem.getName().equals(tag)) {
            return null;
        }
        try {
            return new Proxy(configElem);
        }
        catch (Exception e) {
            String name = configElem.getAttribute(ATTR_NAME);
            if (name == null) {
                name = "[missing name attribute]";
            }
            String msg = "Failed to load provider named" + name + " in " + configElem.getDeclaringExtension().getNamespace();
            this.logger.error(msg, (Throwable)e);
            return null;
        }
    }

    private static class Proxy {
        private IConfigurationElement configElement;
        private String id;
        private String os;
        protected final Logger logger = LoggerFactory.getLogger(this.getClass());

        public Proxy(IConfigurationElement configElem) {
            this.configElement = configElem;
            this.id = this.getAttribute(configElem, RootstrapManagerFactory.ATTR_ID, "");
            this.os = this.getAttribute(configElem, RootstrapManagerFactory.ATTR_OS, "linux");
            this.getAttribute(configElem, RootstrapManagerFactory.ATTR_CLASS, null);
        }

        private String getAttribute(IConfigurationElement configElem, String name, String defaultValue) {
            String value = configElem.getAttribute(name);
            if (value != null) {
                return value;
            }
            if (defaultValue != null) {
                return defaultValue;
            }
            throw new IllegalArgumentException("Missing" + name + "attribute");
        }

        public String getOs() {
            return this.os;
        }

        public Object getProvider() {
            Object obj = null;
            try {
                obj = this.configElement.createExecutableExtension(RootstrapManagerFactory.ATTR_CLASS);
            }
            catch (CoreException e) {
                String msg = "Failed to get provider: " + this.configElement.getAttribute(RootstrapManagerFactory.ATTR_CLASS) + " in type: " + this.id + " in plugin: " + this.configElement.getDeclaringExtension().getNamespace();
                this.logger.error(msg, (Throwable)e);
            }
            return obj;
        }
    }
}

