/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.delegate;

import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.sourcelookup.MappingSourceContainer;
import org.eclipse.cdt.debug.internal.core.sourcelookup.MapEntrySourceContainer;
import org.eclipse.cdt.debug.mi.core.GDBCDIDebugger2;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.OSChecker;
import org.tizen.nativecommon.launch.LaunchUtils;
import org.tizen.nativecommon.launch.TizenLaunchMessages;
import org.tizen.nativeplatform.PlatformInstances;
import org.tizen.nativeplatform.RootstrapProxy;
import org.tizen.nativeplatform.launcher.LauncherInstances;
import org.tizen.nativeplatform.launcher.command.provider.IRunCommandProvider;
import org.tizen.nativeplatform.launcher.delegate.CoredumpLaunchConfigurationProcessor;
import org.tizen.nativeplatform.launcher.delegate.ILaunchConfigurationProcessor;
import org.tizen.nativeplatform.launcher.delegate.PlatformLaunchDelegate;
import org.tizen.nativeplatform.launcher.message.PlatformLaunchMessages;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.pkg.commander.ICommandStatus;
import org.tizen.nativeplatform.pkg.commander.IPkgCommander;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.types.CmdTargetTypes;
import org.tizen.nativeplatform.util.PlatformFileUtil;

public class PlatformLaunchDelegateForCoredump
extends PlatformLaunchDelegate {
    protected ISourceLookupDirector fLocator = null;
    private final String PLATFORM_SOURCE_CONTAINER = "Platform Source mapping";
    protected final Logger logger = LoggerFactory.getLogger(PlatformLaunchDelegateForCoredump.class);

    @Override
    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.isCoredump = true;
        super.launch(config, mode, launch, monitor);
    }

    @Override
    protected void launchApplicationForDebug(ILaunch launch, ILaunchConfiguration config, IBinaryParser.IBinaryObject exeFile, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask("", 1);
            monitor.subTask(TizenLaunchMessages.LAUNCH_APPLICATION);
            this.launchApplicationWithGDBClient(launch, config, exeFile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
    }

    @Override
    protected void launchApplicationWithGDBClient(ILaunch launch, ILaunchConfiguration config, IBinaryParser.IBinaryObject exeFile, IProgressMonitor monitor) throws CoreException {
        try {
            try {
                monitor.beginTask("", 2);
                monitor.subTask(TizenLaunchMessages.LAUNCH_APPLICATION_WITH_GDBCLIENT);
                try {
                    this.debugSession = this.getDebugSession(launch, config, exeFile, monitor);
                }
                catch (CoreException e) {
                    LaunchUtils.newCoreException((String)TizenLaunchMessages.GDB_CANNOT_CONNECT_GDBSERVER, (Throwable)e);
                }
                if (this.debugSession == null) {
                    LaunchUtils.newCoreException((String)TizenLaunchMessages.GDB_CANNOT_CREATE_SESSION, null);
                }
                boolean attrDebuggerStopAtMain = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", false);
                String attrDebuggerStopAtMainSymbol = null;
                if (attrDebuggerStopAtMain) {
                    attrDebuggerStopAtMainSymbol = launch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", "main");
                }
                ICDITarget[] targetArray = this.debugSession.getTargets();
                int i = 0;
                while (i < targetArray.length) {
                    Process proc = targetArray[i].getProcess();
                    IProcess iproc = null;
                    if (proc != null) {
                        iproc = DebugPlugin.newProcess((ILaunch)launch, (Process)proc, (String)exeFile.getName(), null);
                    }
                    CDIDebugModel.newDebugTarget((ILaunch)launch, (IProject)this.project, (ICDITarget)targetArray[i], (String)"Tizen debugger", (IProcess)iproc, (IBinaryParser.IBinaryObject)exeFile, (boolean)true, (boolean)false, (String)attrDebuggerStopAtMainSymbol, (boolean)true);
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.newCoreException(TizenLaunchMessages.CANNOT_LAUNCH_APPLICATION_WITH_GDBCLIENT, e);
                monitor.worked(2);
                monitor.done();
            }
        }
        finally {
            monitor.worked(2);
            monitor.done();
        }
    }

    @Override
    protected ICDISession getDebugSession(ILaunch launch, ILaunchConfiguration config, IBinaryParser.IBinaryObject exeFile, IProgressMonitor monitor) throws CoreException {
        String appPath = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
        Path hostPath = null;
        if (OSChecker.isWindows()) {
            hostPath = new Path(appPath);
        } else {
            IRunCommandProvider iRunCommandProvider = LauncherInstances.getRunCommandProvider();
            if (iRunCommandProvider != null) {
                hostPath = iRunCommandProvider.getHostPath(this.target, appPath);
            }
        }
        GDBCDIDebugger2 debugger = new GDBCDIDebugger2();
        if (hostPath != null) {
            return debugger.createSession(launch, hostPath.toFile(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        return null;
    }

    @Override
    protected void setDebugConfigAttributes(ILaunchConfiguration config) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
        wc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "core");
        wc.doSave();
    }

    @Override
    protected void processPreDebug(ILaunchConfiguration config) throws CoreException {
        String coredumpPath = config.getAttribute("org.eclipse.cdt.launch.COREFILE_PATH", "");
        String targetPath = this.moveCoredumpFileToTmp(coredumpPath);
        if (targetPath == null) {
            this.newCoreException(String.format(PlatformLaunchMessages.FAILED_COPY_COREDUMP, coredumpPath), null);
        }
        ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
        wc.setAttribute("org.eclipse.cdt.launch.COREFILE_PATH", targetPath);
        wc.doSave();
    }

    @Override
    protected ILaunchConfigurationProcessor getConfigurationProcessor(Shell shell, ILaunchConfiguration launchConfig, IProject project, String mode, PkgCommandTarget target, IProgressMonitor monitor) {
        return new CoredumpLaunchConfigurationProcessor(shell, launchConfig, project, mode, target, monitor);
    }

    private String moveCoredumpFileToTmp(String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        String filename = new Path(path).lastSegment();
        String user = PlatformInstances.getLaunchCommandUtil().getUserHome();
        String dstDirPath = new Path("/tmp").append(user).toString();
        String dstFilePath = new Path("/tmp").append(user).append(filename).toString();
        if (path.equals(dstFilePath) && PlatformFileUtil.existsFile((String)dstFilePath)) {
            return dstFilePath;
        }
        IPkgCommander commander = this.target.getCommander(CmdTargetTypes.ROOTSTRAP);
        commander.makeDir(dstDirPath);
        ICommandStatus status = commander.copyFile(path, dstFilePath);
        if (status == null || !status.isOk()) {
            this.logger.error(String.format("Faile to copy coredump file: %s -> %s", path, dstFilePath));
            return null;
        }
        return PlatformInstances.getLaunchCommandUtil().copyLocalfile(path, dstFilePath);
    }

    @Override
    protected void setSourceContainer(ILaunchConfiguration configuration) {
        PlatformRootstrap rootstrap = this.target.getRootstrap();
        rootstrap.getPath().toString();
        String rootstrapPath = RootstrapProxy.getProxy().getRootstrapLocalPath(rootstrap);
        MappingSourceContainer platformMappingContainer = new MappingSourceContainer("Platform Source mapping");
        MapEntrySourceContainer entry = new MapEntrySourceContainer();
        String backend = "/usr";
        String local = new Path(rootstrapPath).append("usr").toOSString();
        entry.setBackendPath((IPath)new Path(backend));
        entry.setLocalPath((IPath)new Path(local));
        platformMappingContainer.addMapEntry(entry);
        try {
            if (this.fLocator != null) {
                this.fLocator.dispose();
                this.fLocator = null;
            }
            String memento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
            String type = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
            if (type == null) {
                type = configuration.getType().getSourceLocatorId();
            }
            if (type == null) {
                return;
            }
            IPersistableSourceLocator locator = DebugPlugin.getDefault().getLaunchManager().newSourceLocator(type);
            if (!(locator instanceof AbstractSourceLookupDirector)) {
                memento = null;
                type = configuration.getType().getSourceLocatorId();
                if (type == null) {
                    return;
                }
                locator = DebugPlugin.getDefault().getLaunchManager().newSourceLocator(type);
                if (!(locator instanceof AbstractSourceLookupDirector)) {
                    return;
                }
            }
            this.fLocator = (AbstractSourceLookupDirector)locator;
            if (memento == null) {
                this.fLocator.initializeDefaults(configuration);
            } else {
                this.fLocator.initializeFromMemento(memento, configuration);
            }
            ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
            wc.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
            wc.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
            ISourceContainer[] containers = this.fLocator.getSourceContainers();
            boolean existPlatformSourceContainer = false;
            int containerIndex = 0;
            ISourceContainer[] iSourceContainerArray = containers;
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                ISourceContainer container = iSourceContainerArray[n2];
                if (container.getName().equals("Platform Source mapping")) {
                    existPlatformSourceContainer = true;
                    break;
                }
                ++containerIndex;
                ++n2;
            }
            if (existPlatformSourceContainer) {
                containers[containerIndex] = platformMappingContainer;
                this.fLocator.setSourceContainers(containers);
            } else {
                int length = containers.length;
                ISourceContainer[] newContainers = new ISourceContainer[length + 1];
                containerIndex = 0;
                ISourceContainer[] iSourceContainerArray2 = containers;
                int n3 = containers.length;
                int n4 = 0;
                while (n4 < n3) {
                    ISourceContainer container = iSourceContainerArray2[n4];
                    newContainers[containerIndex++] = container;
                    ++n4;
                }
                newContainers[containerIndex] = platformMappingContainer;
                this.fLocator.setSourceContainers(newContainers);
            }
            wc.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, this.fLocator.getMemento());
            wc.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, this.fLocator.getId());
            wc.doSave();
        }
        catch (CoreException e) {
            e.printStackTrace();
            this.logger.error("Failed to set source container", (Throwable)e);
        }
    }
}

