/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.tizen.common.util.ImageUtil;
import org.tizen.nativeplatform.RootstrapProxy;
import org.tizen.nativeplatform.launcher.ui.ExtraPkgTableHoverListener;
import org.tizen.nativeplatform.launcher.ui.ExtraPkgTableViewerAdapter;
import org.tizen.nativeplatform.launcher.ui.ExtraPkgTableViewerProvider;
import org.tizen.nativeplatform.launcher.ui.PlatformCommonTab;
import org.tizen.nativeplatform.pkg.commander.IPkgModelMaker;
import org.tizen.nativeplatform.pkg.model.IPackage;
import org.tizen.nativeplatform.util.CommonPackageUtil;

public class PlatformPackagesTab
extends PlatformCommonTab {
    private final String BUNDLE_NAME = String.valueOf(PlatformPackagesTab.class.getPackage().getName()) + ".LaunchTabUIMessages";
    private ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);
    private Button rootstrapRemoveBt;
    private Button deviceRemoveBt;
    private TableViewer rootstrapTableViewer;
    private TableViewer deviceTableViewer;
    private List<IPackage> devicePackages = new ArrayList<IPackage>();
    private List<IPackage> rootstrapPackages = new ArrayList<IPackage>();
    private String selectedFileList = "";
    private boolean isDebug;

    public PlatformPackagesTab(boolean isDebug) {
        this.isDebug = isDebug;
    }

    public String getName() {
        return "Packages";
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        if (this.isDebug) {
            this.createDeviceTableGroup(comp, 130);
            this.createRootstrapTableGroup(comp, 130);
        } else {
            this.createDeviceTableGroup(comp, 260);
        }
        this.createOptionGroupComposite(comp);
        this.createVerticalSpacer(comp, 1);
    }

    private void createDeviceTableGroupComposite(Composite parent, int heightHint) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        GridData gridData = new GridData(1808);
        gridData.minimumHeight = heightHint;
        gridData.minimumWidth = 300;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)gridData);
        this.createLabelComposite(composite, "Packages to be installed to the device:");
        this.createDeviceTableComposite(composite, heightHint);
    }

    private void createLabelComposite(Composite parent, String label) {
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        Label descLabel = new Label(parent, 0);
        descLabel.setText(label);
        descLabel.setLayoutData((Object)gridData);
    }

    private void createRootstrapTableGroupComposite(Composite parent, int heightHint) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        GridData gridData = new GridData(1808);
        gridData.minimumHeight = heightHint;
        gridData.minimumWidth = 300;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)gridData);
        this.createLabelComposite(composite, "Packages to be installed to the rootstrap:");
        this.createRootstrapTableComposite(composite, heightHint);
    }

    private void createDeviceTableComposite(Composite parent, int heightHint) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        GridData gridData = new GridData(1808);
        gridData.minimumWidth = 350;
        gridData.heightHint = heightHint;
        composite.setLayoutData((Object)gridData);
        this.deviceTableViewer = new TableViewer(composite, 2816);
        Table table = this.deviceTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        String[] columnNames = new String[]{"Package Name", "Install Tool"};
        int[] columnWidths = new int[]{350, 180};
        int i = 0;
        while (i < columnNames.length) {
            TableColumn tableColumn = new TableColumn(table, 16384);
            tableColumn.setText(columnNames[i]);
            tableColumn.setWidth(columnWidths[i]);
            tableColumn.setResizable(true);
            ExtraPkgTableViewerAdapter adapter = new ExtraPkgTableViewerAdapter(this.deviceTableViewer);
            tableColumn.addSelectionListener((SelectionListener)adapter);
            ++i;
        }
        ExtraPkgTableViewerProvider extraPkgTableViewerProvider = new ExtraPkgTableViewerProvider();
        this.deviceTableViewer.setLabelProvider((IBaseLabelProvider)extraPkgTableViewerProvider);
        this.deviceTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.deviceTableViewer.setInput((Object)RootstrapProxy.getProxy().getRootstraps());
        ExtraPkgTableHoverListener hoverListener = new ExtraPkgTableHoverListener(this.getShell(), this.deviceTableViewer);
        table.addListener(12, (Listener)hoverListener);
        table.addListener(1, (Listener)hoverListener);
        table.addListener(5, (Listener)hoverListener);
        table.addListener(32, (Listener)hoverListener);
    }

    private void createDeviceTableButtonComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(2));
        Button addBt = new Button(composite, 8);
        Image addIcon = ImageUtil.getImage((String)"org.tizen.nativeplatform", (String)"icons/rootstrap/add.gif");
        addBt.setImage(addIcon);
        addBt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                FileDialog fd = new FileDialog(PlatformPackagesTab.this.getShell(), 4098);
                fd.setText(PlatformPackagesTab.this.resources.getString("File.Dialog.Title.File"));
                String[] filterExt = new String[]{"*.rpm"};
                fd.setFilterExtensions(filterExt);
                PlatformPackagesTab.this.selectedFileList = fd.open();
                if (PlatformPackagesTab.this.selectedFileList != null) {
                    String[] files = fd.getFileNames();
                    String path = fd.getFilterPath();
                    String[] stringArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String f = stringArray[n2];
                        String filePath = new Path(path).append(f).toOSString();
                        IPkgModelMaker maker = CommonPackageUtil.getModelMaker();
                        IPackage p = maker.makeModel(filePath);
                        if (!PlatformPackagesTab.this.existsPkg(p, PlatformPackagesTab.this.devicePackages)) {
                            PlatformPackagesTab.this.devicePackages.add(p);
                        }
                        ++n2;
                    }
                    PlatformPackagesTab.this.deviceTableViewer.refresh();
                    if (PlatformPackagesTab.this.devicePackages.size() > 0) {
                        PlatformPackagesTab.this.deviceRemoveBt.setEnabled(true);
                    }
                    PlatformPackagesTab.this.updateLaunchConfigurationDialog();
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.deviceRemoveBt = new Button(composite, 8);
        Image removeIcon = ImageUtil.getImage((String)"org.tizen.nativeplatform", (String)"icons/rootstrap/remove.gif");
        this.deviceRemoveBt.setImage(removeIcon);
        if (this.devicePackages.size() > 0) {
            this.deviceRemoveBt.setEnabled(true);
        }
        this.deviceRemoveBt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                TableItem[] items;
                TableItem[] tableItemArray = items = PlatformPackagesTab.this.deviceTableViewer.getTable().getSelection();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    Object data = item.getData();
                    if (data instanceof IPackage) {
                        IPackage pkg = (IPackage)data;
                        if (PlatformPackagesTab.this.devicePackages.contains(pkg)) {
                            PlatformPackagesTab.this.devicePackages.remove(pkg);
                            PlatformPackagesTab.this.deviceTableViewer.refresh();
                            if (PlatformPackagesTab.this.devicePackages.size() <= 0) {
                                PlatformPackagesTab.this.deviceRemoveBt.setEnabled(false);
                            }
                            PlatformPackagesTab.this.updateLaunchConfigurationDialog();
                        }
                    }
                    ++n2;
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    private void createRootstrapTableComposite(Composite parent, int heightHint) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        GridData gridData = new GridData(1808);
        gridData.minimumWidth = 350;
        gridData.heightHint = heightHint;
        composite.setLayoutData((Object)gridData);
        this.rootstrapTableViewer = new TableViewer(composite, 2816);
        Table table = this.rootstrapTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        String[] columnNames = new String[]{"Package Name"};
        int[] columnWidths = new int[]{300};
        int i = 0;
        while (i < columnNames.length) {
            TableColumn tableColumn = new TableColumn(table, 16384);
            tableColumn.setText(columnNames[i]);
            tableColumn.setWidth(columnWidths[i]);
            tableColumn.setResizable(true);
            ExtraPkgTableViewerAdapter adapter = new ExtraPkgTableViewerAdapter(this.rootstrapTableViewer);
            tableColumn.addSelectionListener((SelectionListener)adapter);
            ++i;
        }
        this.rootstrapTableViewer.setLabelProvider((IBaseLabelProvider)new ExtraPkgTableViewerProvider());
        this.rootstrapTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.rootstrapTableViewer.setInput((Object)RootstrapProxy.getProxy().getRootstraps());
        ExtraPkgTableHoverListener hoverListener = new ExtraPkgTableHoverListener(this.getShell(), this.rootstrapTableViewer);
        table.addListener(12, (Listener)hoverListener);
        table.addListener(1, (Listener)hoverListener);
        table.addListener(5, (Listener)hoverListener);
        table.addListener(32, (Listener)hoverListener);
    }

    private void createRootstrapTableButtonComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(2));
        Button addBt = new Button(composite, 8);
        Image addIcon = ImageUtil.getImage((String)"org.tizen.nativeplatform", (String)"icons/rootstrap/add.gif");
        addBt.setImage(addIcon);
        addBt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                FileDialog fd = new FileDialog(PlatformPackagesTab.this.getShell(), 4098);
                fd.setText(PlatformPackagesTab.this.resources.getString("File.Dialog.Title.File"));
                String[] filterExt = new String[]{"*.rpm"};
                fd.setFilterExtensions(filterExt);
                PlatformPackagesTab.this.selectedFileList = fd.open();
                if (PlatformPackagesTab.this.selectedFileList != null) {
                    String[] files = fd.getFileNames();
                    String path = fd.getFilterPath();
                    String[] stringArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String f = stringArray[n2];
                        String filePath = new Path(path).append(f).toOSString();
                        IPkgModelMaker maker = CommonPackageUtil.getModelMaker();
                        IPackage p = maker.makeModel(filePath);
                        if (!PlatformPackagesTab.this.existsPkg(p, PlatformPackagesTab.this.rootstrapPackages)) {
                            PlatformPackagesTab.this.rootstrapPackages.add(p);
                        }
                        ++n2;
                    }
                    PlatformPackagesTab.this.rootstrapTableViewer.refresh();
                    if (PlatformPackagesTab.this.rootstrapPackages.size() > 0) {
                        PlatformPackagesTab.this.rootstrapRemoveBt.setEnabled(true);
                    }
                    PlatformPackagesTab.this.updateLaunchConfigurationDialog();
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.rootstrapRemoveBt = new Button(composite, 8);
        Image removeIcon = ImageUtil.getImage((String)"org.tizen.nativeplatform", (String)"icons/rootstrap/remove.gif");
        this.rootstrapRemoveBt.setImage(removeIcon);
        if (this.rootstrapPackages.size() > 0) {
            this.rootstrapRemoveBt.setEnabled(true);
        }
        this.rootstrapRemoveBt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                TableItem[] items;
                TableItem[] tableItemArray = items = PlatformPackagesTab.this.rootstrapTableViewer.getTable().getSelection();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    Object data = item.getData();
                    if (data instanceof IPackage) {
                        IPackage pkg = (IPackage)data;
                        if (PlatformPackagesTab.this.rootstrapPackages.contains(pkg)) {
                            PlatformPackagesTab.this.rootstrapPackages.remove(pkg);
                            PlatformPackagesTab.this.rootstrapTableViewer.refresh();
                            if (PlatformPackagesTab.this.rootstrapPackages.size() <= 0) {
                                PlatformPackagesTab.this.rootstrapRemoveBt.setEnabled(false);
                            }
                            PlatformPackagesTab.this.updateLaunchConfigurationDialog();
                        }
                    }
                    ++n2;
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    private void createDeviceTableGroup(Composite parent, int heightHint) {
        Composite composite = new Composite(parent, 0);
        GridLayout projLayout = new GridLayout();
        projLayout.numColumns = 1;
        projLayout.marginHeight = 0;
        projLayout.marginWidth = 0;
        GridData gd = new GridData(768);
        composite.setLayout((Layout)projLayout);
        composite.setLayoutData((Object)gd);
        this.createDeviceTableGroupComposite(composite, heightHint);
    }

    private void createRootstrapTableGroup(Composite parent, int heightHint) {
        Composite composite = new Composite(parent, 0);
        GridLayout projLayout = new GridLayout();
        projLayout.numColumns = 1;
        projLayout.marginHeight = 0;
        projLayout.marginWidth = 0;
        GridData gd = new GridData(768);
        composite.setLayout((Layout)projLayout);
        composite.setLayoutData((Object)gd);
        this.createRootstrapTableGroupComposite(composite, heightHint);
    }

    private boolean existsPkg(IPackage pkg, List<IPackage> list) {
        for (IPackage p : list) {
            if (!pkg.getPath().equals(p.getPath())) continue;
            return true;
        }
        return false;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.updatePackageTableFromConfig(configuration);
        this.updateReinstallOpFromConfig(configuration);
    }

    public boolean isValid(ILaunchConfiguration config) {
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        boolean reinstallOp = this.fReinstallOp.getSelection();
        HashMap<String, String> devicePkgs = new HashMap<String, String>();
        for (IPackage p : this.devicePackages) {
            devicePkgs.put(p.getPath(), p.getTool());
        }
        config.setAttribute("org.tizen.platform.launch.DEVICE_PACKAGE_LIST_ATTR", devicePkgs);
        if (this.isDebug) {
            HashMap rootstrapPkgs = new HashMap();
            for (IPackage p : this.rootstrapPackages) {
                devicePkgs.put(p.getPath(), p.getTool());
            }
            config.setAttribute("org.tizen.platform.launch.ROOTSTRAP_PACKAGE_LIST_ATTR", rootstrapPkgs);
        }
        config.setAttribute("org.tizen.platform.launch.REINSTALL_OP_ATTR", reinstallOp);
    }

    private void updateDevicePackageFromConfig(ILaunchConfiguration config) throws CoreException {
        Map devicePkgs = config.getAttribute("org.tizen.platform.launch.DEVICE_PACKAGE_LIST_ATTR", new HashMap());
        this.devicePackages.clear();
        this.deviceTableViewer.getTable().clearAll();
        if (devicePkgs.isEmpty()) {
            this.deviceTableViewer.setInput(this.devicePackages);
            this.setErrorMessage("Failed to get packages. Build a project first");
        } else {
            IPkgModelMaker maker = CommonPackageUtil.getModelMaker();
            Set pathSet = devicePkgs.keySet();
            List packages = maker.makeModels(pathSet);
            for (IPackage pkg : packages) {
                String path = pkg.getPath();
                String tool = (String)devicePkgs.get(path);
                pkg.setTool(tool);
            }
            this.devicePackages.addAll(packages);
            this.deviceTableViewer.setInput(this.devicePackages);
            this.setErrorMessage(null);
        }
    }

    private void updateRootstrapPackageFromConfig(ILaunchConfiguration config) throws CoreException {
        Map rootstrapPkgs = config.getAttribute("org.tizen.platform.launch.ROOTSTRAP_PACKAGE_LIST_ATTR", new HashMap());
        this.rootstrapPackages.clear();
        this.rootstrapTableViewer.getTable().clearAll();
        if (rootstrapPkgs.isEmpty()) {
            this.setErrorMessage("Failed to get packages. Build a project first");
        } else {
            IPkgModelMaker maker = CommonPackageUtil.getModelMaker();
            Set pathSet = rootstrapPkgs.keySet();
            List packages = maker.makeModels(pathSet);
            for (IPackage pkg : packages) {
                String path = pkg.getPath();
                String tool = (String)rootstrapPkgs.get(path);
                pkg.setTool(tool);
            }
            this.rootstrapPackages.addAll(packages);
            this.rootstrapTableViewer.setInput(this.rootstrapPackages);
            this.setErrorMessage(null);
        }
    }

    protected void updatePackageTableFromConfig(ILaunchConfiguration config) {
        try {
            this.updateDevicePackageFromConfig(config);
            if (this.isDebug) {
                this.updateRootstrapPackageFromConfig(config);
            }
        }
        catch (CoreException ce) {
            LaunchUIPlugin.log((Throwable)ce);
        }
    }
}

