/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.rootstrap.util;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.tizen.nativeplatform.model.Architecture;
import org.tizen.nativeplatform.rootstrap.util.SnapshotBuildTarget;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SnapshotBuildXMLParser2 {
    private static final String TAG_BUILD = "build";
    private static final String TAG_ARCHS = "archs";
    private static final String TAG_ARCH = "arch";
    private static final String TAG_REPOS = "repos";
    private static final String TAG_REPO = "repo";
    private static final String PKG_REPO_FORMAT = "%srepos/%s/%s/packages";
    private static final String DEBUG_REPO_FORMAT = "%srepos/%s/%s/debug";

    public static List<Architecture> parse(URL url, InputStream in) {
        DocumentBuilderFactory factory = null;
        DocumentBuilder builder = null;
        Document doc = null;
        try {
            factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
        try {
            doc = builder.parse(new InputSource(in));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        List<SnapshotBuildTarget> targetList = SnapshotBuildXMLParser2.parseBuildTargets(doc, url);
        return SnapshotBuildXMLParser2.convertToArchitectureList(url, targetList);
    }

    private static List<SnapshotBuildTarget> parseBuildTargets(Document doc, URL url) {
        doc.getDocumentElement().normalize();
        NodeList targetNodes = doc.getElementsByTagName(TAG_BUILD);
        ArrayList<SnapshotBuildTarget> targetList = new ArrayList<SnapshotBuildTarget>();
        int i = 0;
        while (i < targetNodes.getLength()) {
            String buildTargetName = "";
            ArrayList<String> archs = new ArrayList<String>();
            ArrayList<String> repos = new ArrayList<String>();
            Node targetNode = targetNodes.item(i);
            NodeList childNodes = targetNode.getChildNodes();
            int j = 0;
            while (j < childNodes.getLength()) {
                Node childNode = childNodes.item(j);
                if (childNode != null) {
                    if (childNode.getNodeName().equals(TAG_ARCHS)) {
                        archs.addAll(SnapshotBuildXMLParser2.getArchs(childNode));
                    } else if (childNode.getNodeName().equals(TAG_REPOS)) {
                        repos.addAll(SnapshotBuildXMLParser2.getRepos(childNode));
                    }
                }
                ++j;
            }
            SnapshotBuildTarget target = new SnapshotBuildTarget(buildTargetName, archs, repos);
            targetList.add(target);
            ++i;
        }
        return targetList;
    }

    private static List<String> getArchs(Node node) {
        ArrayList<String> archs = new ArrayList<String>();
        NodeList archNodes = node.getChildNodes();
        int i = 0;
        while (i < archNodes.getLength()) {
            Node archChildNode = archNodes.item(i);
            if (archChildNode.getNodeName().equals(TAG_ARCH)) {
                String arch = archChildNode.getFirstChild().getNodeValue();
                archs.add(arch);
            }
            ++i;
        }
        return archs;
    }

    private static List<String> getRepos(Node node) {
        ArrayList<String> repos = new ArrayList<String>();
        NodeList archNodes = node.getChildNodes();
        int i = 0;
        while (i < archNodes.getLength()) {
            Node archChildNode = archNodes.item(i);
            if (archChildNode.getNodeName().equals(TAG_REPO)) {
                String repo = archChildNode.getFirstChild().getNodeValue();
                repos.add(repo);
            }
            ++i;
        }
        return repos;
    }

    private static List<Architecture> convertToArchitectureList(URL url, List<SnapshotBuildTarget> targetList) {
        ArrayList<Architecture> archs = new ArrayList<Architecture>();
        for (SnapshotBuildTarget target : targetList) {
            for (String archStr : target.getArchs()) {
                ArrayList<String> repoFullPath = new ArrayList<String>();
                for (String repo : target.getRepos()) {
                    String pkgRepoPath = String.format(PKG_REPO_FORMAT, url.toString(), repo, archStr);
                    String debugRepoPath = String.format(DEBUG_REPO_FORMAT, url.toString(), repo, archStr);
                    repoFullPath.add(pkgRepoPath);
                    repoFullPath.add(debugRepoPath);
                }
                Architecture newArch = new Architecture(archStr, repoFullPath);
                archs.add(newArch);
            }
        }
        return archs;
    }
}

