/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.rootstrap.view.ui;

import java.util.ResourceBundle;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tizen.nativeplatform.model.PlatformRootstrap;

public class RootstrapChangeConfFileDialog
extends Dialog {
    private IPath buildConfFile = null;
    private IPath initialConfFile = null;
    private boolean initialChecked = false;
    private Shell shell;
    private Text confFilePathText;
    private Button confFileBt;
    private Button searchBt;
    private int x = 0;
    private int y = 0;
    private int width = 600;
    private int height = 180;
    private final String BUNDLE_NAME = String.valueOf(RootstrapChangeConfFileDialog.class.getPackage().getName()) + ".RootstrapUIMessages";
    private ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);

    public RootstrapChangeConfFileDialog(Shell parentShell, PlatformRootstrap rootstrap) {
        super(parentShell);
        this.shell = parentShell;
        this.initialConfFile = rootstrap.getConfFile();
        this.initialChecked = this.initialConfFile != null;
        Rectangle bounds = parentShell.getBounds();
        this.x = bounds.x + (bounds.width - this.width) / 2;
        this.y = bounds.y + (bounds.height - this.height) / 2;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.resources.getString("ChangeConfFileDlg.Title"));
        newShell.setLocation(this.x, this.y);
        newShell.setSize(this.width, this.height);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(770));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createConfFilePathComposite(composite);
        return null;
    }

    private void createConfFilePathComposite(Composite parent) {
        Composite snapshotComp = new Composite(parent, 0);
        snapshotComp.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(1808);
        snapshotComp.setLayoutData((Object)gridData);
        this.confFileBt = new Button(snapshotComp, 32);
        gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        this.confFileBt.setLayoutData((Object)gridData);
        this.confFileBt.setText(this.resources.getString("MofifyRootDlg.Button.ConfFile.Check"));
        this.confFileBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                if (button.getSelection()) {
                    RootstrapChangeConfFileDialog.this.confFilePathText.setEnabled(true);
                    RootstrapChangeConfFileDialog.this.searchBt.setEnabled(true);
                } else {
                    RootstrapChangeConfFileDialog.this.confFilePathText.setEnabled(false);
                    RootstrapChangeConfFileDialog.this.searchBt.setEnabled(false);
                }
            }
        });
        this.confFilePathText = new Text(snapshotComp, 2052);
        gridData = new GridData(768);
        gridData.minimumHeight = 0;
        this.confFilePathText.setLayoutData((Object)gridData);
        this.searchBt = new Button(snapshotComp, 8);
        this.searchBt.setText(this.resources.getString("LocalRepoTab.Button.Browse"));
        this.searchBt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                FileDialog fd = new FileDialog(RootstrapChangeConfFileDialog.this.shell, 4096);
                fd.setText(RootstrapChangeConfFileDialog.this.resources.getString("LocalRepoTab.ConfFileDlg.Title"));
                String[] filterExt = new String[]{RootstrapChangeConfFileDialog.this.resources.getString("LocalRepoTab.ConfFileDlg.Filter.Ext")};
                fd.setFilterExtensions(filterExt);
                String filePath = fd.open();
                if (filePath == null) {
                    return;
                }
                RootstrapChangeConfFileDialog.this.buildConfFile = (IPath)new Path(filePath);
                String confFile = RootstrapChangeConfFileDialog.this.buildConfFile.toOSString().trim();
                RootstrapChangeConfFileDialog.this.confFilePathText.setText(confFile);
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.confFileBt.setSelection(this.initialChecked);
        if (this.initialChecked) {
            this.confFilePathText.setText(this.initialConfFile.toOSString());
        } else {
            this.confFilePathText.setEnabled(false);
            this.searchBt.setEnabled(false);
        }
    }

    public IPath getBuildConfFile() {
        return this.buildConfFile;
    }

    protected void okPressed() {
        if (!this.confFileBt.getSelection()) {
            this.buildConfFile = null;
        }
        super.okPressed();
    }
}

