/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.delegate;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.eclipse.cdt.debug.mi.core.MIInferior;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.MIProcessAdapter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.tizen.nativecommon.build.ProjectTypeManager;
import org.tizen.nativeplatform.PlatformConfigurationManager;
import org.tizen.nativeplatform.PlatformInstances;
import org.tizen.nativeplatform.launcher.command.provider.IDebugCommandProvider;
import org.tizen.nativeplatform.launcher.delegate.LaunchCommandProviderFactory;

public class PlatformMIProcessAdapter
extends MIProcessAdapter {
    private static final int ONE_SECOND = 1000;
    private Process gdbProcess;
    InputStream gdbInputStream;

    public PlatformMIProcessAdapter(String[] args, int launchTimeout, IProgressMonitor monitor) throws IOException {
        super(args, launchTimeout, monitor);
    }

    public PlatformMIProcessAdapter(String[] args, IProgressMonitor monitor) throws IOException {
        super(args, monitor);
    }

    public boolean canInterrupt(MIInferior inferior) {
        return true;
    }

    public void interrupt(MIInferior inferior) {
        if (this.gdbProcess instanceof Process) {
            String interruptCmd = PlatformInstances.getScriptProvider().genDebugginInterruptScript(this.gdbProcess);
            try {
                Process shellProcess = PlatformInstances.getBuildCommandUtil().createProcess(interruptCmd, null, null, false);
                shellProcess.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                super.interrupt(inferior);
                return;
            }
            inferior.setSuspended();
            this.waitForInterrupt(inferior);
            PlatformInstances.getScriptProvider().cleanUpScript(interruptCmd);
        }
    }

    public InputStream getInputStream() {
        return this.gdbInputStream;
    }

    private IProject getProjectName(String[] args) {
        String projectPathString = "";
        int i = 0;
        while (i < args.length) {
            if (args[i].contains("--cd")) {
                projectPathString = args[i];
                break;
            }
            ++i;
        }
        if (!projectPathString.isEmpty()) {
            String[] pathTokens = projectPathString.split("=");
            projectPathString = pathTokens[pathTokens.length - 1];
            Path projectPath = new Path(projectPathString);
            String projectName = projectPath.lastSegment();
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            return project;
        }
        return null;
    }

    protected Process getGDBProcess(String[] args, int launchTimeout, IProgressMonitor monitor) throws IOException {
        IProject project = this.getProjectName(args);
        if (project == null) {
            return null;
        }
        ProjectTypeManager.getProjectBuilderInstance((IProject)project);
        String[] newArgs = new String[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, args.length - 1);
        IDebugCommandProvider provider = LaunchCommandProviderFactory.getDebugProvider();
        if (provider != null) {
            this.gdbProcess = provider.debug(PlatformConfigurationManager.getDefaultConfiguration((IProject)project), newArgs);
        }
        final Process pgdb = this.gdbProcess;
        Thread syncStartup = new Thread("GDB Start"){

            @Override
            public void run() {
                try {
                    PushbackInputStream pb = new PushbackInputStream(pgdb.getInputStream());
                    PlatformMIProcessAdapter.this.gdbInputStream = pb;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        syncStartup.start();
        int timepass = 0;
        if (launchTimeout <= 0) {
            launchTimeout = Integer.MAX_VALUE;
        }
        timepass = 0;
        while (timepass < launchTimeout) {
            if (!syncStartup.isAlive() || monitor.isCanceled()) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            timepass += 1000;
        }
        try {
            syncStartup.interrupt();
            syncStartup.join(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (monitor.isCanceled()) {
            this.gdbProcess.destroy();
            throw new OperationCanceledException();
        }
        if (timepass >= launchTimeout) {
            this.gdbProcess.destroy();
            String message = MIPlugin.getResourceString((String)"src.GDBDebugger.Error_launch_timeout");
            throw new IOException(message);
        }
        return this.gdbProcess;
    }
}

