/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.util.FileUtil;
import org.tizen.nativeplatform.RootstrapProxy;
import org.tizen.nativeplatform.launcher.coredump.model.CoredumpModel;
import org.tizen.nativeplatform.launcher.ui.PlatformCommonTab;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.util.PlatformFileUtil;
import org.tizen.nativeplatform.util.PlatformLaunchUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.service.FileEntry;

public class PlatformMainCoreTab
extends PlatformCommonTab {
    private final String BUNDLE_NAME = String.valueOf(PlatformMainCoreTab.class.getPackage().getName()) + ".LaunchTabUIMessages";
    private ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);
    private String DEBUG_COREARCHIVE_PATH = "/opt/usr/share/crash/dump";
    private String DEBUG_CSFILE_PATH = "/opt/usr/share/crash/report";
    private String DEBUG_COREFILE_PATH = "/opt/usr/share/crash/core";
    private Text coredumpText;
    private Text corefileText;
    private Text csfileText;
    private Text execText;
    private Combo rootstrapCombo;
    private Button csRemoteBrowseButton;
    private Button coreRemoteBrowseButton;
    private Button csLocalBrowseButton;
    private Button coreLocalBrowseButton;
    private Button archiveRemoteBrowseButton;
    private Button archiveLocalBrowseButton;
    private IDevice device;
    private boolean connectedDevice = false;
    private FileEntry originCoredumpFileEntry;
    private FileEntry originCsFileEntry;
    private String originCoredumpPath = "";
    private String originCsPath = "";
    private String programPath = "";
    private List<PlatformRootstrap> rootstraps = new ArrayList<PlatformRootstrap>();
    private String coredumpLocation;
    protected final Logger logger = LoggerFactory.getLogger(PlatformMainCoreTab.class);

    public PlatformMainCoreTab() {
        this.device = ConnectionPlugin.getDefault().getCurrentDevice();
        if (this.device != null) {
            this.connectedDevice = true;
        }
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        this.createVerticalSpacer(comp, 1);
        this.createCoredumpArchiveGroup(comp, 1);
        this.createCorefileGroup(comp, 1);
        this.createExecGroup(comp, 1);
        this.createRootstrapGroup(comp, 1);
    }

    private void createCoredumpArchiveGroup(Composite parent, int colSpan) {
        Composite coredumpComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        coredumpComp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        coredumpComp.setLayoutData((Object)gd);
        Label coredumpLabel = new Label(coredumpComp, 0);
        coredumpLabel.setText(this.resources.getString("Label.Coredump.Path"));
        Composite buttonComp = new Composite(coredumpComp, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComp.setLayout((Layout)layout);
        gd = new GridData(128);
        gd.horizontalSpan = 2;
        buttonComp.setLayoutData((Object)gd);
        this.archiveRemoteBrowseButton = this.createPushButton(buttonComp, this.resources.getString("Button.Browse"), null);
        this.archiveRemoteBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                PlatformMainCoreTab.this.originCoredumpFileEntry = PlatformMainCoreTab.this.handleRemoteBrowseButtonSelected(PlatformMainCoreTab.this.DEBUG_COREARCHIVE_PATH);
                if (PlatformMainCoreTab.this.originCoredumpFileEntry != null && PlatformMainCoreTab.this.originCoredumpFileEntry.getDate() != null) {
                    PlatformMainCoreTab.this.originCoredumpPath = PlatformMainCoreTab.this.originCoredumpFileEntry.getFullPath();
                    PlatformMainCoreTab.this.coredumpText.setText(PlatformMainCoreTab.this.originCoredumpPath);
                    PlatformMainCoreTab.this.coredumpLocation = CoredumpModel.LOCATION.REMOTE.toString();
                    PlatformMainCoreTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.archiveLocalBrowseButton = this.createPushButton(buttonComp, this.resources.getString("Button.Local.Browse"), null);
        this.archiveLocalBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                FileDialog fd = new FileDialog(PlatformMainCoreTab.this.getAvailableShell(), 4100);
                fd.setText(PlatformMainCoreTab.this.resources.getString("CorePage.Browse.Title"));
                String[] filterExt = new String[]{"*.tar.gz"};
                fd.setFilterExtensions(filterExt);
                String selected = fd.open();
                if (selected != null) {
                    PlatformMainCoreTab.this.originCoredumpPath = selected;
                    PlatformMainCoreTab.this.coredumpText.setText(PlatformMainCoreTab.this.originCoredumpPath);
                    PlatformMainCoreTab.this.coredumpLocation = CoredumpModel.LOCATION.LOCAL.toString();
                }
            }
        });
        this.coredumpText = new Text(coredumpComp, 2060);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.coredumpText.setLayoutData((Object)gd);
        this.coredumpText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                PlatformMainCoreTab.this.fPreviouslyCheckedProgram = null;
                PlatformMainCoreTab.this.updateBuildConfigCombo("");
                PlatformMainCoreTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createCorefileGroup(Composite parent, int colSpan) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        Label corefileLabel = new Label(composite, 0);
        corefileLabel.setText("File(.core):");
        this.corefileText = new Text(composite, 2060);
        this.corefileText.setLayoutData((Object)gd);
        this.coreRemoteBrowseButton = this.createPushButton(composite, this.resources.getString("Button.Browse"), null);
        this.coreRemoteBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                PlatformMainCoreTab.this.originCoredumpFileEntry = PlatformMainCoreTab.this.handleRemoteBrowseButtonSelected(PlatformMainCoreTab.this.DEBUG_COREFILE_PATH);
                if (PlatformMainCoreTab.this.originCoredumpFileEntry != null && PlatformMainCoreTab.this.originCoredumpFileEntry.getDate() != null) {
                    PlatformMainCoreTab.this.originCoredumpPath = PlatformMainCoreTab.this.originCoredumpFileEntry.getFullPath();
                    PlatformMainCoreTab.this.corefileText.setText(PlatformMainCoreTab.this.originCoredumpPath);
                    PlatformMainCoreTab.this.coredumpLocation = CoredumpModel.LOCATION.REMOTE.toString();
                    PlatformMainCoreTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.coreLocalBrowseButton = this.createPushButton(composite, this.resources.getString("Button.Local.Browse"), null);
        this.coreLocalBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                FileDialog fd = new FileDialog(PlatformMainCoreTab.this.getAvailableShell(), 4100);
                fd.setText(PlatformMainCoreTab.this.resources.getString("CorePage.Browse.Title"));
                String[] filterExt = new String[]{"*.core"};
                fd.setFilterExtensions(filterExt);
                String selected = fd.open();
                if (selected != null) {
                    PlatformMainCoreTab.this.originCoredumpPath = selected;
                    PlatformMainCoreTab.this.corefileText.setText(PlatformMainCoreTab.this.originCoredumpPath);
                    PlatformMainCoreTab.this.coredumpLocation = CoredumpModel.LOCATION.LOCAL.toString();
                    PlatformMainCoreTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        Label csfileLabel = new Label(composite, 0);
        csfileLabel.setText("File(.cs):");
        this.csfileText = new Text(composite, 2060);
        this.csfileText.setLayoutData((Object)gd);
        this.csRemoteBrowseButton = this.createPushButton(composite, this.resources.getString("Button.Browse"), null);
        this.csRemoteBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                PlatformMainCoreTab.this.originCsFileEntry = PlatformMainCoreTab.this.handleRemoteBrowseButtonSelected(PlatformMainCoreTab.this.DEBUG_CSFILE_PATH);
                if (PlatformMainCoreTab.this.originCsFileEntry != null && PlatformMainCoreTab.this.originCsFileEntry.getDate() != null) {
                    PlatformMainCoreTab.this.originCsPath = PlatformMainCoreTab.this.originCsFileEntry.getFullPath();
                    PlatformMainCoreTab.this.csfileText.setText(PlatformMainCoreTab.this.originCsPath);
                    PlatformMainCoreTab.this.coredumpLocation = CoredumpModel.LOCATION.REMOTE.toString();
                    PlatformMainCoreTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.csLocalBrowseButton = this.createPushButton(composite, this.resources.getString("Button.Local.Browse"), null);
        this.csLocalBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                FileDialog fd = new FileDialog(PlatformMainCoreTab.this.getAvailableShell(), 4100);
                fd.setText(PlatformMainCoreTab.this.resources.getString("CorePage.Browse.Title"));
                String[] filterExt = new String[]{"*.cs"};
                fd.setFilterExtensions(filterExt);
                String selected = fd.open();
                if (selected != null) {
                    PlatformMainCoreTab.this.originCsPath = selected;
                    PlatformMainCoreTab.this.csfileText.setText(PlatformMainCoreTab.this.originCsPath);
                    PlatformMainCoreTab.this.coredumpLocation = CoredumpModel.LOCATION.LOCAL.toString();
                    PlatformMainCoreTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
    }

    private void createExecGroup(Composite parent, int colSpan) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        Label execLabel = new Label(composite, 0);
        execLabel.setText("Program path:");
        this.execText = new Text(composite, 2052);
        this.execText.setLayoutData((Object)gd);
        this.execText.setLayoutData((Object)gd);
    }

    private void enableArchiveGroup(boolean enable) {
        if (!enable) {
            this.coredumpText.setText("");
        }
        this.coredumpText.setEnabled(enable);
        this.archiveRemoteBrowseButton.setEnabled(enable && this.connectedDevice);
        this.archiveLocalBrowseButton.setEnabled(enable);
    }

    private void enableCorefileGroup(boolean enable) {
        if (!enable) {
            this.csfileText.setText("");
            this.corefileText.setText("");
        }
        this.csfileText.setEnabled(enable);
        this.corefileText.setEnabled(enable);
        this.csRemoteBrowseButton.setEnabled(enable && this.connectedDevice);
        this.coreRemoteBrowseButton.setEnabled(enable && this.connectedDevice);
        this.csLocalBrowseButton.setEnabled(enable);
        this.coreLocalBrowseButton.setEnabled(enable);
    }

    private void createRootstrapGroup(Composite parent, int colSpan) {
        Composite rootstrapComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        rootstrapComp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        rootstrapComp.setLayoutData((Object)gd);
        Label rootstrapLabel = new Label(rootstrapComp, 0);
        rootstrapLabel.setText(this.resources.getString("Label.Rootstrap.Name"));
        GridData gridData = new GridData(768);
        this.rootstrapCombo = new Combo(rootstrapComp, 8);
        this.rootstrapCombo.setLayoutData((Object)gridData);
        this.rootstrapCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PlatformMainCoreTab.this.fPreviouslyCheckedProgram = null;
                PlatformMainCoreTab.this.updateBuildConfigCombo("");
                PlatformMainCoreTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setErrorMessage(null);
        this.updateCoredumpFromConfig(configuration);
        this.updateProgramPathFromConfig(configuration);
        this.updateRootstrapFromConfig(configuration);
    }

    public boolean isValid(ILaunchConfiguration config) {
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        String coreLocation = this.coredumpLocation.toString();
        String rootstrapName = this.rootstrapCombo.getText();
        String exec = this.execText.getText();
        config.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", exec);
        config.setAttribute("org.tizen.platform.launch.ORIGIN_COREFILE_ATTR", this.originCoredumpPath);
        config.setAttribute("org.tizen.platform.launch.ORIGIN_CSFILE_ATTR", this.originCsPath);
        config.setAttribute("org.tizen.platform.launch.COREFILE_LOC_ATTR", coreLocation);
        config.setAttribute("org.tizen.platform.launch.ROOTSTRAP_ATTR", rootstrapName);
    }

    protected void updateRootstrapFromConfig(ILaunchConfiguration config) {
        String rootstrapName = "";
        try {
            rootstrapName = config.getAttribute("org.tizen.platform.launch.ROOTSTRAP_ATTR", "");
        }
        catch (CoreException ce) {
            LaunchUIPlugin.log((Throwable)ce);
        }
        ArrayList<String> rootstrapList = new ArrayList<String>();
        this.rootstraps = RootstrapProxy.getProxy().getRootstraps();
        for (PlatformRootstrap r : this.rootstraps) {
            rootstrapList.add(r.getName());
        }
        this.rootstrapCombo.setItems(rootstrapList.toArray(new String[0]));
        int idx = this.rootstrapCombo.indexOf(rootstrapName);
        if (rootstrapName.isEmpty()) {
            this.rootstrapCombo.select(0);
            this.setErrorMessages("Rootstrap is null. Set default rootstrap.");
        } else if (idx < 0) {
            this.rootstrapCombo.select(0);
            this.setErrorMessages(String.format("\"%s\" rootstrap does not exist. Set default rootstrap", rootstrapName));
        } else {
            this.rootstrapCombo.select(idx);
        }
    }

    protected void updateCoredumpFromConfig(ILaunchConfiguration config) {
        this.originCoredumpPath = "";
        this.originCsPath = "";
        this.coredumpLocation = "";
        try {
            this.originCoredumpPath = config.getAttribute("org.tizen.platform.launch.ORIGIN_COREFILE_ATTR", "");
            this.originCsPath = config.getAttribute("org.tizen.platform.launch.ORIGIN_CSFILE_ATTR", "");
            this.coredumpLocation = config.getAttribute("org.tizen.platform.launch.COREFILE_LOC_ATTR", "");
        }
        catch (CoreException ce) {
            LaunchUIPlugin.log((Throwable)ce);
        }
        if (this.originCsPath.isEmpty()) {
            this.enableArchiveGroup(true);
            this.enableCorefileGroup(false);
            this.coredumpText.setText(this.originCoredumpPath);
            if (this.originCoredumpPath.isEmpty()) {
                this.setErrorMessages("Please set coredump archive");
                return;
            }
            String fileName = FileUtil.getFileNameFromPath((String)this.originCoredumpPath);
            if (CoredumpModel.LOCATION.REMOTE.toString().equals(this.coredumpLocation)) {
                FileEntry entry;
                if (this.device != null && ((entry = this.device.getFileEntry(this.originCoredumpPath)) == null || entry.getDate() == null)) {
                    this.setErrorMessages(String.format("\"%s\" device does not have coredump file (%s)", this.device.getDeviceName(), fileName));
                }
            } else if (CoredumpModel.LOCATION.LOCAL.toString().equals(this.coredumpLocation) && !PlatformFileUtil.existsFile((String)this.originCoredumpPath)) {
                this.setErrorMessages(String.format("The coredump file does not exist on local (%s)", fileName));
            }
        } else {
            this.enableArchiveGroup(false);
            this.enableCorefileGroup(true);
            this.corefileText.setText(this.originCoredumpPath);
            this.csfileText.setText(this.originCsPath);
            if (this.originCoredumpPath.isEmpty() || this.originCsPath.isEmpty()) {
                this.setErrorMessages("Please set coredump file and cs file");
                return;
            }
            String corefileName = FileUtil.getFileNameFromPath((String)this.originCoredumpPath);
            String csfileName = FileUtil.getFileNameFromPath((String)this.originCsPath);
            if (CoredumpModel.LOCATION.REMOTE.toString().equals(this.coredumpLocation) && this.device != null) {
                FileEntry entry = this.device.getFileEntry(this.originCoredumpPath);
                if (entry == null || entry.getDate() == null) {
                    this.setErrorMessages(String.format("\"%s\" device does not have coredump file (%s)", this.device.getDeviceName(), corefileName));
                    return;
                }
                entry = this.device.getFileEntry(this.originCsPath);
                if (entry == null || entry.getDate() == null) {
                    this.setErrorMessages(String.format("\"%s\" device does not have cs file (%s)", this.device.getDeviceName(), csfileName));
                    return;
                }
            }
        }
    }

    protected void updateProgramPathFromConfig(ILaunchConfiguration config) {
        this.programPath = "";
        try {
            this.programPath = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
        }
        catch (CoreException ce) {
            LaunchUIPlugin.log((Throwable)ce);
        }
        if (this.programPath.isEmpty()) {
            this.setErrorMessages("Please set executable file");
            return;
        }
        this.execText.setText(this.programPath);
    }

    private void setErrorMessages(String message) {
        String errorMessage = "";
        String prevErrorMessage = this.getErrorMessage();
        errorMessage = prevErrorMessage != null ? String.valueOf(prevErrorMessage) + "\n" + message : message;
        this.setErrorMessage(errorMessage);
    }

    @Override
    protected FileEntry handleRemoteBrowseButtonSelected(String defaultPath) {
        Shell shell = this.getAvailableShell();
        FileEntry path = PlatformLaunchUtil.selectRemoteFile((Shell)shell, (String)this.resources.getString("CorePage.Browse.Title"), (String)defaultPath);
        return path;
    }
}

