/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.linux.rootstrap.core;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativeplatform.PlatformInstances;
import org.tizen.nativeplatform.command.launcher.HostCommandLauncher;
import org.tizen.nativeplatform.model.PlatformRootstrap;

public class RootstrapExporter {
    public static boolean exportRootstrap(PlatformRootstrap rootstrap, String exportFilePath, IProgressMonitor monitor) throws InterruptedException {
        String tempDirPath;
        block12: {
            String pluginFileName;
            block11: {
                block10: {
                    String rootstrapID;
                    String scratchName;
                    String workingPath;
                    block9: {
                        block8: {
                            String chrootPath;
                            block7: {
                                tempDirPath = PlatformInstances.getBuildCommandUtil().makeTempDirectory();
                                try {
                                    Path rPath = new Path(rootstrap.getPath());
                                    String rootstrapPath = rPath.toOSString();
                                    workingPath = rPath.removeLastSegments(1).toOSString();
                                    SmartBuildInterface sbi = SmartBuildInterface.getInstance();
                                    chrootPath = sbi.getPlatformRootstrapPath(rootstrapPath);
                                    if (chrootPath != null && !chrootPath.isEmpty()) break block7;
                                }
                                catch (Throwable throwable) {
                                    HostCommandLauncher.executeSudo((String)String.format("sudo -S rm -rf %s", tempDirPath));
                                    throw throwable;
                                }
                                HostCommandLauncher.executeSudo((String)String.format("sudo -S rm -rf %s", tempDirPath));
                                return false;
                            }
                            scratchName = new Path(chrootPath).lastSegment();
                            if (scratchName.startsWith("scratch.")) break block8;
                            HostCommandLauncher.executeSudo((String)String.format("sudo -S rm -rf %s", tempDirPath));
                            return false;
                        }
                        rootstrapID = rootstrap.getId();
                        if (HostCommandLauncher.execute((String)String.format("tar cvzf %s/rootstrap1.tar.gz %s --exclude=local/BUILD-ROOTS/%s", tempDirPath, rootstrapID, scratchName), (String)workingPath, (String)"Platform Internal", (IProgressMonitor)monitor)) break block9;
                        HostCommandLauncher.executeSudo((String)String.format("sudo -S rm -rf %s", tempDirPath));
                        return false;
                    }
                    if (HostCommandLauncher.executeSudo((String)String.format("sudo -S tar cvzf %s/rootstrap2.tar.gz %s/local/BUILD-ROOTS/%s --exclude=home/abuild --exclude=etc/passwd", tempDirPath, rootstrapID, scratchName), (String)workingPath, (String)"Platform Internal", (IProgressMonitor)monitor)) break block10;
                    HostCommandLauncher.executeSudo((String)String.format("sudo -S rm -rf %s", tempDirPath));
                    return false;
                }
                pluginFileName = String.valueOf(rootstrap.getId()) + ".xml";
                String pluginPath = new Path(SmartBuildInterface.getInstance().getPluginPath()).append(pluginFileName).toOSString();
                if (HostCommandLauncher.execute((String)String.format("cp %s %s/", pluginPath, tempDirPath))) break block11;
                HostCommandLauncher.executeSudo((String)String.format("sudo -S rm -rf %s", tempDirPath));
                return false;
            }
            if (HostCommandLauncher.execute((String)String.format("tar cvzf %s rootstrap1.tar.gz rootstrap2.tar.gz %s", exportFilePath, pluginFileName), (String)tempDirPath, (String)"Platform Internal", (IProgressMonitor)monitor)) break block12;
            HostCommandLauncher.executeSudo((String)String.format("sudo -S rm -rf %s", tempDirPath));
            return false;
        }
        HostCommandLauncher.executeSudo((String)String.format("sudo -S rm -rf %s", tempDirPath));
        return true;
    }
}

