/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.pkg.commander;

import org.tizen.nativeplatform.PlatformInstances;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.pkg.commander.IPkgCommander;
import org.tizen.nativeplatform.preferences.PreferencesManager;
import org.tizen.nativeplatform.types.CmdTargetTypes;
import org.tizen.nativeplatform.types.PkgTypes;
import org.tizen.sdblib.IDevice;

public class PkgCommandTarget {
    private IDevice device = null;
    private PlatformRootstrap rootstrap = null;
    private IPkgCommander hsCommander = null;
    private IPkgCommander dvCommander = null;
    private IPkgCommander rtCommander = null;
    private String http_proxy = "";
    private PkgTypes type;

    public PkgCommandTarget(PkgTypes type) {
        this.setPkgType(type);
        this.http_proxy = PreferencesManager.getHttpProxyURL();
    }

    public PkgCommandTarget(PkgTypes type, IDevice device) {
        this.setPkgType(type);
        this.setDevice(device);
        this.http_proxy = PreferencesManager.getHttpProxyURL();
    }

    public PkgCommandTarget(PkgTypes type, PlatformRootstrap rootstrap) {
        this.setPkgType(type);
        this.setRootstrap(rootstrap);
        this.http_proxy = PreferencesManager.getHttpProxyURL();
    }

    public PkgCommandTarget(PkgTypes type, IDevice device, PlatformRootstrap rootstrap) {
        this.setPkgType(type);
        this.setDevice(device);
        this.setRootstrap(rootstrap);
        this.http_proxy = PreferencesManager.getHttpProxyURL();
    }

    public void setPkgType(PkgTypes type) {
        this.type = type;
    }

    public void setDevice(IDevice device) {
        this.device = device;
    }

    public void setRootstrap(PlatformRootstrap rootstrap) {
        this.rootstrap = rootstrap;
    }

    public IDevice getDevice() {
        return this.device;
    }

    public PlatformRootstrap getRootstrap() {
        return this.rootstrap;
    }

    public PkgTypes getPkgType() {
        return this.type;
    }

    public IPkgCommander getCommander(CmdTargetTypes type) {
        return this.getCommander(type, true);
    }

    public IPkgCommander getCommander(CmdTargetTypes type, boolean useConsoleLog) {
        if (type.equals((Object)CmdTargetTypes.HOST)) {
            return this.getHostCommander(useConsoleLog);
        }
        if (type.equals((Object)CmdTargetTypes.DEVICE)) {
            return this.getDeviceCommander(useConsoleLog);
        }
        if (type.equals((Object)CmdTargetTypes.ROOTSTRAP)) {
            return this.getRootstrapCommander(useConsoleLog);
        }
        return null;
    }

    public IPkgCommander getHostCommander(boolean useConsoleLog) {
        if (this.hsCommander == null) {
            this.hsCommander = PlatformInstances.getLaunchCommandUtil().getHostCommander(this.type, useConsoleLog);
        }
        return this.hsCommander;
    }

    public IPkgCommander getHostCommander() {
        return this.getHostCommander(true);
    }

    public IPkgCommander getDeviceCommander(boolean useConsoleLog) {
        if (this.dvCommander == null && this.isSetDevice()) {
            this.dvCommander = PlatformInstances.getLaunchCommandUtil().getDeviceCommander(this.type, this.device, useConsoleLog);
            if (this.dvCommander != null) {
                this.dvCommander.setHttpProxy(this.http_proxy);
            }
        }
        return this.dvCommander;
    }

    public IPkgCommander getDeviceCommander() {
        return this.getDeviceCommander(true);
    }

    public IPkgCommander getRootstrapCommander(boolean useConsoleLog) {
        if (this.rtCommander == null && this.isSetRootstrap()) {
            this.rtCommander = PlatformInstances.getLaunchCommandUtil().getRootstrapCommander(this.type, this.rootstrap, useConsoleLog);
            if (this.rtCommander != null) {
                this.rtCommander.setHttpProxy(this.http_proxy);
            }
        }
        return this.rtCommander;
    }

    public IPkgCommander getRootstrapCommander() {
        return this.getRootstrapCommander(true);
    }

    public boolean isSetDevice() {
        return this.device != null;
    }

    public boolean isSetRootstrap() {
        return this.rootstrap != null;
    }
}

