/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.tizen.nativeplatform.pkg.model.IPackage;

public class PackageStoreManager {
    public static Map<String, List<IPackage>> store = new HashMap<String, List<IPackage>>();

    public static void put(IProject project, IConfiguration config, List<IPackage> pkgs) {
        String key = PackageStoreManager.getKey(project, config);
        if (store.get(key) != null) {
            store.remove(key);
        }
        store.put(key, pkgs);
    }

    public static void clearStore(String projectName) {
        HashSet<String> removableKey = new HashSet<String>();
        for (String key : store.keySet()) {
            if (!key.startsWith(String.valueOf(projectName) + "_")) continue;
            removableKey.add(key);
        }
        for (String key : removableKey) {
            store.remove(key);
        }
    }

    public static void removeStore(IProject project, IConfiguration config) {
        store.remove(PackageStoreManager.getKey(project, config));
    }

    public static List<IPackage> get(IProject project, IConfiguration config) {
        return store.get(PackageStoreManager.getKey(project, config));
    }

    private static String getKey(IProject project, IConfiguration config) {
        String key = String.format("%s_%s", project.getName(), config.getName());
        return key;
    }
}

