/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.project.wizard.ui;

import java.util.ResourceBundle;
import org.eclipse.cdt.core.CCProjectNature;
import org.eclipse.cdt.core.CProjectNature;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.log.UserLogger;
import org.tizen.nativeappcommon.wizards.Messages;
import org.tizen.nativeappcommon.wizards.TizenProjectWizard;
import org.tizen.nativecommon.templateengine.build.AbstractProjectGenerator;
import org.tizen.nativeplatform.PlatformConfigurationManager;
import org.tizen.nativeplatform.PlatformProjectNature;
import org.tizen.nativeplatform.project.wizard.git.model.GitDescription;
import org.tizen.nativeplatform.project.wizard.model.TizenPlatformTemplateModel;
import org.tizen.nativeplatform.project.wizard.ui.TizenPlatformMainWizardPage;

public class TizenPlatformProjectWizard
extends TizenProjectWizard {
    private static final String BUNDLE_NAME = String.valueOf(TizenPlatformProjectWizard.class.getPackage().getName()) + ".WizardUIMessages";
    private static ResourceBundle resources = ResourceBundle.getBundle(BUNDLE_NAME);
    private static final String Title = resources.getString("WizardPage.Title");
    private static final String Description = resources.getString("WizardPage.Description");
    private GitDescription desc = null;
    private IWizardContainer container = null;
    private static final Logger logger = LoggerFactory.getLogger(TizenPlatformProjectWizard.class);

    public TizenPlatformProjectWizard() {
        super(Title, Description);
    }

    public void addPages() {
        this.fMainPage = new TizenPlatformMainWizardPage(resources.getString("WizardPage.Name"), "platform");
        this.fMainPage.setTitle(Title);
        this.fMainPage.setDescription(Description);
        this.addPage((IWizardPage)this.fMainPage);
    }

    public String[] getNatures() {
        return new String[]{"org.tizen.nativeplatform.tizenPlatformNature", "org.eclipse.cdt.core.cnature", "org.eclipse.cdt.core.ccnature"};
    }

    protected IProject continueCreation(IProject prj) {
        if (this.continueCreationMonitor == null) {
            this.continueCreationMonitor = new NullProgressMonitor();
        }
        try {
            try {
                this.continueCreationMonitor.beginTask(Messages.TizenProjectWizard_2, 1);
                CProjectNature.addCNature((IProject)prj, (IProgressMonitor)new SubProgressMonitor(this.continueCreationMonitor, 1));
                CCProjectNature.addCCNature((IProject)prj, (IProgressMonitor)new SubProgressMonitor(this.continueCreationMonitor, 1));
                PlatformProjectNature.addNatureToProject((IProject)prj, (IProgressMonitor)new SubProgressMonitor(this.continueCreationMonitor, 1));
            }
            catch (CoreException e) {
                logger.error("Failed to create project", (Throwable)e);
                this.continueCreationMonitor.done();
            }
        }
        finally {
            this.continueCreationMonitor.done();
        }
        return prj;
    }

    public boolean performFinish() {
        UserLogger.start((String)"clone.git");
        boolean result = false;
        this.nativeTemplate = ((TizenPlatformMainWizardPage)this.fMainPage).getSelectedTemplate();
        ((TizenPlatformMainWizardPage)this.fMainPage).createEntryDescriptor(this.nativeTemplate);
        this.workingSets = this.getMainPage().getSelectedWorkingSets();
        this.container = this.getContainer();
        ResourcesPlugin.getWorkspace().getRoot().getLocation().append(this.fMainPage.getProjectName());
        TizenPlatformTemplateModel selectedTemplate = ((TizenPlatformMainWizardPage)this.fMainPage).getLastSelectedTemplate();
        this.desc = selectedTemplate.getDesc();
        result = super.performFinish();
        return result;
    }

    public boolean postCreateJobProcess(IProgressMonitor monitor) {
        boolean isChecked = true;
        if (this.desc != null) {
            try {
                PlatformProjectNature.addNatureToProject((IProject)this.newProject, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
                isChecked = false;
            }
        }
        if (isChecked) {
            this.setDisableMakefileGenAuto(this.newProject);
            UserLogger.end((String)"clone.git");
        }
        return isChecked;
    }

    private void setDisableMakefileGenAuto(IProject project) {
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration defaultConfig = info.getDefaultConfiguration();
        IConfiguration[] iConfigurationArray = defaultConfig.getManagedProject().getConfigurations();
        int n = iConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration config = iConfigurationArray[n2];
            try {
                config.setManagedBuildOn(false);
            }
            catch (BuildException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public IProject getProject(boolean defaults, boolean onFinish) {
        IProject prj = super.getProject(defaults, onFinish);
        PlatformConfigurationManager.setProjectVersion((IProject)prj, (String)"1.0.0", (boolean)true);
        return prj;
    }

    protected AbstractProjectGenerator getBuildFileGenerator() {
        return null;
    }
}

