/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.rootstrap.util;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.tizen.nativeplatform.model.Architecture;
import org.tizen.nativeplatform.rootstrap.util.SnapshotBuildTarget;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SnapshotBuildXMLParser {
    private static final String TAG_BUILDTARGET = "buildtarget";
    private static final String TAG_ARCHS = "archs";
    private static final String TAG_ARCH = "arch";
    private static final String TAG_REPO = "repo";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TYPE = "type";

    public static List<Architecture> parse(URL url, InputStream in) {
        DocumentBuilderFactory factory = null;
        DocumentBuilder builder = null;
        Document doc = null;
        try {
            factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
        try {
            doc = builder.parse(new InputSource(in));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        List<SnapshotBuildTarget> targetList = SnapshotBuildXMLParser.parseBuildTargets(doc, url);
        return SnapshotBuildXMLParser.convertToArchitectureList(targetList);
    }

    private static List<SnapshotBuildTarget> parseBuildTargets(Document doc, URL url) {
        doc.getDocumentElement().normalize();
        NodeList targetNodes = doc.getElementsByTagName(TAG_BUILDTARGET);
        ArrayList<SnapshotBuildTarget> targetList = new ArrayList<SnapshotBuildTarget>();
        int i = 0;
        while (i < targetNodes.getLength()) {
            ArrayList<String> archs = new ArrayList<String>();
            ArrayList<String> repos = new ArrayList<String>();
            Node targetNode = targetNodes.item(i);
            String buildTargetName = SnapshotBuildXMLParser.getTargetName(targetNode);
            if (buildTargetName != null) {
                NodeList childNodes = targetNode.getChildNodes();
                int j = 0;
                while (j < childNodes.getLength()) {
                    Node childNode = childNodes.item(j);
                    if (childNode != null) {
                        String repo;
                        if (childNode.getNodeName().equals(TAG_ARCHS)) {
                            archs.addAll(SnapshotBuildXMLParser.getArchs(childNode));
                        } else if (childNode.getNodeName().equals(TAG_REPO) && (repo = SnapshotBuildXMLParser.getRepos(childNode)) != null) {
                            try {
                                URL newURL = new URL(url, repo);
                                repos.add(newURL.toString());
                            }
                            catch (MalformedURLException malformedURLException) {}
                        }
                    }
                    ++j;
                }
                SnapshotBuildTarget target = new SnapshotBuildTarget(buildTargetName, archs, repos);
                targetList.add(target);
            }
            ++i;
        }
        return targetList;
    }

    private static String getTargetName(Node node) {
        Node nameItem = node.getAttributes().getNamedItem(ATTR_NAME);
        if (nameItem != null) {
            return nameItem.getNodeValue();
        }
        return null;
    }

    private static List<String> getArchs(Node node) {
        if (node == null) {
            return null;
        }
        ArrayList<String> archs = new ArrayList<String>();
        NodeList archNodes = node.getChildNodes();
        int i = 0;
        while (i < archNodes.getLength()) {
            Node archChildNode = archNodes.item(i);
            if (archChildNode.getNodeName().equals(TAG_ARCH)) {
                String arch = archChildNode.getFirstChild().getNodeValue();
                archs.add(arch);
            }
            ++i;
        }
        return archs;
    }

    private static String getRepos(Node node) {
        if (node.getFirstChild() == null) {
            return null;
        }
        NamedNodeMap repoTypeMap = node.getAttributes();
        Node repoTypeItem = repoTypeMap.getNamedItem(ATTR_TYPE);
        if (repoTypeItem.getNodeValue().equals("source")) {
            return null;
        }
        String repo = node.getFirstChild().getNodeValue();
        return repo;
    }

    private static List<Architecture> convertToArchitectureList(List<SnapshotBuildTarget> targetList) {
        if (targetList.isEmpty()) {
            return null;
        }
        ArrayList<Architecture> archs = new ArrayList<Architecture>();
        for (SnapshotBuildTarget target : targetList) {
            for (String archStr : target.getArchs()) {
                Architecture newArch = new Architecture(archStr, target.getRepos());
                archs.add(newArch);
            }
        }
        return archs;
    }
}

