/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.rpm;

import java.util.ArrayList;
import java.util.List;
import org.tizen.nativeplatform.launcher.rpm.IPkgFilter;
import org.tizen.nativeplatform.pkg.model.IPackage;
import org.tizen.nativeplatform.types.CmdTargetTypes;

public class RpmPackageFilter
implements IPkgFilter {
    private static final String POSTFIX_DEBUGSOURCE_PKG = "-debugsource";
    private static final String POSTFIX_DEBUGINFO_PKG = "-debuginfo";
    private static final String POSTFIX_DEVEL_PKG = "-devel";

    @Override
    public List<IPackage> filter(CmdTargetTypes type, List<IPackage> list) {
        if (type.equals((Object)CmdTargetTypes.DEVICE)) {
            return this.filterDevicePkg(list);
        }
        if (type.equals((Object)CmdTargetTypes.ROOTSTRAP)) {
            return this.filterRootstrapPkg(list);
        }
        return this.filterRootstrapPkg(list);
    }

    private List<IPackage> filterDevicePkg(List<IPackage> list) {
        ArrayList<IPackage> result = new ArrayList<IPackage>();
        for (IPackage pkg : list) {
            String name = pkg.getName();
            if (pkg.needsFilter() && (name.contains(POSTFIX_DEBUGSOURCE_PKG) || name.contains(POSTFIX_DEBUGINFO_PKG) || name.contains(POSTFIX_DEVEL_PKG))) continue;
            result.add(pkg.clonePkg());
        }
        return result;
    }

    private List<IPackage> filterRootstrapPkg(List<IPackage> list) {
        ArrayList<IPackage> result = new ArrayList<IPackage>();
        for (IPackage pkg : list) {
            result.add(pkg.clonePkg());
        }
        return result;
    }
}

