/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.tizen.nativeplatform.launcher.ui.IAppIdChangeListener;
import org.tizen.nativeplatform.launcher.ui.PlatformCommonTab;
import org.tizen.nativeplatform.pkg.model.IPackage;
import org.tizen.nativeplatform.util.PlatformLaunchUtil;
import org.tizen.nativeplatform.util.PlatformProjectUtil;
import org.tizen.sdblib.service.FileEntry;

public class PlatformMainTab
extends PlatformCommonTab {
    private final String BUNDLE_NAME = String.valueOf(PlatformMainTab.class.getPackage().getName()) + ".LaunchTabUIMessages";
    private ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);
    private String[] appId;
    private String[] executablePath;
    private String selectedAppId;
    private String selectedExec;
    private String appIdLabelText;
    private String progLabelText;
    private List<IAppIdChangeListener> idChangeListeners = new ArrayList<IAppIdChangeListener>();
    private Combo appIdCombo;
    private Label fProgLabel;
    private List<IPackage> packages = new ArrayList<IPackage>();

    public PlatformMainTab() {
        this(false);
    }

    public PlatformMainTab(boolean isDebug) {
        if (isDebug) {
            this.appIdLabelText = "Application to be debug:";
            this.progLabelText = "Executable file:";
        } else {
            this.appIdLabelText = "Application to be run:";
            this.progLabelText = "Command:";
        }
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        this.createVerticalSpacer(comp, 1);
        this.createProjectGroup(comp, 1);
        this.createAppComboComposite(comp);
        this.createExeFileField(comp, 1);
        this.createVerticalSpacer(comp, 1);
    }

    protected void createProjectGroup(Composite parent, int colSpan) {
        Composite projComp = new Composite(parent, 0);
        GridLayout projLayout = new GridLayout();
        projLayout.numColumns = 2;
        projLayout.marginHeight = 0;
        projLayout.marginWidth = 0;
        projComp.setLayout((Layout)projLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        projComp.setLayoutData((Object)gd);
        this.fProjLabel = new Label(projComp, 0);
        this.fProjLabel.setText(LaunchMessages.CMainTab_ProjectColon);
        this.fProjText = new Text(projComp, 2060);
        gd = new GridData(768);
        this.fProjText.setLayoutData((Object)gd);
    }

    public void registerAppIdChangeListener(IAppIdChangeListener listener) {
        this.idChangeListeners.add(listener);
    }

    private void createAppComboComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(768));
        Label appIdLabel = new Label(composite, 0);
        appIdLabel.setText(this.appIdLabelText);
        this.appIdCombo = new Combo(composite, 8);
        GridData gridData = new GridData(768);
        this.appIdCombo.setLayoutData((Object)gridData);
        this.appIdCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String newAppId = ((Combo)evt.getSource()).getText();
                int index = ((Combo)evt.getSource()).getSelectionIndex();
                String newExec = PlatformMainTab.this.executablePath[index];
                if (!PlatformMainTab.this.selectedAppId.equals(newAppId)) {
                    PlatformMainTab.this.changeCommand(PlatformMainTab.this.selectedAppId, PlatformMainTab.this.selectedExec, newAppId, newExec);
                    PlatformMainTab.this.notifyIdChanges(PlatformMainTab.this.selectedAppId, PlatformMainTab.this.selectedExec, newAppId, newExec);
                    PlatformMainTab.this.selectedAppId = newAppId;
                }
            }
        });
    }

    private void changeCommand(String prevId, String prevExec, String newId, String newExec) {
        String command = this.fBinPathText.getText();
        String changed = PlatformLaunchUtil.changeCommand((String)command, (String)prevId, (String)prevExec, (String)newId, (String)newExec);
        if (changed != null) {
            this.fBinPathText.setText(changed);
        }
    }

    private void notifyIdChanges(String prevId, String prevExec, String newId, String newExec) {
        for (IAppIdChangeListener l : this.idChangeListeners) {
            l.appIdchanged(prevId, prevExec, newId, newExec);
        }
    }

    private void createExeFileField(Composite parent, int colSpan) {
        Composite mainComp = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 3;
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainComp.setLayout((Layout)mainLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        mainComp.setLayoutData((Object)gd);
        this.fProgLabel = new Label(mainComp, 0);
        this.fProgLabel.setText(this.progLabelText);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.fProgLabel.setLayoutData((Object)gd);
        this.fBinPathText = new Text(mainComp, 2052);
        gd = new GridData(768);
        this.fBinPathText.setLayoutData((Object)gd);
        this.fBinPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                PlatformMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button fBrowseForBinaryButton = this.createPushButton(mainComp, this.resources.getString("Button.Browse"), null);
        fBrowseForBinaryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                FileEntry entry = PlatformMainTab.this.handleRemoteBrowseButtonSelected(null);
                if (entry != null) {
                    String path = entry.getFullPath();
                    if (path != null) {
                        PlatformMainTab.this.fBinPathText.setText(path);
                    }
                    PlatformMainTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.updateProgramFromConfig(configuration);
        this.updateProjectFromConfig(configuration);
        this.updateAppIdFromConfig(configuration);
        ICProject cproj = this.getCProject();
        this.appIdCombo.removeAll();
        if (cproj != null) {
            IProject proj = cproj.getProject();
            boolean isEflProj = PlatformProjectUtil.isEFLApplication((IProject)proj);
            this.appId = PlatformLaunchUtil.getAppId((IProject)proj);
            if (this.appId == null || this.appId.length == 0) {
                if (isEflProj) {
                    String msg = String.format("Failed to get application ID. Build \"%s\" project first", proj.getName());
                    this.setErrorMessage(msg);
                } else {
                    String msg = String.format("\"%s\" project is not EFL application. Input command to test \"%s\" project", proj.getName(), proj.getName());
                    this.setErrorMessage(null);
                    this.setMessage(msg);
                }
            } else {
                this.executablePath = PlatformLaunchUtil.getProgramPath((IProject)proj);
                this.appIdCombo.setItems(this.appId);
                int index = this.appIdCombo.indexOf(this.selectedAppId);
                if (index < 0) {
                    this.selectedAppId = this.appId[0];
                    index = 0;
                }
                this.appIdCombo.select(index);
                this.selectedExec = this.executablePath != null ? this.executablePath[index] : "";
                String msg = String.format("\"%s\" project is EFL application. Choose application ID to be run or debug.", proj.getName());
                this.setErrorMessage(null);
                this.setMessage(msg);
            }
        } else {
            this.setErrorMessage("Failed to get project.");
        }
    }

    public boolean isValid(ILaunchConfiguration config) {
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        String programPath = this.fBinPathText.getText().trim();
        String name = this.fProjText.getText().trim();
        String appId = this.appIdCombo.getText().trim();
        ArrayList<String> pkgs = new ArrayList<String>();
        for (IPackage p : this.packages) {
            pkgs.add(p.getPath());
        }
        config.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", programPath);
        config.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", name);
        config.setAttribute("org.tizen.platform.launch.APP_ID_ATTR", appId);
    }

    protected void updateAppIdFromConfig(ILaunchConfiguration config) {
        String id = "";
        try {
            id = config.getAttribute("org.tizen.platform.launch.APP_ID_ATTR", "");
        }
        catch (CoreException ce) {
            LaunchUIPlugin.log((Throwable)ce);
        }
        this.selectedAppId = id;
    }
}

