/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.wizard.pages;

import java.util.ResourceBundle;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ApplicationPathDialog
extends Dialog {
    private Shell shell;
    private String applicationPath = "";
    private Text applicationPathText;
    private int x = 0;
    private int y = 0;
    private int width = 600;
    private int height = 250;
    private final String BUNDLE_NAME = String.valueOf(ApplicationPathDialog.class.getPackage().getName()) + ".LaunchWizardPageUIMessages";
    private ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);

    public ApplicationPathDialog(Shell parentShell, String applicationPath) {
        super(parentShell);
        this.shell = parentShell;
        this.applicationPath = applicationPath;
        Rectangle bounds = parentShell.getBounds();
        this.x = bounds.x + (bounds.width - this.width) / 2;
        this.y = bounds.y + (bounds.height - this.height) / 2;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.resources.getString("PathDialog.Title"));
        newShell.setLocation(this.x, this.y);
        newShell.setSize(this.width, this.height);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(770));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createApplicationPathComposite(composite);
        return null;
    }

    private void createApplicationPathComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        Label descLabel = new Label(composite, 0);
        descLabel.setText(this.resources.getString("PathDialog.Desc"));
        this.applicationPathText = new Text(composite, 2052);
        gridData = new GridData(768);
        gridData.minimumHeight = 0;
        this.applicationPathText.setLayoutData((Object)gridData);
        this.applicationPathText.setText(this.applicationPath);
    }

    public String getApplicationPath() {
        return this.applicationPath;
    }

    protected void okPressed() {
        this.applicationPath = this.applicationPathText.getText().trim();
        super.okPressed();
    }
}

