/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.util;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.ArrayUtil;
import org.tizen.nativeplatform.PlatformInstances;
import org.tizen.nativeplatform.command.launcher.HostCommandLauncher;
import org.tizen.nativeplatform.filefilter.XmlFileFilter;
import org.tizen.nativeplatform.pkg.commander.IPkgModelMaker;
import org.tizen.nativeplatform.pkg.commander.rpm.RpmModelMaker;
import org.tizen.nativeplatform.pkg.model.IPackage;
import org.tizen.nativeplatform.util.LRCaching;

public class CommonPackageUtil {
    protected static IPkgModelMaker modelMaker = new RpmModelMaker();
    protected static final HashMap<String, String[]> BLOCKED_KEYWORDS = new HashMap();
    private static final String BUNDLE_NAME = String.valueOf(CommonPackageUtil.class.getPackage().getName()) + ".UIMessages";
    private static ResourceBundle resources = ResourceBundle.getBundle(BUNDLE_NAME);
    protected static final Logger logger = LoggerFactory.getLogger(CommonPackageUtil.class);

    public static boolean validateProjectName(String category, String projectName) {
        Object[] blockedKeywords = BLOCKED_KEYWORDS.get(category);
        return ArrayUtil.isEmpty((Object[])blockedKeywords) || !ArrayUtil.contains((Object[])blockedKeywords, (Object)projectName);
    }

    public static boolean build(IProject project, IConfiguration config, IProgressMonitor monitor) throws CoreException {
        project.build(10, monitor);
        List<IPackage> pkgs = PlatformInstances.getPackageUtil().getPackages(project, config);
        return !pkgs.isEmpty();
    }

    public static void cachePkgChecksum(IProject project, IConfiguration config) {
        try {
            if (!LRCaching.postBuildCachePkgChecksums(project, PlatformInstances.getPackageUtil().getPackages(project, config))) {
                logger.error(resources.getString("Failed.cache.pkg.checksum"));
            }
        }
        catch (InterruptedException e) {
            logger.error(resources.getString("Failed.cache.pkg.checksum"));
            e.printStackTrace();
        }
    }

    public static String[] getXmls(IProject project) {
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration defaultConfig = info.getDefaultConfiguration();
        File dir = project.getFile(defaultConfig.getName()).getLocation().toFile();
        String[] files = dir.list(new XmlFileFilter());
        if (files == null || files.length == 0) {
            return null;
        }
        return files;
    }

    public static boolean checkXmls(IProject project) {
        String[] xmls = CommonPackageUtil.getXmls(project);
        return xmls != null;
    }

    public static List<IPackage> getPackages(List<String> pkgPath) {
        List<IPackage> pkgmodel = modelMaker.makeModels(pkgPath);
        return pkgmodel;
    }

    public static IPkgModelMaker getModelMaker() {
        return modelMaker;
    }

    public static boolean isAppPkg(IProject proj, IPackage pkg) {
        String path = pkg.getPath();
        String[] xmls = CommonPackageUtil.getXmls(proj);
        if (xmls == null) {
            return false;
        }
        String[] stringArray = xmls;
        if (xmls.length != 0) {
            String xml = stringArray[0];
            String command = String.format("rpm -qpl %s | grep %s", path, xml);
            String result = "";
            try {
                result = HostCommandLauncher.executeOutput(command);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return !result.isEmpty();
        }
        return false;
    }
}

