/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.OSChecker;
import org.tizen.nativeplatform.launcher.command.provider.IDebugCommandProvider;
import org.tizen.nativeplatform.launcher.command.provider.IRunCommandProvider;

public class LaunchCommandFactory {
    private static final String EXTENSION_ID = "org.tizen.nativeplatform.launchprovider";
    private static final String TAG_DEBUG_PROVIDER = "debugProvider";
    private static final String TAG_RUN_PROVIDER = "runProvider";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_OS = "os";
    private static final String ATTR_CLASS = "class";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public IDebugCommandProvider getDebugProvider() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(EXTENSION_ID);
        IExtension[] exts = ep.getExtensions();
        ArrayList<Proxy> found = new ArrayList<Proxy>();
        int i = 0;
        while (i < exts.length) {
            IConfigurationElement[] configElems = exts[i].getConfigurationElements();
            int j = 0;
            while (j < configElems.length) {
                Proxy proxy = this.parseType(configElems[j], TAG_DEBUG_PROVIDER);
                if (proxy != null) {
                    found.add(proxy);
                }
                ++j;
            }
            ++i;
        }
        Proxy[] providers = found.toArray(new Proxy[found.size()]);
        int i2 = 0;
        while (i2 < providers.length) {
            if (OSChecker.isLinux() || OSChecker.isUnix() ? providers[i2].getOs().equals("linux") || providers[i2].getOs().equals("unix") : OSChecker.isWindows() && (providers[i2].getOs().equals("windows") || providers[i2].getOs().equals("win"))) {
                return (IDebugCommandProvider)providers[i2].getProvider();
            }
            ++i2;
        }
        return null;
    }

    public IRunCommandProvider getRunProvider() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(EXTENSION_ID);
        IExtension[] exts = ep.getExtensions();
        ArrayList<Proxy> found = new ArrayList<Proxy>();
        int i = 0;
        while (i < exts.length) {
            IConfigurationElement[] configElems = exts[i].getConfigurationElements();
            int j = 0;
            while (j < configElems.length) {
                Proxy proxy = this.parseType(configElems[j], TAG_RUN_PROVIDER);
                if (proxy != null) {
                    found.add(proxy);
                }
                ++j;
            }
            ++i;
        }
        Proxy[] providers = found.toArray(new Proxy[found.size()]);
        int i2 = 0;
        while (i2 < providers.length) {
            if (OSChecker.isLinux() || OSChecker.isUnix() ? providers[i2].getOs().equals("linux") || providers[i2].getOs().equals("unix") : OSChecker.isWindows() && (providers[i2].getOs().equals("windows") || providers[i2].getOs().equals("win"))) {
                return (IRunCommandProvider)providers[i2].getProvider();
            }
            ++i2;
        }
        return null;
    }

    private Proxy parseType(IConfigurationElement configElem, String tag) {
        if (!configElem.getName().equals(tag)) {
            return null;
        }
        try {
            return new Proxy(configElem);
        }
        catch (Exception e) {
            String name = configElem.getAttribute(ATTR_NAME);
            if (name == null) {
                name = "[missing name attribute]";
            }
            String msg = "Failed to load provider named" + name + " in " + configElem.getDeclaringExtension().getNamespace();
            this.logger.error(msg, (Throwable)e);
            return null;
        }
    }

    private static class Proxy {
        private IConfigurationElement configElement;
        private String name;
        private String id;
        private String os;
        protected final Logger logger = LoggerFactory.getLogger(this.getClass());

        public Proxy(IConfigurationElement configElem) {
            this.configElement = configElem;
            this.id = this.getAttribute(configElem, LaunchCommandFactory.ATTR_ID, "");
            this.name = this.getAttribute(configElem, LaunchCommandFactory.ATTR_NAME, this.id);
            this.os = this.getAttribute(configElem, LaunchCommandFactory.ATTR_OS, "linux");
            this.getAttribute(configElem, LaunchCommandFactory.ATTR_CLASS, null);
        }

        private String getAttribute(IConfigurationElement configElem, String name, String defaultValue) {
            String value = configElem.getAttribute(name);
            if (value != null) {
                return value;
            }
            if (defaultValue != null) {
                return defaultValue;
            }
            throw new IllegalArgumentException("Missing" + name + "attribute");
        }

        public String getOs() {
            return this.os;
        }

        public Object getProvider() {
            Object obj = null;
            try {
                obj = this.configElement.createExecutableExtension(LaunchCommandFactory.ATTR_CLASS);
            }
            catch (CoreException e) {
                String msg = "Failed to get provider: " + this.configElement.getAttribute(LaunchCommandFactory.ATTR_CLASS) + " in type: " + this.id + " in plugin: " + this.configElement.getDeclaringExtension().getNamespace();
                this.logger.error(msg, (Throwable)e);
            }
            return obj;
        }
    }
}

