/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.delegate;

import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.GDBServerCDIDebugger2;
import org.eclipse.cdt.debug.mi.core.IGDBServerMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.command.Command;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIExecArguments;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSet;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSetEnvironment;
import org.eclipse.cdt.debug.mi.core.command.MITargetSelect;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.tizen.common.util.log.UserLogger;

public class TizenPlatformDebugger
extends GDBServerCDIDebugger2 {
    protected void doStartSession(ILaunch launch, Session session, IProgressMonitor monitor) throws CoreException {
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.setProgramEnvironments(config, session, monitor);
        this.setProgramArguments(config, session, monitor);
        this.startGDBServerSession(config, session, monitor);
        this.initializeLibraries(config, session);
    }

    protected void setProgramArguments(ILaunchConfiguration config, Session session, IProgressMonitor monitor) throws CoreException {
        ICDITarget[] targets = session.getTargets();
        int i = 0;
        while (i < targets.length) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            Target target = (Target)targets[i];
            MISession miSession = target.getMISession();
            CommandFactory factory = miSession.getCommandFactory();
            String[] args = this.getProgramArguments(config);
            MIInfo info = null;
            MIException ex = null;
            if (args != null && args.length > 0) {
                try {
                    MIExecArguments cmd = factory.createMIExecArguments(args);
                    miSession.postCommand((Command)cmd);
                    info = cmd.getMIInfo();
                }
                catch (MIException e) {
                    ex = e;
                }
                if (info == null) {
                    throw this.newCoreException(MIPlugin.getResourceString((String)"src.GDBServerCDIDebugger.target_selection_failed"), ex);
                }
            }
            ++i;
        }
    }

    protected void setProgramEnvironments(ILaunchConfiguration config, Session session, IProgressMonitor monitor) throws CoreException {
        ICDITarget[] targets = session.getTargets();
        int i = 0;
        while (i < targets.length) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            Target target = (Target)targets[i];
            MISession miSession = target.getMISession();
            CommandFactory factory = miSession.getCommandFactory();
            String[] envs = this.getProgramEnvironments(config);
            MIInfo info = null;
            MIException ex = null;
            if (envs != null && envs.length > 0) {
                try {
                    MIGDBSetEnvironment cmd = factory.createMIGDBSetEnvironment(envs);
                    miSession.postCommand((Command)cmd);
                    info = cmd.getMIInfo();
                }
                catch (MIException e) {
                    ex = e;
                }
                if (info == null) {
                    throw this.newCoreException(MIPlugin.getResourceString((String)"src.GDBServerCDIDebugger.target_selection_failed"), ex);
                }
            }
            ++i;
        }
    }

    protected String[] getRunArguments(ILaunchConfiguration config) throws CoreException {
        return new String[]{this.getWorkingDirectory(config), this.getCommandFile(config)};
    }

    private String[] getProgramArguments(ILaunchConfiguration config) throws CoreException {
        String arguments = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", "");
        String[] args = arguments.replaceAll("\n", " ").split(" ");
        return args;
    }

    private String[] getProgramEnvironments(ILaunchConfiguration config) throws CoreException {
        String[] envs = DebugPlugin.getDefault().getLaunchManager().getEnvironment(config);
        return envs;
    }

    protected String getCommandFile(ILaunchConfiguration config) throws CoreException {
        String gdbinit = config.getAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, ".gdbinit");
        return gdbinit != null && gdbinit.length() > 0 ? "--command=" + gdbinit : "--nx";
    }

    protected void startGDBServerSession(ILaunchConfiguration config, Session session, IProgressMonitor monitor) throws CoreException {
        MIException ex;
        MIInfo info;
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        ICDITarget[] targets = session.getTargets();
        int launchTimeout = MIPlugin.getLaunchTimeout();
        boolean tcpConnection = config.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_REMOTE_TCP, false);
        if (!tcpConnection) {
            String remoteBaud = config.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_DEV_SPEED, "invalid");
            int i = 0;
            while (i < targets.length) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                Target target = (Target)targets[i];
                MISession miSession = target.getMISession();
                CommandFactory factory = miSession.getCommandFactory();
                MIGDBSet setRemoteBaud = factory.createMIGDBSet(new String[]{"remotebaud", remoteBaud});
                info = null;
                ex = null;
                try {
                    miSession.postCommand((Command)setRemoteBaud, (long)launchTimeout);
                    info = setRemoteBaud.getMIInfo();
                }
                catch (MIException e) {
                    ex = e;
                }
                if (info == null) {
                    throw this.newCoreException(MIPlugin.getResourceString((String)"src.GDBServerDebugger.Can_not_set_Baud"), ex);
                }
                ++i;
            }
        }
        int i = 0;
        while (i < targets.length) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            Target target = (Target)targets[i];
            MISession miSession = target.getMISession();
            CommandFactory factory = miSession.getCommandFactory();
            String[] targetParams = this.getTargetParams(config, tcpConnection);
            MITargetSelect select = factory.createMITargetSelect(targetParams);
            info = null;
            ex = null;
            try {
                UserLogger.start((String)"platform.launch", (String)"connect.gdb");
                miSession.postCommand((Command)select, (long)launchTimeout);
                UserLogger.end((String)"platform.launch", (String)"connect.gdb");
                info = select.getMIInfo();
            }
            catch (MIException e) {
                ex = e;
            }
            if (info == null) {
                throw this.newCoreException(MIPlugin.getResourceString((String)"src.GDBServerCDIDebugger.target_selection_failed"), ex);
            }
            miSession.getMIInferior().setSuspended();
            miSession.getMIInferior().update();
            miSession.getMIInferior().setIsRemoteInferior(true);
            ++i;
        }
    }
}

