/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.linux.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.IOUtil;
import org.tizen.nativeplatform.PlatformInstances;
import org.tizen.nativeplatform.command.launcher.IScriptProvider;
import org.tizen.nativeplatform.password.SudoPasswdManager;
import org.tizen.nativeplatform.util.CommonBuildCommandUtil;

public class ScriptProvider
implements IScriptProvider {
    public final Logger logger = LoggerFactory.getLogger(ScriptProvider.class);

    public String genCacheChecksumScript(IProject project, String filePaths) {
        String cachingDir;
        File cacheChecksumScript;
        BufferedWriter bw;
        block10: {
            block11: {
                bw = null;
                cacheChecksumScript = null;
                cachingDir = PlatformInstances.getBuildCommandUtil().getCachingDir(project);
                if (cachingDir == null) {
                    this.logger.error(String.format("Failed to get checksum cache directory", new Object[0]));
                    return null;
                }
                String workingDir = PlatformInstances.getBuildCommandUtil().getWorkingDir();
                if (workingDir == null) {
                    this.logger.error(String.format("Failed to get checksum working directory", new Object[0]));
                    return null;
                }
                File workingPath = new File(workingDir);
                if (!workingPath.exists() && !workingPath.mkdirs()) {
                    this.logger.error(String.format("Failed to make directory: %s", workingDir));
                    return null;
                }
                String randomNum = CommonBuildCommandUtil.getRandomNum();
                String fileName = "cache_checksum_" + randomNum + ".sh";
                cacheChecksumScript = new File(new Path(workingDir).append(fileName).toOSString());
                if (cacheChecksumScript.createNewFile()) break block10;
                if (cacheChecksumScript.delete()) break block11;
                this.logger.error(String.format("Failed to remove file: %s", cacheChecksumScript.getAbsoluteFile()));
                IOUtil.tryClose((Object[])new Object[]{bw});
                return null;
            }
            if (cacheChecksumScript.createNewFile()) break block10;
            this.logger.error(String.format("Failed to create file: %s", cacheChecksumScript.getAbsoluteFile()));
            IOUtil.tryClose((Object[])new Object[]{bw});
            return null;
        }
        try {
            try {
                bw = new BufferedWriter(new FileWriter(cacheChecksumScript));
                bw.write("#!/bin/sh -ee");
                bw.newLine();
                bw.write(String.format("rm -rf %s/*", cachingDir));
                bw.newLine();
                bw.write(String.format("mkdir -p %s", cachingDir));
                bw.newLine();
                bw.write(String.format("cd %s", cachingDir));
                bw.newLine();
                bw.write(String.format("for file in `ls %s`", filePaths));
                bw.newLine();
                bw.write("do");
                bw.newLine();
                bw.write("    checksum=`md5sum ${file} | awk '{print $1}'`");
                bw.newLine();
                bw.write("    pkgfile=`basename ${file}`");
                bw.newLine();
                bw.write("    pkgdir=\"${pkgfile}_${checksum}\"");
                bw.newLine();
                bw.write("    rm -rf ${pkgdir}");
                bw.newLine();
                bw.write("    mkdir ${pkgdir}");
                bw.newLine();
                bw.write("    cd ${pkgdir}");
                bw.newLine();
                bw.write("    rpm2cpio ${file} | cpio -idm --quiet");
                bw.newLine();
                bw.write("    echo \"key:  ${pkgdir}\"");
                bw.newLine();
                bw.write("    cd ..");
                bw.newLine();
                bw.write("    find ${pkgdir} -type f -printf '\"%p\"\\n' | xargs md5sum");
                bw.newLine();
                bw.write("done");
                cacheChecksumScript.setExecutable(true);
            }
            catch (IOException e) {
                if (cacheChecksumScript != null) {
                    this.logger.error(String.format("Failed to write file: %s", cacheChecksumScript.getAbsoluteFile()), (Throwable)e);
                    this.cleanUpScript(cacheChecksumScript.getAbsolutePath());
                }
                IOUtil.tryClose((Object[])new Object[]{bw});
                return null;
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{bw});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{bw});
        return cacheChecksumScript.getAbsolutePath();
    }

    public String genCacheChecksumScriptNoHash(IProject project, String filePaths) {
        String cachingDir;
        File cacheChecksumScript;
        BufferedWriter bw;
        block10: {
            block11: {
                bw = null;
                cacheChecksumScript = null;
                cachingDir = PlatformInstances.getBuildCommandUtil().getCachingDir(project);
                if (cachingDir == null) {
                    this.logger.error(String.format("Failed to get checksum cache directory", new Object[0]));
                    return null;
                }
                String workingDir = PlatformInstances.getBuildCommandUtil().getWorkingDir();
                if (workingDir == null) {
                    this.logger.error(String.format("Failed to get checksum working directory", new Object[0]));
                    return null;
                }
                File workingPath = new File(workingDir);
                if (!workingPath.exists() && !workingPath.mkdirs()) {
                    this.logger.error(String.format("Failed to make directory: %s", workingDir));
                    return null;
                }
                String randomNum = CommonBuildCommandUtil.getRandomNum();
                String fileName = "cache_checksum_" + randomNum + ".sh";
                cacheChecksumScript = new File(new Path(workingDir).append(fileName).toOSString());
                if (cacheChecksumScript.createNewFile()) break block10;
                if (cacheChecksumScript.delete()) break block11;
                this.logger.error(String.format("Failed to remove file: %s", cacheChecksumScript.getAbsoluteFile()));
                IOUtil.tryClose((Object[])new Object[]{bw});
                return null;
            }
            if (cacheChecksumScript.createNewFile()) break block10;
            this.logger.error(String.format("Failed to create file: %s", cacheChecksumScript.getAbsoluteFile()));
            IOUtil.tryClose((Object[])new Object[]{bw});
            return null;
        }
        try {
            try {
                bw = new BufferedWriter(new FileWriter(cacheChecksumScript));
                bw.write("#!/bin/sh -ee");
                bw.newLine();
                bw.write(String.format("rm -rf %s/*", cachingDir));
                bw.newLine();
                bw.write(String.format("mkdir -p %s", cachingDir));
                bw.newLine();
                bw.write(String.format("cd %s", cachingDir));
                bw.newLine();
                bw.write(String.format("for file in `ls %s`", filePaths));
                bw.newLine();
                bw.write("do");
                bw.newLine();
                bw.write(String.format("    projectName=`basename %s`", cachingDir));
                bw.newLine();
                bw.write("    pkgfile=`basename ${file}`");
                bw.newLine();
                bw.write("    pkgdir=\"${pkgfile}_${projectName}\"");
                bw.newLine();
                bw.write("    rm -rf ${pkgdir}");
                bw.newLine();
                bw.write("    mkdir ${pkgdir}");
                bw.newLine();
                bw.write("    cd ${pkgdir}");
                bw.newLine();
                bw.write("    rpm2cpio ${file} | cpio -idm --quiet");
                bw.newLine();
                bw.write("    echo \"key:  ${pkgdir}\"");
                bw.newLine();
                bw.write("    cd ..");
                bw.newLine();
                bw.write("    find ${pkgdir} -type f -printf '\"%p\"\\n' | xargs md5sum");
                bw.newLine();
                bw.write("done");
                cacheChecksumScript.setExecutable(true);
            }
            catch (IOException e) {
                if (cacheChecksumScript != null) {
                    this.logger.error(String.format("Failed to write file: %s", cacheChecksumScript.getAbsoluteFile()), (Throwable)e);
                    this.cleanUpScript(cacheChecksumScript.getAbsolutePath());
                }
                IOUtil.tryClose((Object[])new Object[]{bw});
                return null;
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{bw});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{bw});
        return cacheChecksumScript.getAbsolutePath();
    }

    public String genSudoExecuteExpectScript(String command) {
        File exitStatusScript;
        BufferedWriter bw;
        File shellScript;
        File expectScript;
        block14: {
            block15: {
                String runScriptName;
                String workingDir;
                String passwd;
                block12: {
                    block13: {
                        passwd = SudoPasswdManager.getSudoPassword();
                        expectScript = null;
                        shellScript = null;
                        bw = null;
                        workingDir = PlatformInstances.getBuildCommandUtil().getWorkingDir();
                        if (workingDir == null) {
                            this.logger.error("Failed to get working directory");
                            return null;
                        }
                        File workingPath = new File(PlatformInstances.getBuildCommandUtil().getWorkingDir());
                        if (!workingPath.exists() && !workingPath.mkdirs()) {
                            this.logger.error(String.format("Failed to make directory: %s", workingDir));
                            return null;
                        }
                        String randomNum = CommonBuildCommandUtil.getRandomNum();
                        String exitStatusFileName = "exit-status_" + randomNum;
                        String expectScriptName = "run-sudo_" + randomNum + ".exp";
                        runScriptName = "run-sudo_" + randomNum + ".sh";
                        exitStatusScript = new File(new Path(workingDir).append(exitStatusFileName).toOSString());
                        expectScript = new File(new Path(workingDir).append(expectScriptName).toOSString());
                        if (expectScript.createNewFile()) break block12;
                        if (expectScript.delete()) break block13;
                        this.logger.error(String.format("Failed to remove file: %s", expectScript.getAbsoluteFile()));
                        IOUtil.tryClose((Object[])new Object[]{bw});
                        return null;
                    }
                    if (expectScript.createNewFile()) break block12;
                    this.logger.error(String.format("Failed to create file: %s", expectScript.getAbsoluteFile()));
                    IOUtil.tryClose((Object[])new Object[]{bw});
                    return null;
                }
                bw = new BufferedWriter(new FileWriter(expectScript));
                bw.write("#!/usr/bin/expect --");
                bw.newLine();
                bw.write(String.format("spawn sh -c \"%s;echo \\$? > %s\"", command, exitStatusScript.getAbsolutePath()));
                bw.newLine();
                bw.write("while (1) {");
                bw.newLine();
                bw.write("  expect {");
                bw.newLine();
                bw.write("    \"password for\" {");
                bw.newLine();
                bw.write(String.format("send \"%s\\r\"", passwd));
                bw.newLine();
                bw.write("    }");
                bw.newLine();
                bw.write("    eof {");
                bw.newLine();
                bw.write("      return");
                bw.newLine();
                bw.write("    }");
                bw.newLine();
                bw.write("  }");
                bw.newLine();
                bw.write("}");
                bw.newLine();
                bw.close();
                expectScript.setExecutable(true);
                shellScript = new File(new Path(workingDir).append(runScriptName).toOSString());
                if (shellScript.createNewFile()) break block14;
                if (shellScript.delete()) break block15;
                this.logger.error(String.format("Failed to remove file: %s", shellScript.getAbsoluteFile()));
                IOUtil.tryClose((Object[])new Object[]{bw});
                return null;
            }
            if (shellScript.createNewFile()) break block14;
            this.logger.error(String.format("Failed to create file: %s", shellScript.getAbsoluteFile()));
            IOUtil.tryClose((Object[])new Object[]{bw});
            return null;
        }
        try {
            try {
                bw = new BufferedWriter(new FileWriter(shellScript));
                bw.write("#!/bin/bash -ee");
                bw.newLine();
                bw.write(expectScript.getAbsolutePath());
                bw.newLine();
                bw.write(String.format("EXIT_CODE=`cat %s`", exitStatusScript.getAbsolutePath()));
                bw.newLine();
                bw.write("if [ \"$EXIT_CODE\" != \"0\" ]; then");
                bw.newLine();
                bw.write(" echo \"EXIT CODE=${EXIT_CODE}\" >&2");
                bw.newLine();
                bw.write(" exit 1");
                bw.newLine();
                bw.write("fi");
                bw.newLine();
                shellScript.setExecutable(true);
            }
            catch (IOException e) {
                if (shellScript != null) {
                    this.logger.error(String.format("Failed to write file: %s", shellScript.getAbsoluteFile()), (Throwable)e);
                    this.cleanUpScript(shellScript.getPath());
                }
                if (expectScript != null) {
                    this.logger.error(String.format("Failed to write file: %s", expectScript.getAbsoluteFile()), (Throwable)e);
                    this.cleanUpScript(expectScript.getPath());
                }
                IOUtil.tryClose((Object[])new Object[]{bw});
                return null;
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{bw});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{bw});
        return shellScript.getPath();
    }

    public String genSudoExecuteScript(String command) {
        File exitStatusScript;
        String scriptFile;
        BufferedWriter bw;
        File shellScript;
        block10: {
            block11: {
                String passwd = SudoPasswdManager.getSudoPassword();
                shellScript = null;
                bw = null;
                String workingDir = PlatformInstances.getBuildCommandUtil().getWorkingDir();
                if (workingDir == null) {
                    this.logger.error("Failed to get working directory");
                    return null;
                }
                File workingPath = new File(PlatformInstances.getBuildCommandUtil().getWorkingDir());
                if (!workingPath.exists() && !workingPath.mkdirs()) {
                    this.logger.error(String.format("Failed to make directory: %s", workingDir));
                    return null;
                }
                scriptFile = this.getSudoAskScript(passwd);
                if (scriptFile == null) {
                    return null;
                }
                String randomNum = CommonBuildCommandUtil.getRandomNum();
                String exitStatusFileName = "exit-status_" + randomNum;
                String runScriptName = "run-sudo_" + randomNum + ".sh";
                exitStatusScript = new File(new Path(workingDir).append(exitStatusFileName).toOSString());
                shellScript = new File(new Path(workingDir).append(runScriptName).toOSString());
                if (shellScript.createNewFile()) break block10;
                if (shellScript.delete()) break block11;
                this.logger.error(String.format("Failed to remove file: %s", shellScript.getAbsoluteFile()));
                IOUtil.tryClose((Object[])new Object[]{bw});
                return null;
            }
            if (shellScript.createNewFile()) break block10;
            this.logger.error(String.format("Failed to create file: %s", shellScript.getAbsoluteFile()));
            IOUtil.tryClose((Object[])new Object[]{bw});
            return null;
        }
        try {
            try {
                String _command = String.format("SUDO_ASKPASS=\"%s\" sudo -A -k %s;echo $? > %s", scriptFile, command, exitStatusScript.getAbsolutePath());
                bw = new BufferedWriter(new FileWriter(shellScript));
                bw.write("#!/bin/bash -ee");
                bw.newLine();
                bw.write(_command);
                bw.newLine();
                bw.write(String.format("EXIT_CODE=`cat %s`", exitStatusScript.getAbsolutePath()));
                bw.newLine();
                bw.write("if [ \"$EXIT_CODE\" != \"0\" ]; then");
                bw.newLine();
                bw.write(" echo \"EXIT CODE=${EXIT_CODE}\" >&2");
                bw.newLine();
                bw.write(" exit 1");
                bw.newLine();
                bw.write("fi");
                bw.newLine();
                shellScript.setExecutable(true);
            }
            catch (IOException e) {
                if (shellScript != null) {
                    this.logger.error(String.format("Failed to write file: %s", shellScript.getPath()), (Throwable)e);
                    this.cleanUpScript(shellScript.getPath());
                }
                IOUtil.tryClose((Object[])new Object[]{bw});
                return null;
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{bw});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{bw});
        return shellScript.getPath();
    }

    /*
     * Exception decompiling
     */
    public String genDebugginInterruptScript(Process process) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getSudoAskScript(String passwd) {
        File sudoAskScript;
        BufferedWriter bw;
        block9: {
            block10: {
                String workingDir = PlatformInstances.getBuildCommandUtil().getWorkingDir();
                if (workingDir == null) {
                    this.logger.error("Failed to get working directory");
                    return null;
                }
                File workingPath = new File(PlatformInstances.getBuildCommandUtil().getWorkingDir());
                if (!workingPath.exists() && !workingPath.mkdirs()) {
                    this.logger.error(String.format("Failed to make directory: %s", workingDir));
                    return null;
                }
                bw = null;
                sudoAskScript = null;
                sudoAskScript = new File(new Path(workingDir).append("sudo_ask.sh").toOSString());
                if (sudoAskScript.createNewFile()) break block9;
                if (sudoAskScript.delete()) break block10;
                this.logger.error(String.format("Failed to remove file: %s", sudoAskScript.getAbsolutePath()));
                IOUtil.tryClose((Object[])new Object[]{bw});
                return null;
            }
            if (sudoAskScript.createNewFile()) break block9;
            this.logger.error(String.format("Failed to create file: %s", sudoAskScript.getAbsolutePath()));
            IOUtil.tryClose((Object[])new Object[]{bw});
            return null;
        }
        try {
            try {
                bw = new BufferedWriter(new FileWriter(sudoAskScript));
                bw.write("#!/bin/bash");
                bw.newLine();
                bw.write(String.format("echo %s", passwd));
                bw.close();
                sudoAskScript.setExecutable(true);
            }
            catch (IOException e) {
                if (sudoAskScript != null) {
                    this.logger.error(String.format("Failed to write file: %s", sudoAskScript.getAbsolutePath()), (Throwable)e);
                    this.cleanUpScript(sudoAskScript.getPath());
                }
                IOUtil.tryClose((Object[])new Object[]{bw});
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{bw});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{bw});
        return sudoAskScript.getPath();
    }

    public boolean cleanUpScript(String scriptFile, boolean removeExpectScript) {
        if (scriptFile == null || scriptFile.isEmpty()) {
            return false;
        }
        File script = new File(scriptFile);
        if (script.exists() && !script.delete()) {
            this.logger.error(String.format("Failed to remove script file: %s", scriptFile));
            return false;
        }
        String scriptFileName = script.getName();
        if (removeExpectScript) {
            String expectScriptFileName = scriptFileName.substring(0, scriptFileName.lastIndexOf(46));
            expectScriptFileName = String.valueOf(expectScriptFileName) + ".exp";
            String expectScriptFile = new Path(scriptFile).removeLastSegments(1).append(expectScriptFileName).toOSString();
            File expectFile = new File(expectScriptFile);
            if (expectFile.exists() && !expectFile.delete()) {
                this.logger.error(String.format("Failed to remove expect script file: %s", expectScriptFile));
                return false;
            }
        }
        String[] strs = scriptFileName.split("_");
        String num = strs[strs.length - 1];
        num = num.substring(0, num.lastIndexOf(46));
        String exitValuefileName = "exit-status_" + num;
        String exitStatusFile = new Path(scriptFile).removeLastSegments(1).append(exitValuefileName).toOSString();
        File exitFile = new File(exitStatusFile);
        if (exitFile.exists() && !exitFile.delete()) {
            this.logger.error(String.format("Failed to remove exit status file: %s", exitStatusFile));
            return false;
        }
        return true;
    }

    public boolean cleanUpScript(String scriptFile) {
        return this.cleanUpScript(scriptFile, false);
    }

    public String genCompressFilesScript(IProject project, String compressedFileList, String rdsTarFileName) {
        return this.getCompressFilesScript(project, compressedFileList, rdsTarFileName);
    }

    public String getCompressFilesScript(IProject project, String compressedFileList, String rdsTarFileName) {
        File compressScript;
        BufferedWriter bw;
        String cachingDir;
        block10: {
            block11: {
                cachingDir = PlatformInstances.getBuildCommandUtil().getCachingDir(project);
                if (cachingDir == null) {
                    this.logger.error(String.format("Failed to get checksum cache directory", new Object[0]));
                    return null;
                }
                String workingDir = PlatformInstances.getBuildCommandUtil().getWorkingDir();
                if (workingDir == null) {
                    this.logger.error(String.format("Failed to get checksum working directory", new Object[0]));
                    return null;
                }
                File workingPath = new File(workingDir);
                if (!workingPath.exists() && !workingPath.mkdirs()) {
                    this.logger.error(String.format("Failed to make directory: %s", workingDir));
                    return null;
                }
                bw = null;
                compressScript = null;
                String randomNum = CommonBuildCommandUtil.getRandomNum();
                String fileName = "temp_" + randomNum + ".sh";
                compressScript = new File(new Path(workingDir).append(fileName).toOSString());
                if (compressScript.createNewFile()) break block10;
                if (compressScript.delete()) break block11;
                this.logger.error(String.format("Failed to remove file: %s", compressScript.getAbsolutePath()));
                IOUtil.tryClose((Object[])new Object[]{bw});
                return null;
            }
            if (compressScript.createNewFile()) break block10;
            this.logger.error(String.format("Failed to create file: %s", compressScript.getAbsolutePath()));
            IOUtil.tryClose((Object[])new Object[]{bw});
            return null;
        }
        try {
            try {
                bw = new BufferedWriter(new FileWriter(compressScript));
                bw.write("#!/bin/sh -ee");
                bw.write(10);
                bw.write(String.format("cd %s", cachingDir));
                bw.write(10);
                bw.write(String.format("tar -zcvf %s %s", rdsTarFileName, compressedFileList));
                bw.write(10);
                bw.close();
                compressScript.setExecutable(true);
            }
            catch (IOException e) {
                if (compressScript != null) {
                    this.logger.error(String.format("Failed to write file: %s", compressScript.getAbsolutePath()), (Throwable)e);
                    this.cleanUpScript(compressScript.getPath());
                }
                IOUtil.tryClose((Object[])new Object[]{bw});
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{bw});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{bw});
        return compressScript.getPath();
    }
}

