/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.builder.build.ui;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.internal.core.MultiConfiguration;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractCBuildPropertyTab;
import org.eclipse.cdt.ui.newui.ICPropertyProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.tizen.nativeplatform.PlatformConfigurationManager;
import org.tizen.nativeplatform.builder.PlatformInstances;
import org.tizen.nativeplatform.builder.build.IBuildCommandProvider;
import org.tizen.nativeplatform.builder.build.gbs.GBSAddtionalOptionManager;
import org.tizen.nativeplatform.builder.build.gbs.GBSOption;
import org.tizen.nativeplatform.builder.build.gbs.GBSOptionManager;
import org.tizen.nativeplatform.builder.build.gbs.GBSUtil;

public class GBSBuildConfigurationTab
extends AbstractCBuildPropertyTab {
    private static Label defaultStatictext = null;
    private static Text additionalUsertext = null;
    private static String userOption = "";
    private Button option_clean = null;
    private Button option_ccache = null;
    private Button option_overwrite = null;
    private Button option_includeall = null;
    private Button option_skipRepos = null;
    private Button option_noConfigure = null;
    private Button option_keepPacks = null;
    private Button option_noinit = null;
    private Button option_incremental = null;
    private Button extraPkgBt = null;
    private Text extraPkgtext = null;
    private static final String DEFAULT_GBS_OPTION = "Default GBS Option";
    private static final String ADDTIONAL_GBS_OPTION = "Addtional Option";
    private static final String FULL_GBS_BUILD_COMMAND = "GBS build command";
    private static final String EMPTY_STRING = "";
    private static final String PREFIX_DESC = ": ";
    private static final String ERROR_LABEL = "Check if GBS(>= %s) is installed.";
    private static final String EXTRA_PKGS_OP = "--extra-packs";
    private final String[] avaiableOptions = new String[]{"--clean", "--ccache", "--overwrite", "--include-all", "--skip-conf-repos", "--no-configure", "--keep-packs", "--noinit", "--incremental"};
    private final boolean[] checkOptions = new boolean[9];
    private final Button[] buttons = new Button[]{this.option_clean, this.option_ccache, this.option_overwrite, this.option_includeall, this.option_skipRepos, this.option_noConfigure, this.option_keepPacks, this.option_noinit, this.option_incremental};
    private Text[] texts = new Text[9];

    public void createControls(Composite _parent, ICPropertyProvider _provider) {
        this.page = _provider;
        if (this.canBeVisible()) {
            this.createControls(_parent);
        }
    }

    protected void createControls(Composite parent) {
        super.createControls(parent);
        this.usercomp.setLayout((Layout)new GridLayout(1, false));
        if (!GBSOptionManager.isInitialized()) {
            GBSOptionManager.initOptions();
        }
        if (GBSOptionManager.getOptions().isEmpty()) {
            this.createErrorComposite(this.usercomp);
            return;
        }
        Composite composite = new Composite(this.usercomp, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        GridData gd = new GridData(1, 4, false, false);
        gd.widthHint = 800;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)gd);
        this.createLabelforDefaultGBSOption(composite);
        this.createCleanOption(composite, 0);
        this.createCcacheOption(composite, 1);
        this.createOverwriteOption(composite, 2);
        this.createIncludeAllOption(composite, 3);
        this.createSkipReposOption(composite, 4);
        this.createNoConfigureOption(composite, 5);
        this.createKeepPacksOption(composite, 6);
        this.createNoInitOption(composite, 7);
        this.createIncrementalOption(composite, 8);
        this.createExtraPkgOption(composite);
        this.createTextforAddtionalOption(composite);
        this.createTextforGBSbuildcommand(composite);
    }

    private void createErrorComposite(Composite parent) {
        Composite composite = new Composite(this.usercomp, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        GridData gd = new GridData(1, 4, false, false);
        gd.widthHint = 800;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)gd);
        Label errorLabel = new Label(composite, 0);
        errorLabel.setText(String.format(ERROR_LABEL, Double.toString(GBSOptionManager.MIN_GBS_VERSION)));
    }

    private void createCcacheOption(Composite parent, int index) {
        this.createOption(parent, index);
    }

    private void createCleanOption(Composite parent, int index) {
        this.createOption(parent, index);
    }

    private void createOverwriteOption(Composite parent, int index) {
        this.createOption(parent, index);
    }

    private void createIncludeAllOption(Composite parent, int index) {
        this.createOption(parent, index);
    }

    private void createSkipReposOption(Composite parent, int index) {
        this.createOption(parent, index);
    }

    private void createNoConfigureOption(Composite parent, int index) {
        this.createOption(parent, index);
    }

    private void createKeepPacksOption(Composite parent, int index) {
        this.createOption(parent, index);
    }

    private void createNoInitOption(Composite parent, int index) {
        this.createOption(parent, index);
    }

    private void createIncrementalOption(Composite parent, int index) {
        this.createOption(parent, index);
    }

    private void createExtraPkgOption(Composite parent) {
        Label pkgL = new Label(parent, 0);
        pkgL.setText(EXTRA_PKGS_OP);
        this.extraPkgtext = new Text(parent, 2048);
        this.extraPkgtext.setLayoutData((Object)new GridData(768));
    }

    private void createLabelforDefaultGBSOption(Composite parent) {
        Label defaultOptionlabel = new Label(parent, 0);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        defaultOptionlabel.setLayoutData((Object)gd);
        defaultOptionlabel.setText(DEFAULT_GBS_OPTION + GBSUtil.getGBSVersion());
        defaultOptionlabel.setFont(this.getBoldFont(defaultOptionlabel));
    }

    private Font getBoldFont(Label label) {
        FontData fontData = label.getFont().getFontData()[0];
        Font font = new Font((Device)Display.getDefault(), new FontData(fontData.getName(), fontData.getHeight(), 1));
        return font;
    }

    private void createTextforAddtionalOption(Composite parent) {
        Label addtionalOptionlabel = new Label(parent, 0);
        addtionalOptionlabel.setLayoutData((Object)new GridData(768));
        addtionalOptionlabel.setText(ADDTIONAL_GBS_OPTION);
        addtionalOptionlabel.setFont(this.getBoldFont(addtionalOptionlabel));
        additionalUsertext = new Text(parent, 2050);
        additionalUsertext.setBounds(10, 120, 100, 32);
        if (EMPTY_STRING != userOption) {
            additionalUsertext.setText(userOption);
        }
        GridData usertextGD = new GridData(1808);
        usertextGD.horizontalSpan = 2;
        additionalUsertext.setLayoutData((Object)usertextGD);
        GridData lbbutton = new GridData();
        lbbutton.horizontalAlignment = 16384;
        lbbutton.verticalAlignment = 128;
        lbbutton.horizontalSpan = 1;
        Label VariableEgString = new Label(parent, 0);
        VariableEgString.setLayoutData((Object)lbbutton);
        VariableEgString.setText("(e.g. option1=value1 option2=value2), A empty is default option");
        Button b = new Button(parent, 8);
        b.setText("Update Addtional Option");
        GridData gdbutton = new GridData();
        gdbutton.horizontalAlignment = 131072;
        gdbutton.verticalAlignment = 128;
        gdbutton.horizontalSpan = 1;
        b.setLayoutData((Object)gdbutton);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IConfiguration cfg = GBSBuildConfigurationTab.this.getCfg();
                GBSAddtionalOptionManager.resetUserAddtionalOption(cfg);
                String s = additionalUsertext.getText();
                GBSAddtionalOptionManager.saveUserAddtionalOptWithoutavaiableOpt(s, Arrays.asList(GBSBuildConfigurationTab.this.avaiableOptions), GBSBuildConfigurationTab.this.getCfg());
                defaultStatictext.setText(GBSBuildConfigurationTab.this.getGBSbuildCommand());
            }
        });
    }

    private void createTextforGBSbuildcommand(Composite parent) {
        Label buildCommandlabel = new Label(parent, 0);
        GridData gdlabel = new GridData(2);
        gdlabel.horizontalSpan = 2;
        buildCommandlabel.setLayoutData((Object)gdlabel);
        buildCommandlabel.setText(FULL_GBS_BUILD_COMMAND);
        buildCommandlabel.setFont(this.getBoldFont(buildCommandlabel));
        defaultStatictext = new Label(parent, 64);
        Display display = Display.getCurrent();
        Color bg = display.getSystemColor(34);
        defaultStatictext.setBackground(bg);
        GridData gd = new GridData(768);
        gd.widthHint = 600;
        gd.horizontalSpan = 2;
        defaultStatictext.setLayoutData((Object)gd);
        defaultStatictext.setText(this.getGBSbuildCommand());
    }

    private String getGBSbuildCommand() {
        IConfiguration config = this.getCfg();
        IBuildCommandProvider provider = PlatformInstances.getBuildCommandProvider(config, IBuildCommandProvider.BUILDTOOL.GBS.toString());
        String defaultCommand = provider.getGBSDefaultCommand();
        provider = null;
        return defaultCommand;
    }

    private void createOption(Composite parent, final int index) {
        GBSOption op = GBSOptionManager.getOption(this.avaiableOptions[index]);
        if (op == null) {
            return;
        }
        this.buttons[index] = new Button(parent, 32);
        this.buttons[index].setText(op.getOption());
        this.buttons[index].setSelection(this.checkOptions[index]);
        this.buttons[index].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                if (button.getSelection()) {
                    if (!GBSBuildConfigurationTab.this.isMultiConfiguration()) {
                        PlatformConfigurationManager.addGBSOptions((IConfiguration)GBSBuildConfigurationTab.this.getCfg(), (String)GBSBuildConfigurationTab.this.avaiableOptions[index]);
                    }
                    ((GBSBuildConfigurationTab)GBSBuildConfigurationTab.this).checkOptions[index] = true;
                } else {
                    if (!GBSBuildConfigurationTab.this.isMultiConfiguration()) {
                        PlatformConfigurationManager.removeGBSOptions((IConfiguration)GBSBuildConfigurationTab.this.getCfg(), (String)GBSBuildConfigurationTab.this.avaiableOptions[index]);
                    }
                    ((GBSBuildConfigurationTab)GBSBuildConfigurationTab.this).checkOptions[index] = false;
                }
                defaultStatictext.setText(GBSBuildConfigurationTab.this.getGBSbuildCommand());
            }
        });
        GridData gd = new GridData(2);
        this.buttons[index].setLayoutData((Object)gd);
        Label desc = new Label(parent, 0);
        desc.setLayoutData((Object)new GridData(768));
        desc.setText(this.getDesc(op));
    }

    protected void performOK() {
        if (this.isMultiConfiguration()) {
            ArrayList<String> newOptions = new ArrayList<String>();
            int i = 0;
            while (i < this.avaiableOptions.length) {
                boolean checked = this.checkOptions[i];
                if (checked) {
                    String option = EMPTY_STRING;
                    if (this.texts[i] != null) {
                        String value = this.texts[i].getText();
                        option = String.format("%s=%s", this.avaiableOptions[i], value);
                    } else {
                        option = this.avaiableOptions[i];
                    }
                    newOptions.add(option);
                }
                ++i;
            }
            String op = this.extraPkgtext.getText();
            if (!op.isEmpty()) {
                String fullOp = "--extra-packs=" + op;
                newOptions.add(fullOp);
            }
            PlatformConfigurationManager.setGBSOptions((IConfiguration)this.getCfg(), newOptions);
        } else {
            String op = this.extraPkgtext.getText();
            PlatformConfigurationManager.removeGBSOptions((IConfiguration)this.getCfg(), (String)EXTRA_PKGS_OP);
            if (!op.isEmpty()) {
                String fullOp = "--extra-packs=" + op;
                PlatformConfigurationManager.addGBSOptions((IConfiguration)this.getCfg(), (String)fullOp);
            }
        }
    }

    public boolean canBeVisible() {
        String projectArtifactType;
        IManagedProject managedProject = this.getCfg().getManagedProject();
        String string = projectArtifactType = managedProject.getProjectType() != null ? managedProject.getProjectType().getBuildArtefactType().getId() : null;
        return projectArtifactType != null && projectArtifactType.equals("org.tizen.nativeide.buildArtefactType.platform");
    }

    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
    }

    protected void performDefaults() {
    }

    protected void updateData(ICResourceDescription cfg) {
        if (this.isMultiConfiguration()) {
            int i = 0;
            while (i < this.avaiableOptions.length) {
                this.initControl(i);
                ++i;
            }
        } else {
            IConfiguration conf = this.getCfg();
            ArrayList options = PlatformConfigurationManager.getGBSOptions((IConfiguration)conf);
            int i = 0;
            while (i < this.avaiableOptions.length) {
                this.initControl(i);
                String op = this.avaiableOptions[i];
                for (String s : options) {
                    String[] strs = s.split("=");
                    if ((s = strs[0].trim()).equals(op)) {
                        this.checkOptions[i] = true;
                        this.buttons[i].setSelection(true);
                        if (this.texts[i] == null) continue;
                        this.texts[i].setEnabled(true);
                        if (strs.length != 2) continue;
                        this.texts[i].setText(strs[1]);
                        continue;
                    }
                    if (!s.equals(EXTRA_PKGS_OP) || strs.length <= 1) continue;
                    this.extraPkgtext.setText(strs[1]);
                }
                ++i;
            }
        }
    }

    private void initControl(int index) {
        this.checkOptions[index] = false;
        this.buttons[index].setSelection(false);
        if (this.texts[index] != null) {
            this.texts[index].setEnabled(false);
            this.texts[index].setText(EMPTY_STRING);
        }
    }

    private boolean isMultiConfiguration() {
        IConfiguration config = this.getCfg();
        return config instanceof MultiConfiguration;
    }

    private String getDesc(GBSOption op) {
        return PREFIX_DESC + this.filterDesc(op.getDesc());
    }

    protected void updateButtons() {
    }

    private String filterDesc(String desc) {
        if (desc.length() > 85) {
            int index = desc.indexOf(" ", 85);
            if (index < 85) {
                return desc;
            }
            String desc1 = desc.substring(0, index);
            String desc2 = desc.substring(index).trim();
            return String.valueOf(desc1) + "\n  " + this.filterDesc(desc2);
        }
        return desc;
    }
}

