/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.valgrind.launch;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.ui.newui.CDTPropertyManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.linuxtools.profiling.launch.ProfileLaunchPlugin;
import org.eclipse.linuxtools.profiling.launch.ProfileLaunchShortcut;
import org.eclipse.linuxtools.valgrind.core.ValgrindCommand;
import org.eclipse.linuxtools.valgrind.launch.CommandManager;
import org.eclipse.linuxtools.valgrind.launch.IValgrindLaunchDelegate;
import org.eclipse.linuxtools.valgrind.launch.Messages;
import org.eclipse.linuxtools.valgrind.launch.ValgrindDebugPlugin;
import org.eclipse.linuxtools.valgrind.launch.ValgrindLaunchPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.ui.view.console.ConsoleManager;
import org.tizen.common.util.RootJob;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.log.UserLogger;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.build.CommonConfigurationManager;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativecommon.launch.IProjectLaunchCommand;
import org.tizen.nativecommon.launch.LaunchUtils;
import org.tizen.nativecommon.launch.TizenLaunchCommand;
import org.tizen.nativecommon.launch.TizenLaunchDelegate;
import org.tizen.nativecommon.launch.TizenLaunchMessages;
import org.tizen.nativecommon.launch.ui.TizenLaunchDeviceSelectionDialog;
import org.tizen.nativeplatform.PlatformConfigurationManager;
import org.tizen.nativeplatform.RootstrapProxy;
import org.tizen.nativeplatform.launcher.delegate.ILaunchConfigurationProcessor;
import org.tizen.nativeplatform.launcher.delegate.LaunchConfigurationProcessor;
import org.tizen.nativeplatform.launcher.message.PlatformLaunchMessages;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.util.PlatformProjectUtil;
import org.tizen.sdblib.Arch;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.PlatformCapability;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.util.DeviceUtil;

public class TizenValgrindLaunchDelegate
extends TizenLaunchDelegate {
    protected static final String MAKE_DIRECTORY_CMD = "mkdir -p ";
    protected static final String CHANGE_DIRECTORY_CMD = "cd ";
    protected IValgrindLaunchDelegate dynamicDelegate;
    protected ValgrindCommand command;
    protected static final String EQUALS = "=";
    protected static final String EMPTY_STRING = "";
    protected static final String NO = "no";
    protected static final String YES = "yes";
    protected static final String BADA_EXT = ".exe";
    protected static final String PACKAGE_NAME = "valgrind";
    protected static final String PACKAGE_FILENAME_ARM = "valgrind_armel.deb";
    protected static final String LAUNCHPAD_LAUNCHER = "launch_app ";
    protected static final String LAUNCHPAD_SYNCMODE = " __AUL_SDK__ VALGRIND __DLP_VALGRIND_ARG__ ";
    private static final String LD_FILE_PATH = "/usr/lib/debug/lib/ld-*.so.debug";
    private static final String VALGRIND_EXECUTABLE_PATH = "/valgrind/usr/bin/valgrind";
    private static final String VALGRIND_BINARY_PATH = "/tools/user-demand";
    private static final String MOVE_WORKING_DIR_COMMAND = "cd " + TizenPlatformConstants.TOOLS_TARGET_PATH;
    private static final String REMOVE_TOOL_COMMAND = "rm -f %s";
    private static final String TAR_INSTALL_COMMAND = String.valueOf(MOVE_WORKING_DIR_COMMAND) + " && tar -xf %s" + " && " + "rm -f %s";
    private boolean userAnswer = false;
    protected String toolID;
    protected int confirmMsg = 0;
    protected IProject project;
    protected PlatformRootstrap rootstrap;
    protected PkgCommandTarget target = null;

    private String getPackageName(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        IProject iProject = ProjectUtil.getProject((ILaunchConfiguration)iLaunchConfiguration);
        IProjectLaunchCommand iProjectLaunchCommand = ProjectUtil.getProjectManifest((IProject)iProject);
        return iProjectLaunchCommand.getPackageName();
    }

    private String getExecutableName(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        String string = ProjectUtil.getExecutableName((ILaunchConfiguration)iLaunchConfiguration);
        if (string.endsWith(BADA_EXT)) {
            string = string.substring(0, string.length() - BADA_EXT.length());
        }
        return string;
    }

    public void launch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        if (ProfileLaunchPlugin.isProfiling()) {
            iProgressMonitor.done();
            ProfileLaunchShortcut.showErrorDialog((String)Messages.getString((String)"ValgrindOptionsTab.cannotrun"), (String)Messages.getString((String)"ValgrindOptionsTab.isprofiling"), null);
            return;
        }
        int n = ProfileLaunchPlugin.checkTarget();
        if (n == 0) {
            iProgressMonitor.setCanceled(true);
            ProfileLaunchShortcut.showErrorDialog((String)Messages.getString((String)"ValgrindOptionsTab.cannotrun"), (String)Messages.getString((String)"ValgrindOptionsTab.nodevice"), null);
            return;
        }
        if (!CommandManager.isExist(LD_FILE_PATH)) {
            iProgressMonitor.setCanceled(true);
            ProfileLaunchShortcut.showErrorDialog((String)Messages.getString((String)"ValgrindOptionsTab.cannotrun"), (String)Messages.getString((String)"TizenValgrindLaunchDelegate.ld_file_doesnt_exist"), null);
            return;
        }
        File file = null;
        String[] stringArray = null;
        String string2 = String.valueOf(InstallPathConfig.getSDKPath()) + VALGRIND_BINARY_PATH;
        try {
            file = new File(string2);
            if (file.isDirectory()) {
                stringArray = file.list();
                if (stringArray == null || stringArray.length < 2) {
                    this.newCoreException(null, null);
                }
            } else {
                this.newCoreException(null, null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            iProgressMonitor.setCanceled(true);
            ProfileLaunchShortcut.showErrorDialog((String)Messages.getString((String)"TizenValgrindLaunchDelegate.valgrind_warning"), (String)Messages.getString((String)"TizenValgrindLaunchDelegate.valgrind_binary_doesnt_exist"), null);
            return;
        }
        if (TizenValgrindLaunchDelegate.isPlatform30()) {
            iProgressMonitor.setCanceled(true);
            ProfileLaunchShortcut.showErrorDialog((String)Messages.getString((String)"ValgrindOptionsTab.cannotrun"), (String)Messages.getString((String)"TizenValgrindLaunchDelegate.unsupported_platform"), null);
            return;
        }
        if (!CommandManager.isExist(String.valueOf(TizenPlatformConstants.TOOLS_TARGET_PATH) + VALGRIND_EXECUTABLE_PATH)) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    TizenValgrindLaunchDelegate.this.userAnswer = MessageDialog.openQuestion(null, (String)Messages.getString((String)"TizenValgrindLaunchDelegate.valgrind_warning"), (String)Messages.getString((String)"TizenValgrindLaunchDelegate.valgrind_doesnt_exist"));
                }
            });
            if (!this.userAnswer) {
                iProgressMonitor.setCanceled(true);
                return;
            }
            if (!this.installValgrind(string2, stringArray)) {
                iProgressMonitor.setCanceled(true);
                return;
            }
        }
        try {
            ProfileLaunchPlugin.startProfiling();
            this.project = ProjectUtil.getProject((ILaunchConfiguration)iLaunchConfiguration);
            if (PlatformProjectUtil.isTizenPlatformProject((IProject)this.project)) {
                Shell shell = LaunchUIPlugin.getShell();
                int n2 = 4;
                iProgressMonitor.beginTask(EMPTY_STRING, n2);
                iProgressMonitor.subTask(TizenLaunchMessages.LAUNCH_APPLICATION);
                this.activateProgressView();
                this.verifyDeviceReachabilityForPlatform(iLaunchConfiguration, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                this.setRootstrap(iLaunchConfiguration);
                this.verifyPlatformBuildConfiguration(iLaunchConfiguration, string, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                this.setPkgCommandTarget();
                this.tizenCommand = new TizenLaunchCommand(this.currentDevice, null);
                ILaunchConfigurationProcessor iLaunchConfigurationProcessor = this.getConfigurationProcessor(shell, iLaunchConfiguration, this.project, string, this.target, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                if (!iLaunchConfigurationProcessor.process()) {
                    this.newCoreException(PlatformLaunchMessages.CANNOT_LAUNCH, null);
                }
                if (string.equals("profile")) {
                    this.launchPlatformApplicationWithValgrind(iLaunch, iLaunchConfiguration, iProgressMonitor);
                } else {
                    this.newCoreException(Messages.getString((String)"TizenValgrindLaunchDelegate.valgrind_error_message"), null);
                }
            } else if (ProjectUtil.getTizenProjectType((IProject)this.project) != null) {
                if (ProjectUtil.getTizenProjectType((IProject)this.project).isNativeProject()) {
                    if (ProjectUtil.getTizenProjectType((IProject)this.project).isImeProject()) {
                        this.newCoreException("Profiling of IME application is not supported.", null);
                    }
                    iProgressMonitor.beginTask(TizenLaunchMessages.LAUNCH_APPLICATION, 30);
                    this.activateProgressView();
                    LaunchUtils.verifyExecutableProject((IProject)ProjectUtil.getProject((ILaunchConfiguration)iLaunchConfiguration));
                    this.verifyCProjectConfigurationSettings(iLaunchConfiguration);
                    this.currentDevice = ConnectionPlugin.getDefault().getTargetToolBarManager().getDefaultLaunchTarget(this.project, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 15));
                    this.verifyBuildConfiguration(iLaunchConfiguration, string, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 11));
                    this.setConsole(iLaunchConfiguration);
                    this.tizenCommand = new TizenLaunchCommand(this.currentDevice, (ConsoleManager)this.launchConsole);
                    this.launchConsole.show();
                    if (string.equals("profile")) {
                        this.deployApplication(iLaunchConfiguration, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 9));
                        iProgressMonitor.worked(1);
                        this.launchApplicationWithValgrind(iLaunch, iLaunchConfiguration, iProgressMonitor);
                    } else {
                        this.newCoreException(Messages.getString((String)"TizenValgrindLaunchDelegate.valgrind_error_message"), null);
                    }
                } else {
                    ProjectUtil.getTizenProjectType((IProject)this.project).isWebProject();
                }
            }
        }
        finally {
            if (PlatformProjectUtil.isTizenPlatformProject((IProject)this.project)) {
                if (!iLaunch.isTerminated()) {
                    iLaunch.terminate();
                }
                ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
                iLaunchManager.removeLaunch(iLaunch);
                UserLogger.end((String)"platform.launch");
            }
            iProgressMonitor.done();
            ProfileLaunchPlugin.stopProfiling();
        }
    }

    private boolean installValgrind(String string, String[] stringArray) {
        String string2;
        int n;
        String string3 = null;
        if (CommandManager.isEmulator()) {
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                string2 = stringArray2[n];
                if (string2.startsWith(PACKAGE_NAME) && string2.contains("i386")) {
                    string3 = String.valueOf(string2);
                    break;
                }
                ++n;
            }
        } else {
            String[] stringArray3 = stringArray;
            int n3 = stringArray.length;
            n = 0;
            while (n < n3) {
                string2 = stringArray3[n];
                if (string2.startsWith(PACKAGE_NAME) && string2.contains("armel")) {
                    string3 = String.valueOf(string2);
                    break;
                }
                ++n;
            }
        }
        if (!CommandManager.push(String.valueOf(string) + File.separator + string3, TizenPlatformConstants.TOOLS_TARGET_PATH)) {
            ProfileLaunchShortcut.showErrorDialog((String)Messages.getString((String)"TizenValgrindLaunchDelegate.valgrind_warning"), (String)Messages.getString((String)"TizenValgrindLaunchDelegate.failed_to_valgrind_installation"), null);
            return false;
        }
        string2 = String.format(TAR_INSTALL_COMMAND, string3, String.valueOf(string3) + "; echo cmd_ret:$?;");
        class InstallJob
        implements RootJob {
            private boolean isSuccess = false;
            private final /* synthetic */ String val$unzipCmd;

            InstallJob(String string) {
                this.val$unzipCmd = string;
            }

            public void run() {
                try {
                    if (CommandManager.isRunSuccessfuly(CommandManager.runCommandReturningResult(this.val$unzipCmd))) {
                        this.isSuccess = true;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.isSuccess = false;
                    return;
                }
            }

            public boolean isSuccess() {
                return this.isSuccess;
            }
        }
        InstallJob installJob = new InstallJob(string2);
        installJob.run();
        if (installJob.isSuccess()) {
            return true;
        }
        ProfileLaunchShortcut.showErrorDialog((String)Messages.getString((String)"TizenValgrindLaunchDelegate.valgrind_warning"), (String)Messages.getString((String)"TizenValgrindLaunchDelegate.failed_to_valgrind_installation"), null);
        return false;
    }

    protected void verifyDeviceReachabilityForPlatform(ILaunchConfiguration iLaunchConfiguration, IProgressMonitor iProgressMonitor) throws CoreException {
        try {
            iProgressMonitor.beginTask(TizenLaunchMessages.PREPARE_TO_LAUNCH, 1);
            iProgressMonitor.subTask(TizenLaunchMessages.PREPARE_TO_LAUNCH);
            ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfiguration.getWorkingCopy();
            final IDevice[] iDeviceArray = this.getDeploayableDevices(iLaunchConfiguration);
            IDevice iDevice = null;
            iDevice = LaunchUtils.getDeviceFromLaunchConfiguration((ILaunchConfiguration)iLaunchConfiguration, (IDevice[])iDeviceArray);
            if (iDevice == null) {
                int n = iDeviceArray.length;
                if (n == 0) {
                    this.currentDevice = null;
                } else {
                    if (n == 1) {
                        this.currentDevice = iDeviceArray[0];
                    } else {
                        SWTUtil.syncExec((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                                TizenLaunchDeviceSelectionDialog tizenLaunchDeviceSelectionDialog = new TizenLaunchDeviceSelectionDialog(shell, iDeviceArray);
                                TizenValgrindLaunchDelegate.this.currentDevice = tizenLaunchDeviceSelectionDialog.open() == 0 ? tizenLaunchDeviceSelectionDialog.getSelectedDevice() : null;
                            }
                        });
                    }
                    if (this.currentDevice != null) {
                        String string = LaunchUtils.getDeviceId((IDevice)this.currentDevice);
                        iLaunchConfigurationWorkingCopy.setAttribute("org.tizen.common.launch.device.id", string);
                        iLaunchConfigurationWorkingCopy.doSave();
                    }
                }
            } else {
                this.currentDevice = iDevice;
            }
            if (this.currentDevice == null) {
                LaunchUtils.newCoreException((String)TizenLaunchMessages.NO_TARGET, null);
            }
            if (!DeviceUtil.isOnline((IDevice)this.currentDevice)) {
                LaunchUtils.newCoreException((String)TizenLaunchMessages.NO_TARGET, null);
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private IDevice[] getDeploayableDevices(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        IDevice[] iDeviceArray = SmartDevelopmentBridge.getBridge().getDevices();
        ArrayList<IDevice> arrayList = new ArrayList<IDevice>();
        Arch arch = this.getBuildConfigurationArchitecture(iLaunchConfiguration);
        IDevice[] iDeviceArray2 = iDeviceArray;
        int n = iDeviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDevice iDevice = iDeviceArray2[n2];
            if (iDevice.getArch() == arch) {
                arrayList.add(iDevice);
            }
            ++n2;
        }
        return arrayList.toArray(new IDevice[arrayList.size()]);
    }

    protected Arch getBuildConfigurationArchitecture(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        String string = this.getBuildConfigName(iLaunchConfiguration);
        return this.getBuildConfigurationArchitecture(this.project, string);
    }

    protected Arch getBuildConfigurationArchitecture(IProject iProject, String string) throws CoreException {
        IConfiguration iConfiguration = this.getBuildConfiguration(string, iProject);
        String string2 = PlatformConfigurationManager.getArchitecture((IConfiguration)iConfiguration);
        if (LaunchUtils.isX86((String)string2)) {
            return Arch.X86;
        }
        return Arch.ARM;
    }

    protected void setRootstrap(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        String string = this.getBuildConfigName(iLaunchConfiguration);
        IConfiguration iConfiguration = this.getBuildConfiguration(string, this.project);
        String string2 = PlatformConfigurationManager.getBuildTargetName((IConfiguration)iConfiguration);
        if (string2 == null) {
            this.newCoreException(Messages.getString((String)"TizenValgrindLaunchDelegate.failed_to_get_build_target_name"), null);
        }
        String string3 = SmartBuildInterface.getInstance().getRootstrapIDFromTargetID(string2);
        this.rootstrap = RootstrapProxy.getProxy().getRootstrap(string3);
    }

    protected void verifyPlatformBuildConfiguration(ILaunchConfiguration iLaunchConfiguration, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.beginTask(EMPTY_STRING, 1);
        iProgressMonitor.subTask(TizenLaunchMessages.PREPARE_TO_LAUNCH);
        String string2 = this.getBuildConfigName(iLaunchConfiguration);
        IConfiguration iConfiguration = this.getBuildConfiguration(string2, this.project);
        String string3 = CommonConfigurationManager.getArchitecture((IConfiguration)iConfiguration);
        if (this.currentDevice.isEmulator() && this.currentDevice.getArch() == Arch.X86) {
            if (!PlatformConfigurationManager.isEmulatorArch((String)string3)) {
                this.resolveProblematicConfiguration(iLaunchConfiguration, "i386");
            }
        } else if (!PlatformConfigurationManager.isDeviceArch((String)string3)) {
            this.resolveProblematicConfiguration(iLaunchConfiguration, "armel");
        }
        iProgressMonitor.worked(1);
        iProgressMonitor.done();
    }

    protected void resolveProblematicConfiguration(ILaunchConfiguration iLaunchConfiguration, final String string) throws CoreException {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                TizenValgrindLaunchDelegate.this.selectedConfig = TizenValgrindLaunchDelegate.this.selectBuildConfiguration(TizenValgrindLaunchDelegate.this.project, string);
            }
        });
        if (this.selectedConfig == null) {
            this.newCoreException(TizenLaunchMessages.BUILD_CONFIGURATION_DOES_NOT_MATCH_WITH_CURRENT_DEVICE_TYPE, null);
        }
        ICProjectDescription iCProjectDescription = CDTPropertyManager.getProjectDescription((IProject)this.project);
        ICConfigurationDescription iCConfigurationDescription = iCProjectDescription.getConfigurationByName(this.selectedConfig.getName());
        ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfiguration.getWorkingCopy();
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", iCConfigurationDescription.getConfiguration().getId());
        iLaunchConfigurationWorkingCopy.doSave();
    }

    protected IConfiguration selectBuildConfiguration(IProject iProject, String string) {
        IConfiguration iConfiguration;
        Shell shell = LaunchUIPlugin.getShell();
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object object) {
                IConfiguration iConfiguration = (IConfiguration)object;
                return iConfiguration.getName();
            }
        };
        LabelProvider labelProvider2 = new LabelProvider(){

            public String getText(Object object) {
                IConfiguration iConfiguration = (IConfiguration)object;
                return iConfiguration.getName();
            }
        };
        TwoPaneElementSelector twoPaneElementSelector = new TwoPaneElementSelector(shell, (ILabelProvider)labelProvider, (ILabelProvider)labelProvider2);
        twoPaneElementSelector.setTitle("Select a new build configuration");
        twoPaneElementSelector.setMessage("Build configuration doesn't match with current active device.\nSelect a new build configuration to launch");
        ArrayList<IConfiguration> arrayList = new ArrayList<IConfiguration>(0);
        if (ManagedBuildManager.getBuildInfo((IResource)iProject) != null && ManagedBuildManager.getBuildInfo((IResource)iProject).getManagedProject() != null) {
            IConfiguration iConfiguration2 = iConfiguration = ManagedBuildManager.getBuildInfo((IResource)iProject).getManagedProject().getConfigurations();
            int n = ((IConfiguration)iConfiguration2).length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration iConfiguration3 = iConfiguration2[n2];
                String string2 = CommonConfigurationManager.getArchitecture((IConfiguration)iConfiguration3);
                if (string2 != null && string2.equals(string)) {
                    arrayList.add(iConfiguration3);
                }
                ++n2;
            }
        }
        twoPaneElementSelector.setElements(arrayList.toArray());
        if (twoPaneElementSelector.open() == 0) {
            iConfiguration = (IConfiguration)twoPaneElementSelector.getFirstResult();
            return iConfiguration;
        }
        return null;
    }

    protected void setPkgCommandTarget() {
        this.target = new PkgCommandTarget(PlatformProjectUtil.getPkgType(), this.currentDevice, this.rootstrap);
    }

    protected ILaunchConfigurationProcessor getConfigurationProcessor(Shell shell, ILaunchConfiguration iLaunchConfiguration, IProject iProject, String string, PkgCommandTarget pkgCommandTarget, IProgressMonitor iProgressMonitor) {
        return new LaunchConfigurationProcessor(shell, iLaunchConfiguration, iProject, string, pkgCommandTarget, iProgressMonitor);
    }

    /*
     * Exception decompiling
     */
    protected void launchApplicationWithValgrind(ILaunch var1_1, ILaunchConfiguration var2_2, IProgressMonitor var3_3) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected void launchPlatformApplicationWithValgrind(ILaunch var1_1, ILaunchConfiguration var2_2, IProgressMonitor var3_3) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void runApplication(ILaunchConfiguration iLaunchConfiguration, ILaunch iLaunch, String string, String string2, IProgressMonitor iProgressMonitor) throws ValgrindCanceledException, CoreException {
        Process process = CommandManager.runApplication(string);
        if (process == null) {
            this.newCoreException(Messages.getString((String)"TizenValgrindLaunchDelegate.valgrind_error_message"), null);
        }
        IProcess iProcess = null;
        try {
            IPath iPath = CDebugUtils.verifyProgramPath((ILaunchConfiguration)iLaunchConfiguration);
            if (iPath == null) {
                this.newCoreException(Messages.getString((String)"TizenValgrindLaunchDelegate.valgrind_error_message"), null);
            }
            if ((iProcess = ValgrindDebugPlugin.newProcess(iLaunch, process, iPath.toFile().getName(), string2)) == null) {
                this.newCoreException(Messages.getString((String)"TizenValgrindLaunchDelegate.valgrind_error_message"), null);
            }
            while (true) {
                if (iProgressMonitor.isCanceled()) {
                    process.destroy();
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            MessageBox messageBox = new MessageBox(iWorkbenchWindow.getShell(), 40);
                            messageBox.setMessage(Messages.getString((String)"ValgrindLaunchPlugin.Confirm_cancel"));
                            messageBox.open();
                        }
                    });
                    throw new ValgrindCanceledException();
                }
                if (iProcess.isTerminated()) {
                    iProgressMonitor.worked(2);
                    break;
                }
                Thread.sleep(250L);
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void runPlatformApplication(ILaunchConfiguration iLaunchConfiguration, ILaunch iLaunch, String string, String string2, IProgressMonitor iProgressMonitor) throws ValgrindCanceledException, CoreException {
        Process process = CommandManager.runApplication(string);
        if (process == null) {
            this.newCoreException(Messages.getString((String)"TizenValgrindLaunchDelegate.valgrind_error_message"), null);
        }
        try {
            IProcess iProcess = ValgrindDebugPlugin.newProcess(iLaunch, process, CDebugUtils.getProjectName((ILaunchConfiguration)iLaunchConfiguration), string2);
            if (iProcess == null) {
                this.newCoreException(Messages.getString((String)"TizenValgrindLaunchDelegate.valgrind_error_message"), null);
            }
            while (true) {
                if (iProgressMonitor.isCanceled()) {
                    process.destroy();
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            MessageBox messageBox = new MessageBox(iWorkbenchWindow.getShell(), 40);
                            messageBox.setMessage(Messages.getString((String)"ValgrindLaunchPlugin.Confirm_cancel"));
                            messageBox.open();
                        }
                    });
                    throw new ValgrindCanceledException();
                }
                if (iProcess.isTerminated()) {
                    iProgressMonitor.worked(2);
                    break;
                }
                Thread.sleep(250L);
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private String[] getValgrindArgumentsArray(ILaunchConfiguration iLaunchConfiguration) throws IOException, CoreException {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("--tool=" + ValgrindLaunchPlugin.getDefault().getToolName(this.toolID));
        arrayList.add("--trace-children=" + (iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_TRACECHILD", false) ? YES : NO));
        arrayList.add("--child-silent-after-fork=yes");
        arrayList.add("--run-libc-freeres=" + (iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_FREERES", true) ? YES : NO));
        arrayList.add("--demangle=" + (iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_DEMANGLE", true) ? YES : NO));
        arrayList.add("--num-callers=" + iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_NUMCALLERS", 12));
        arrayList.add("--error-limit=" + (iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_ERRLIMIT", true) ? YES : NO));
        arrayList.add("--show-below-main=" + (iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_BELOWMAIN", false) ? YES : NO));
        arrayList.add("--max-stackframe=" + iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_MAXFRAME", 2000000));
        String string = iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_SUPPFILE", EMPTY_STRING);
        if (!string.equals(EMPTY_STRING) && (stringArray = ValgrindLaunchPlugin.getDefault().parseWSPath(string)) != null) {
            String string2 = null;
            try {
                string2 = ValgrindLaunchPlugin.getDefault().escapeAndQuote(stringArray.getCanonicalPath());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            arrayList.add("--suppressions=" + string2);
        }
        arrayList.addAll(Arrays.asList(this.dynamicDelegate.getCommandArray(this.command, iLaunchConfiguration)));
        stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    protected String getTool(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        return iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.launch.TOOL", "org.eclipse.linuxtools.valgrind.launch.memcheck");
    }

    protected String getPluginID() {
        return "org.eclipse.linuxtools.valgrind.launch";
    }

    protected String createLaunchStr(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        return String.valueOf(iLaunchConfiguration.getName()) + " [" + ValgrindLaunchPlugin.getDefault().getToolName(this.toolID) + "] ";
    }

    private static boolean isPlatform30() {
        try {
            PlatformCapability platformCapability = ConnectionPlugin.getDefault().getCurrentDevice().getPlatformCapability();
            return "enabled".equals(platformCapability.getMultiuserSupport());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    static class ValgrindCanceledException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

