/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.profiler.codecoverage.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class DocumentChangeListener
implements IDocumentListener {
    public void documentAboutToBeChanged(DocumentEvent documentEvent) {
    }

    public void documentChanged(DocumentEvent documentEvent) {
        IDocument iDocument = documentEvent.getDocument();
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return;
        }
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage == null) {
            return;
        }
        IEditorPart iEditorPart = iWorkbenchPage.getActiveEditor();
        if (iEditorPart == null) {
            return;
        }
        if (!(iEditorPart instanceof ITextEditor)) {
            return;
        }
        ITextEditor iTextEditor = (ITextEditor)iEditorPart;
        IEditorInput iEditorInput = iTextEditor.getEditorInput();
        IFile iFile = (IFile)iEditorInput.getAdapter(IFile.class);
        if (iDocument == null || iFile == null) {
            return;
        }
        IProject iProject = iFile.getProject();
        try {
            IMarker[] iMarkerArray = iProject.findMarkers("codecoverage.CoverageAnnotation", true, 2);
            if (iMarkerArray.length > 0) {
                iProject.deleteMarkers("codecoverage.CoverageAnnotation", true, 2);
            }
            if ((iMarkerArray = iProject.findMarkers("codecoverage.NoCoverageAnnotation", true, 2)).length > 0) {
                iProject.deleteMarkers("codecoverage.NoCoverageAnnotation", true, 2);
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }
}

