/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.valgrind.launch;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.profiling.launch.ProfileLaunchPlugin;
import org.eclipse.linuxtools.valgrind.launch.Messages;
import org.eclipse.linuxtools.valgrind.launch.ValgrindLaunchPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class ValgrindOptionsTab
extends AbstractLaunchConfigurationTab {
    protected static final String EMPTY_STRING = "";
    private ScrolledComposite scrContainer;
    protected Button collectData1Button;
    protected Button collectData2Button;
    protected Button mempsButton;
    protected Button traceChildrenButton;
    protected Button childSilentButton;
    protected Button runFreeresButton;
    protected Button demangleButton;
    protected Spinner numCallersSpinner;
    protected Button errorLimitButton;
    protected Button showBelowMainButton;
    protected Spinner maxStackFrameSpinner;
    protected Text suppFileText;
    protected String tool;
    protected String[] tools;
    protected Combo toolsCombo;
    protected Composite top;
    protected ScrolledComposite scrollTop;
    protected ILaunchConfigurationWorkingCopy launchConfigurationWorkingCopy;
    protected ILaunchConfiguration launchConfiguration;
    protected ILaunchConfigurationTab dynamicTab;
    protected Composite dynamicTabHolder;
    protected boolean isInitializing = false;
    protected boolean initDefaults = false;
    private boolean canInitialize;
    protected SelectionListener selectListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            ValgrindOptionsTab.this.updateLaunchConfigurationDialog();
        }
    };
    protected ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            ValgrindOptionsTab.this.updateLaunchConfigurationDialog();
        }
    };

    public void createControl(Composite composite) {
        int n = ProfileLaunchPlugin.checkTarget();
        if (n == 0) {
            Composite composite2 = new Composite(composite, 0);
            this.setControl((Control)composite2);
            composite2.setLayout((Layout)new GridLayout());
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), EMPTY_STRING);
            Label label = new Label(composite2, 16384);
            String string = Messages.getString("ValgrindOptionsTab.nodevice");
            label.setText(string);
            this.canInitialize = false;
            return;
        }
        this.canInitialize = true;
        this.scrContainer = new ScrolledComposite(composite, 768);
        FillLayout fillLayout = new FillLayout();
        this.scrContainer.setLayout((Layout)fillLayout);
        GridData gridData = new GridData(1808);
        this.scrContainer.setLayoutData((Object)gridData);
        this.scrContainer.setExpandHorizontal(true);
        this.scrContainer.setExpandVertical(true);
        this.top = new Composite((Composite)this.scrContainer, 0);
        this.setControl((Control)this.scrContainer);
        this.top.setLayout((Layout)new GridLayout());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), EMPTY_STRING);
        this.createVerticalSpacer(this.top, 1);
        this.createVerticalSpacer(this.top, 1);
        TabFolder tabFolder = new TabFolder(this.top, 2048);
        tabFolder.setLayoutData((Object)new GridData(1808));
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Messages.getString("ValgrindOptionsTab.Start"));
        Composite composite3 = new Composite((Composite)tabFolder, 0);
        composite3.setLayout((Layout)new GridLayout());
        composite3.setLayoutData((Object)new GridData(1808));
        this.createStartOptions(composite3, true);
        this.createVerticalSpacer(composite3, 1);
        tabItem.setControl((Control)composite3);
        TabItem tabItem2 = new TabItem(tabFolder, 0);
        tabItem2.setText(Messages.getString("ValgrindOptionsTab.General"));
        Composite composite4 = new Composite((Composite)tabFolder, 0);
        composite4.setLayout((Layout)new GridLayout());
        composite4.setLayoutData((Object)new GridData(1808));
        this.createBasicOptions(composite4);
        this.createVerticalSpacer(composite4, 1);
        this.createErrorOptions(composite4);
        this.createVerticalSpacer(composite4, 1);
        this.createSuppressionsOption(composite4);
        tabItem2.setControl((Control)composite4);
        TabItem tabItem3 = new TabItem(tabFolder, 0);
        tabItem3.setText(Messages.getString("ValgrindOptionsTab.Tool"));
        this.dynamicTabHolder = new Composite((Composite)tabFolder, 0);
        this.dynamicTabHolder.setLayout((Layout)new GridLayout());
        this.dynamicTabHolder.setLayoutData((Object)new GridData(1808));
        tabItem3.setControl((Control)this.dynamicTabHolder);
        this.scrContainer.setContent((Control)this.top);
        this.scrContainer.setMinSize(this.top.computeSize(-1, -1));
    }

    protected void createStartOptions(Composite composite, boolean bl) {
        this.tools = ValgrindLaunchPlugin.getDefault().getRegisteredToolIDs();
        String[] stringArray = new String[this.tools.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = ValgrindLaunchPlugin.getDefault().getToolName(this.tools[n]);
            ++n;
        }
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(Messages.getString("ValgrindOptionsTab.Collect_Options"));
        Composite composite2 = new Composite((Composite)group, 0);
        composite2.setLayout((Layout)new GridLayout(8, false));
        composite2.setLayoutData((Object)new GridData(768));
        this.collectData1Button = new Button(composite2, 16);
        this.collectData1Button.setText(Messages.getString("ValgrindOptionsTab.collect_data1"));
        this.collectData1Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                ValgrindOptionsTab.this.canInitialize = true;
                if (!ValgrindOptionsTab.this.canInitialize) {
                    return;
                }
                if (!ValgrindOptionsTab.this.isInitializing) {
                    ValgrindOptionsTab.this.tool = "org.eclipse.linuxtools.valgrind.launch.memcheck";
                    ValgrindOptionsTab.this.handleToolChanged();
                    ValgrindOptionsTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.collectData2Button = new Button(composite2, 16);
        this.collectData2Button.setText(Messages.getString("ValgrindOptionsTab.collect_data2"));
        this.collectData2Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!ValgrindOptionsTab.this.isInitializing) {
                    ValgrindOptionsTab.this.tool = "org.eclipse.linuxtools.valgrind.launch.massif";
                    ValgrindOptionsTab.this.handleToolChanged();
                    ValgrindOptionsTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
    }

    protected void createBasicOptions(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(Messages.getString("ValgrindOptionsTab.Basic_Options"));
        Composite composite2 = new Composite((Composite)group, 0);
        composite2.setLayout((Layout)new GridLayout(2, true));
        composite2.setLayoutData((Object)new GridData(768));
        this.traceChildrenButton = new Button(composite2, 32);
        this.traceChildrenButton.setText(Messages.getString("ValgrindOptionsTab.trace_children"));
        this.traceChildrenButton.addSelectionListener(this.selectListener);
        this.traceChildrenButton.setLayoutData((Object)new GridData(768));
        this.childSilentButton = new Button(composite2, 32);
        this.childSilentButton.setText(Messages.getString("ValgrindOptionsTab.child_silent"));
        this.childSilentButton.setSelection(true);
        this.childSilentButton.setEnabled(false);
        this.childSilentButton.setLayoutData((Object)new GridData(768));
        this.runFreeresButton = new Button(composite2, 32);
        this.runFreeresButton.setText(Messages.getString("ValgrindOptionsTab.run_freeres"));
        this.runFreeresButton.addSelectionListener(this.selectListener);
        this.runFreeresButton.setLayoutData((Object)new GridData(768));
    }

    protected void createErrorOptions(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(Messages.getString("ValgrindOptionsTab.Error_Options"));
        Composite composite2 = new Composite((Composite)group, 0);
        composite2.setLayout((Layout)new GridLayout(2, true));
        composite2.setLayoutData((Object)new GridData(768));
        this.demangleButton = new Button(composite2, 32);
        this.demangleButton.setText(Messages.getString("ValgrindOptionsTab.demangle"));
        this.demangleButton.addSelectionListener(this.selectListener);
        this.demangleButton.setLayoutData((Object)new GridData(768));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite3, 0);
        label.setText(Messages.getString("ValgrindOptionsTab.num_callers"));
        this.numCallersSpinner = new Spinner(composite3, 2048);
        this.numCallersSpinner.setMaximum(50);
        this.numCallersSpinner.addModifyListener(this.modifyListener);
        this.numCallersSpinner.setLayoutData((Object)new GridData(768));
        this.errorLimitButton = new Button(composite2, 32);
        this.errorLimitButton.setText(Messages.getString("ValgrindOptionsTab.limit_errors"));
        this.errorLimitButton.addSelectionListener(this.selectListener);
        this.errorLimitButton.setLayoutData((Object)new GridData(768));
        this.showBelowMainButton = new Button(composite2, 32);
        this.showBelowMainButton.setText(Messages.getString("ValgrindOptionsTab.show_errors_below_main"));
        this.showBelowMainButton.addSelectionListener(this.selectListener);
        this.showBelowMainButton.setLayoutData((Object)new GridData(768));
        Composite composite4 = new Composite(composite2, 0);
        composite4.setLayout((Layout)new GridLayout(2, false));
        Label label2 = new Label(composite4, 0);
        label2.setText(Messages.getString("ValgrindOptionsTab.max_size_of_stack_frame"));
        this.maxStackFrameSpinner = new Spinner(composite4, 2048);
        this.maxStackFrameSpinner.setMaximum(Integer.MAX_VALUE);
        this.maxStackFrameSpinner.addModifyListener(this.modifyListener);
        this.maxStackFrameSpinner.setLayoutData((Object)new GridData(768));
    }

    protected void createSuppressionsOption(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(Messages.getString("ValgrindOptionsTab.Suppressions"));
        Composite composite2 = new Composite((Composite)group, 0);
        composite2.setLayout((Layout)new GridLayout(4, false));
        GridData gridData = new GridData(768);
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 0);
        label.setText(Messages.getString("ValgrindOptionsTab.suppressions_file"));
        this.suppFileText = new Text(composite2, 2048);
        this.suppFileText.setLayoutData((Object)new GridData(768));
        this.suppFileText.addModifyListener(this.modifyListener);
        Button button = this.createPushButton(composite2, Messages.getString("ValgrindOptionsTab.Workspace"), null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(ValgrindOptionsTab.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                elementTreeSelectionDialog.setTitle(Messages.getString("ValgrindOptionsTab.Select_a_Resource"));
                elementTreeSelectionDialog.setMessage(Messages.getString("ValgrindOptionsTab.Select_a_Suppressions_File"));
                elementTreeSelectionDialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                elementTreeSelectionDialog.setComparator((ViewerComparator)new ResourceComparator(1));
                if (elementTreeSelectionDialog.open() == 0) {
                    IResource iResource = (IResource)elementTreeSelectionDialog.getFirstResult();
                    String string = iResource.getFullPath().toString();
                    String string2 = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", string);
                    ValgrindOptionsTab.this.suppFileText.setText(string2);
                }
            }
        });
        Button button2 = this.createPushButton(composite2, Messages.getString("ValgrindOptionsTab.File_System"), null);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = ValgrindOptionsTab.this.suppFileText.getText();
                FileDialog fileDialog = new FileDialog(ValgrindOptionsTab.this.getShell(), 8192);
                string = fileDialog.open();
                if (string != null) {
                    ValgrindOptionsTab.this.suppFileText.setText(string);
                }
            }
        });
    }

    protected void handleToolChanged() {
        try {
            this.loadDynamicArea();
            if (this.launchConfigurationWorkingCopy == null) {
                this.launchConfigurationWorkingCopy = this.launchConfiguration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)this.launchConfiguration : this.launchConfiguration.getWorkingCopy();
            }
            if (this.initDefaults) {
                this.dynamicTab.setDefaults(this.launchConfigurationWorkingCopy);
            }
            this.initDefaults = false;
            this.dynamicTab.initializeFrom((ILaunchConfiguration)this.launchConfigurationWorkingCopy);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    private void loadDynamicArea() throws CoreException {
        Control[] controlArray = this.dynamicTabHolder.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        this.dynamicTab = ValgrindLaunchPlugin.getDefault().getToolPage(this.tool);
        if (this.dynamicTab == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.valgrind.launch", String.valueOf(Messages.getString("ValgrindOptionsTab.No_options_tab_found")) + this.tool));
        }
        this.dynamicTab.setLaunchConfigurationDialog(this.getLaunchConfigurationDialog());
        this.dynamicTab.createControl(this.dynamicTabHolder);
        this.dynamicTabHolder.layout(true);
    }

    public String getName() {
        return Messages.getString("ValgrindOptionsTab.Valgrind_Options");
    }

    public Image getImage() {
        return ValgrindLaunchPlugin.imageDescriptorFromPlugin((String)"org.eclipse.linuxtools.valgrind.launch", (String)"icons/valgrind-icon.png").createImage();
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        if (!this.canInitialize) {
            return;
        }
        this.isInitializing = true;
        this.getControl().setRedraw(false);
        this.launchConfiguration = iLaunchConfiguration;
        this.launchConfigurationWorkingCopy = null;
        try {
            this.tool = iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.launch.TOOL", "org.eclipse.linuxtools.valgrind.launch.memcheck");
            int n = -1;
            if (this.tool.contains("memcheck")) {
                n = 0;
            } else if (this.tool.contains("massif")) {
                n = 1;
            }
            if (n == 0) {
                this.collectData1Button.setSelection(true);
                this.collectData2Button.setSelection(false);
            } else if (n == 1) {
                this.collectData2Button.setSelection(true);
                this.collectData1Button.setSelection(false);
            }
            this.handleToolChanged();
            this.initializeGeneral(iLaunchConfiguration);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        this.getControl().setRedraw(true);
        this.isInitializing = false;
    }

    protected void initializeGeneral(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        this.traceChildrenButton.setSelection(iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_TRACECHILD", false));
        this.runFreeresButton.setSelection(iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_FREERES", false));
        this.demangleButton.setSelection(iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_DEMANGLE", true));
        this.numCallersSpinner.setSelection(iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_NUMCALLERS", 12));
        this.errorLimitButton.setSelection(iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_ERRLIMIT", true));
        this.showBelowMainButton.setSelection(iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_BELOWMAIN", false));
        this.maxStackFrameSpinner.setSelection(iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_MAXFRAME", 2000000));
        this.suppFileText.setText(iLaunchConfiguration.getAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_SUPPFILE", EMPTY_STRING));
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        if (!this.canInitialize || ProfileLaunchPlugin.checkTarget() == 0) {
            this.setErrorMessage(Messages.getString("ValgrindOptionsTab.nodevice"));
            return false;
        }
        this.setErrorMessage(null);
        boolean bl = false;
        bl = this.isGeneralValid() && this.dynamicTab != null;
        if (bl) {
            bl = this.dynamicTab.isValid(iLaunchConfiguration);
        }
        return bl;
    }

    protected boolean isGeneralValid() {
        String string = this.suppFileText.getText();
        boolean bl = false;
        if (string.equals(EMPTY_STRING)) {
            bl = true;
        } else {
            try {
                File file = ValgrindLaunchPlugin.getDefault().parseWSPath(string);
                if (file != null && file.exists()) {
                    bl = true;
                }
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        }
        if (!bl) {
            this.setErrorMessage(NLS.bind((String)Messages.getString("ValgrindOptionsTab.suppressions_file_doesnt_exist"), (Object)string));
        }
        return bl;
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        if (!this.canInitialize || ProfileLaunchPlugin.checkTarget() == 0) {
            return;
        }
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.linuxtools.valgrind.launch.TOOL", this.tool);
        this.applyGeneralAttributes(iLaunchConfigurationWorkingCopy);
        if (this.dynamicTab != null) {
            this.dynamicTab.performApply(iLaunchConfigurationWorkingCopy);
        }
    }

    protected void applyGeneralAttributes(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_TRACECHILD", this.traceChildrenButton.getSelection());
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_FREERES", this.runFreeresButton.getSelection());
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_DEMANGLE", this.demangleButton.getSelection());
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_NUMCALLERS", this.numCallersSpinner.getSelection());
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_ERRLIMIT", this.errorLimitButton.getSelection());
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_BELOWMAIN", this.showBelowMainButton.getSelection());
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_MAXFRAME", this.maxStackFrameSpinner.getSelection());
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_SUPPFILE", this.suppFileText.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        this.launchConfigurationWorkingCopy = iLaunchConfigurationWorkingCopy;
        ValgrindOptionsTab.setDefaultGeneralAttributes(iLaunchConfigurationWorkingCopy);
        if (this.dynamicTab != null) {
            this.dynamicTab.setDefaults(iLaunchConfigurationWorkingCopy);
            this.initDefaults = false;
        }
    }

    public static void setDefaultGeneralAttributes(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.linuxtools.valgrind.launch.TOOL", "org.eclipse.linuxtools.valgrind.launch.memcheck");
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_TRACECHILD", false);
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_FREERES", false);
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_DEMANGLE", true);
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_NUMCALLERS", 12);
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_ERRLIMIT", true);
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_BELOWMAIN", false);
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_MAXFRAME", 2000000);
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.linuxtools.valgrind.launch.GENERAL_SUPPFILE", EMPTY_STRING);
    }

    public void dispose() {
        if (this.dynamicTab != null) {
            this.dynamicTab.dispose();
        }
        super.dispose();
    }

    protected void createHorizontalSpacer(Composite composite, int n) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = n;
        label.setLayoutData((Object)gridData);
    }

    protected void updateLaunchConfigurationDialog() {
        if (!this.isInitializing) {
            super.updateLaunchConfigurationDialog();
        }
    }

    public static void showErrorDialog(final String string, String string2, Exception exception) {
        String string3 = Messages.getString("ValgrindOptionsTab.Tool");
        Status status = new Status(4, string3, 0, string2, (Throwable)exception);
        Display.getDefault().syncExec(new Runnable((IStatus)status){
            private final /* synthetic */ IStatus val$status;
            {
                this.val$status = iStatus;
            }

            @Override
            public void run() {
                ErrorDialog.openError(null, (String)"Valgrind Error", (String)string, (IStatus)this.val$status);
            }
        });
    }
}

