/*
 * Decompiled with CFR 0.152.
 */
package json.util;

import json.model.node.Type;

public final class JsonCharUtility {
    public static final char openCurly = '{';
    public static final char closeCurly = '}';
    public static final char openSquare = '[';
    public static final char closeSquare = ']';
    public static final char comma = ',';
    public static final char quote = '\"';
    public static final char colon = ':';
    public static final char slash = '\\';
    public static final char minus = '-';
    public static final char point = '.';
    public static final char n = 'n';
    public static final char u = 'u';
    public static final char l = 'l';
    public static final char f = 'f';
    public static final char a = 'a';
    public static final char s = 's';
    public static final char e = 'e';
    public static final char t = 't';
    public static final char r = 'r';
    public static final char eof = '\uffff';
    public static final int space = 32;
    public static final int eol = 10;
    public static final int tab = 9;
    public static final int carriageReturn = 13;

    public static boolean isWhiteSpace(char ch) {
        return ch == ' ' || ch == '\n' || ch == '\t' || ch == '\r';
    }

    public static boolean isNotWhiteSpace(char ch) {
        return ch != ' ' && ch != '\n' && ch != '\t' && ch != '\r';
    }

    public static boolean isClosed(char ch) {
        return ch == ',' || ch == '}' || ch == ']';
    }

    public static boolean isNotClosed(char ch) {
        return ch != ',' && ch != '}' && ch != ']';
    }

    public static boolean isJsonChar(char ch, char previous) {
        return ch == ',' || ch == '{' || ch == '}' || ch == '[' || ch == ']' || ch == ':' || ch == '\"' && previous != '\\';
    }

    public static Type getJsonCharType(char ch) {
        if (ch == ',') {
            return Type.Comma;
        }
        if (ch == '{') {
            return Type.OpenObject;
        }
        if (ch == '}') {
            return Type.CloseObject;
        }
        if (ch == '[') {
            return Type.OpenArray;
        }
        if (ch == ']') {
            return Type.CloseArray;
        }
        if (ch == ':') {
            return Type.Colon;
        }
        if (ch == '\"') {
            return Type.Quote;
        }
        return null;
    }
}

