/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.unittest.wizards.filter;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTreeViewerFilter
extends ViewerFilter {
    private static final Logger logger = LoggerFactory.getLogger(FileTreeViewerFilter.class);
    private static ArrayList<String> excludingDirList = null;

    public FileTreeViewerFilter() {
        excludingDirList = new ArrayList();
        Collections.addAll(excludingDirList, "webUnitTest");
        excludingDirList.add("tizen-web-ui-fw");
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        IFile file;
        String fileExtension;
        if (element instanceof IFolder) {
            IFolder folder = (IFolder)element;
            if (parentElement instanceof IProject) {
                for (String excludingDir : excludingDirList) {
                    if (!folder.getName().equals(excludingDir)) continue;
                    return false;
                }
            }
            return this.hasJS(folder);
        }
        return !(element instanceof IFile) || "js".equals(fileExtension = (file = (IFile)element).getFileExtension());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasJS(IFolder folder) {
        try {
            IResource[] members;
            IResource[] iResourceArray = members = folder.members();
            int n = members.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IResource member = iResourceArray[n2];
                if (member instanceof IFile ? "js".equals(member.getFileExtension()) : member instanceof IFolder && this.hasJS((IFolder)member)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            logger.error(e.getMessage());
        }
        return false;
    }
}

