/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.privilege.visitor;

import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.tizen.web.privilege.core.Module;
import org.tizen.web.privilege.core.Modules;

public class JsASTVisitor
extends ASTVisitor {
    private static final String JS_EXTENSION_PROTOTYPE = ".prototype";
    private Modules modules;

    public JsASTVisitor(Modules modules) {
        this.modules = modules;
    }

    public boolean visit(FieldAccess node) {
        SimpleName simpleName;
        String fieldAccessExpression = node.getExpression().toString();
        if (fieldAccessExpression != null && fieldAccessExpression.contains(JS_EXTENSION_PROTOTYPE) && (simpleName = node.getName()) != null && simpleName.getIdentifier() != null && !simpleName.getIdentifier().trim().equals("")) {
            Module module;
            String className = this.getModuleClassName(node);
            String displayName = simpleName.getIdentifier();
            if (displayName != null && className != null && !className.trim().equals("") && (module = this.modules.getModule(className)) != null) {
                module.setSymbol(displayName);
            }
        }
        return true;
    }

    private String getModuleClassName(FieldAccess node) {
        Expression member;
        Expression rightHandSide;
        String className = "";
        ASTNode parent = node.getParent();
        if (parent instanceof Assignment && (rightHandSide = ((Assignment)parent).getRightHandSide()) instanceof ClassInstanceCreation && (member = ((ClassInstanceCreation)rightHandSide).getMember()) != null && member instanceof SimpleName) {
            className = ((SimpleName)member).getIdentifier();
        }
        return className;
    }

    public Modules getModules() {
        return this.modules;
    }
}

